/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.dao.AtInterfaceDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.LldpRemInterface;
import org.opennms.netmgt.linkd.OspfNbrInterface;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dStpGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTableEntry;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpRemTableEntry;
import org.opennms.netmgt.linkd.snmp.OspfNbrTableEntry;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTableEntry;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.OnmsVlan;

public abstract class AbstractQueryManager
implements QueryManager {
    protected Linkd m_linkd;
    private static final InetAddress m_zeroAddress = InetAddressUtils.addr((String)"0.0.0.0");

    @Override
    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    @Override
    public Linkd getLinkd() {
        return this.m_linkd;
    }

    protected void sendNewSuspectEvent(InetAddress ipaddress, InetAddress ipowner, String name) {
        this.getLinkd().sendNewSuspectEvent(ipaddress, ipowner, name);
    }

    public abstract NodeDao getNodeDao();

    public abstract IpInterfaceDao getIpInterfaceDao();

    public abstract AtInterfaceDao getAtInterfaceDao();

    public abstract SnmpInterfaceDao getSnmpInterfaceDao();

    protected abstract int getIfIndexByName(Connection var1, int var2, String var3) throws SQLException;

    protected abstract List<Integer> getNodeidFromIp(Connection var1, InetAddress var2) throws SQLException;

    protected abstract RouterInterface getNodeidMaskFromIp(Connection var1, InetAddress var2) throws SQLException;

    protected abstract RouterInterface getNodeFromIp(Connection var1, InetAddress var2) throws SQLException;

    protected abstract int getSnmpIfType(Connection var1, int var2, Integer var3) throws SQLException;

    protected abstract void saveIpRouteInterface(Connection var1, OnmsIpRouteInterface var2) throws SQLException;

    protected abstract void saveVlan(Connection var1, OnmsVlan var2) throws SQLException;

    protected abstract void saveStpNode(Connection var1, OnmsStpNode var2) throws SQLException;

    protected abstract void saveStpInterface(Connection var1, OnmsStpInterface var2) throws SQLException;

    protected abstract List<String> getPhysAddrs(int var1, DBUtils var2, Connection var3) throws SQLException;

    protected abstract void markOldDataInactive(Connection var1, Timestamp var2, int var3) throws SQLException;

    protected abstract void deleteOlderData(Connection var1, Timestamp var2, int var3) throws SQLException;

    protected OnmsNode getNode(Integer nodeId) throws SQLException {
        return (OnmsNode)this.getNodeDao().get((Serializable)nodeId);
    }

    protected void processIpNetToMediaTable(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime) throws SQLException {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpcoll.getIpNetToMediaTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processIpNetToMediaTable: Starting ipNetToMedia table processing for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processIpNetToMediaTable: Zero ipNetToMedia table entries for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        boolean trytostoreprimary = true;
        for (IpNetToMediaTableEntry ent : snmpcoll.getIpNetToMediaTable()) {
            int ifindex = ent.getIpNetToMediaIfIndex();
            if (ifindex < 0) {
                LogUtils.warnf((Object)this, (String)"processIpNetToMediaTable: invalid ifindex %s", (Object[])new Object[]{ifindex});
                continue;
            }
            InetAddress ipaddress = ent.getIpNetToMediaNetAddress();
            if (ipaddress.equals(node.getSnmpPrimaryIpAddr())) {
                trytostoreprimary = false;
            }
            String hostAddress = InetAddressUtils.str((InetAddress)ipaddress);
            if (ipaddress == null || ipaddress.isLoopbackAddress() || m_zeroAddress.equals(ipaddress)) {
                LogUtils.warnf((Object)this, (String)"processIpNetToMediaTable: invalid IP: %s", (Object[])new Object[]{ipaddress});
                continue;
            }
            String physAddr = ent.getIpNetToMediaPhysAddress();
            if (physAddr == null || physAddr.equals("000000000000") || physAddr.equalsIgnoreCase("ffffffffffff")) {
                LogUtils.warnf((Object)this, (String)"processIpNetToMediaTable: invalid MAC address %s for IP %s", (Object[])new Object[]{physAddr, hostAddress});
                continue;
            }
            LogUtils.debugf((Object)this, (String)"processIpNetToMediaTable: trying save ipNetToMedia info: IP address %s, MAC address %s, ifIndex %d", (Object[])new Object[]{hostAddress, physAddr, ifindex});
            OnmsAtInterface at = this.getAtInterfaceDao().getAtInterfaceForAddress(dbConn, ipaddress);
            if (at == null) {
                LogUtils.debugf((Object)this, (String)"processIpNetToMediaTable: no node found for IP address %s.", (Object[])new Object[]{hostAddress});
                this.sendNewSuspectEvent(ipaddress, snmpcoll.getTarget(), snmpcoll.getPackageName());
                continue;
            }
            at.setSourceNodeId(Integer.valueOf(node.getNodeId()));
            if (at.getMacAddress() != null && !at.getMacAddress().equals(physAddr)) {
                LogUtils.infof((Object)this, (String)"processIpNetToMediaTable: Setting OnmsAtInterface MAC address to %s but it used to be '%s' (IP Address = %s, ifIndex = %d)", (Object[])new Object[]{physAddr, at.getMacAddress(), hostAddress, ifindex});
            }
            at.setMacAddress(physAddr);
            if (at.getIfIndex() != null && !at.getIfIndex().equals(ifindex)) {
                LogUtils.infof((Object)this, (String)"processIpNetToMediaTable: Setting OnmsAtInterface ifIndex to %d but it used to be '%s' (IP Address = %s, MAC = %s)", (Object[])new Object[]{ifindex, at.getIfIndex(), hostAddress, physAddr});
            }
            at.setIfIndex(Integer.valueOf(ifindex));
            at.setLastPollTime((Date)scanTime);
            at.setStatus(Character.valueOf('A'));
            this.getAtInterfaceDao().saveAtInterface(dbConn, at);
            for (OnmsAtInterface onmsatinterface : this.getAtInterfaceDao().findByMacAddress(physAddr)) {
                AtInterface atinterface = new AtInterface(onmsatinterface.getNode().getId(), physAddr, at.getIpAddress());
                atinterface.setIfIndex(this.getIfIndex(onmsatinterface.getNode().getId(), at.getIpAddress().getHostAddress()));
                this.getLinkd().addAtInterface(atinterface);
            }
        }
        if (trytostoreprimary) {
            OnmsSnmpInterface snmpinterface;
            LogUtils.infof((Object)this, (String)"processIpNetToMediaTable: try to setting ifindex for linkednode primary ip address '%s' ", (Object[])new Object[]{node.getSnmpPrimaryIpAddr().getHostAddress()});
            OnmsIpInterface ipinterface = this.getIpInterfaceDao().findByNodeIdAndIpAddress(Integer.valueOf(node.getNodeId()), node.getSnmpPrimaryIpAddr().getHostAddress());
            if (ipinterface != null && (snmpinterface = ipinterface.getSnmpInterface()) != null && snmpinterface.getPhysAddr() != null) {
                AtInterface at = new AtInterface(node.getNodeId(), snmpinterface.getPhysAddr(), node.getSnmpPrimaryIpAddr());
                at.setMacAddress(snmpinterface.getPhysAddr());
                LogUtils.infof((Object)this, (String)"processIpNetToMediaTable: Setting AtInterface ifIndex to %d, for primary IP Address %s, MAC = %s)", (Object[])new Object[]{at.getIfIndex(), at.getIpAddress().getHostAddress(), at.getMacAddress()});
                at.setIfIndex(snmpinterface.getIfIndex());
                this.getLinkd().addAtInterface(at);
            }
        }
    }

    protected Integer getIfIndex(Integer nodeid, String ipaddress) {
        OnmsIpInterface ipinterface = this.getIpInterfaceDao().findByNodeIdAndIpAddress(nodeid, ipaddress);
        if (ipinterface != null && ipinterface.getIfIndex() != null) {
            LogUtils.infof((Object)this, (String)"getIfindex: found ip interface for address '%s' on ifindex %d", (Object[])new Object[]{ipinterface.getIpAddress().getHostAddress(), ipinterface.getIfIndex()});
            return ipinterface.getIfIndex();
        }
        LogUtils.infof((Object)this, (String)"getIfIndex: no (ipinterface)ifindex found for nodeid %d, address '%s'.", (Object[])new Object[]{nodeid, ipaddress});
        return -1;
    }

    protected void processOspf(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime) {
        InetAddress ospfRouterId = snmpcoll.getOspfGeneralGroup().getOspfRouterId();
        LogUtils.debugf((Object)this, (String)"processOspf: ospf node/ospfrouterid: %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfRouterId)});
        if (m_zeroAddress.equals(ospfRouterId)) {
            LogUtils.infof((Object)this, (String)"processOspf: invalid ospf ruoter id. node/ospfrouterid: %d/%s. Skipping!", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfRouterId)});
            return;
        }
        node.setOspfRouterId(ospfRouterId);
        ArrayList<OspfNbrInterface> ospfinterfaces = new ArrayList<OspfNbrInterface>();
        for (OspfNbrTableEntry ospfNbrTableEntry : snmpcoll.getOspfNbrTable()) {
            InetAddress ospfNbrRouterId = ospfNbrTableEntry.getOspfNbrRouterId();
            InetAddress ospfNbrIpAddr = ospfNbrTableEntry.getOspfNbrIpAddress();
            LogUtils.debugf((Object)this, (String)"processOspf: addind ospf node/ospfnbraddress/ospfnbrrouterid: %d/%s/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
            if (m_zeroAddress.equals(ospfNbrIpAddr) || m_zeroAddress.equals(ospfNbrRouterId)) {
                LogUtils.infof((Object)this, (String)"processOspf: ospf invalid ip address for node/ospfnbraddress/ospfnbrrouterid: %d/%s/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
                continue;
            }
            Integer ifIndex = ospfNbrTableEntry.getOspfNbrAddressLessIndex();
            LogUtils.debugf((Object)this, (String)"processOspf: ospf node/ospfnbraddress/ospfnbrrouterid/ospfnbrAddressLessIfIndex: %d/%s/%s/%d", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId), ifIndex});
            List ipinterfaces = this.getIpInterfaceDao().findByIpAddress(InetAddressUtils.str((InetAddress)ospfNbrIpAddr));
            for (OnmsIpInterface ipinterface : ipinterfaces) {
                if (ifIndex == 0) {
                    ifIndex = ipinterface.getIfIndex();
                }
                LogUtils.debugf((Object)this, (String)"processOspf: ospf node/ospfnbraddress/ospfnbrrouterid/ifIndex: %d/%s/%s/%d", (Object[])new Object[]{ipinterface.getNode().getId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId), ifIndex});
                if (ifIndex != null && ifIndex > 0) {
                    OspfNbrInterface ospfinterface = new OspfNbrInterface(ospfNbrRouterId);
                    ospfinterface.setOspfNbrNodeId(ipinterface.getNode().getId());
                    ospfinterface.setOspfNbrIpAddr(ospfNbrIpAddr);
                    ospfinterface.setOspfNbrNetMask(this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(ipinterface.getNode().getId(), ifIndex).getNetMask());
                    ospfinterface.setOspfNbrIfIndex(ifIndex);
                    LogUtils.debugf((Object)this, (String)"processOspf: adding ospf interface. node/ospfinterface: %d/%s", (Object[])new Object[]{node.getNodeId(), ospfinterface});
                    ospfinterfaces.add(ospfinterface);
                    continue;
                }
                LogUtils.infof((Object)this, (String)"processOspf: ospf invalid if index. node/ospfnbraddress/ospfnbrrouterid/ifIndex: %d/%s/%s/%d. Skipping!", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId), ifIndex});
            }
        }
        node.setOspfinterfaces(ospfinterfaces);
    }

    protected void processLldp(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime) {
        node.setLldpChassisId(snmpcoll.getLldpLocalGroup().getLldpLocChassisid());
        node.setLldpChassisIdSubtype(snmpcoll.getLldpLocalGroup().getLldpLocChassisidSubType());
        node.setLldpSysname(snmpcoll.getLldpLocalGroup().getLldpLocSysname());
        Map<Integer, LldpLocTableEntry> localPortNumberToLocTableEntryMap = this.getLocalPortNumberToLocalTableEntryMap(snmpcoll);
        ArrayList<LldpRemInterface> lldpRemInterfaces = new ArrayList<LldpRemInterface>();
        for (LldpRemTableEntry lldpRemTableEntry : snmpcoll.getLldpRemTable()) {
            LogUtils.debugf((Object)this, (String)"processLldp: lldp remote entry node/localport/remporttype/remport: %d/%d/%d/%s", (Object[])new Object[]{node.getNodeId(), lldpRemTableEntry.getLldpRemLocalPortNum(), lldpRemTableEntry.getLldpRemPortidSubtype(), lldpRemTableEntry.getLldpRemPortid()});
            Integer lldpLocIfIndex = this.getLldpLocIfIndex(node.getLldpSysname(), localPortNumberToLocTableEntryMap.get(lldpRemTableEntry.getLldpRemLocalPortNum()));
            if (lldpLocIfIndex == null || lldpLocIfIndex == -1) {
                LogUtils.warnf((Object)this, (String)"processLldp: lldp local ifindex not valid for local node/lldpLocalPortNumber: %d/%d", (Object[])new Object[]{node.getNodeId(), lldpRemTableEntry.getLldpRemLocalPortNum()});
                continue;
            }
            Integer lldpRemIfIndex = this.getLldpRemIfIndex(lldpRemTableEntry);
            if (lldpRemIfIndex == null || lldpRemIfIndex == -1) {
                LogUtils.warnf((Object)this, (String)"processLldp: lldp remote ifindex not valid for local node/lldpLocalPortNumber: %d/%d", (Object[])new Object[]{node.getNodeId(), lldpRemTableEntry.getLldpRemLocalPortNum()});
                continue;
            }
            LldpRemInterface lldpremint = new LldpRemInterface(lldpRemTableEntry.getLldpRemChassisidSubtype(), lldpRemTableEntry.getLldpRemChassiid(), lldpRemIfIndex, lldpLocIfIndex);
            lldpRemInterfaces.add(lldpremint);
        }
        node.setLldpRemInterfaces(lldpRemInterfaces);
    }

    private Map<Integer, LldpLocTableEntry> getLocalPortNumberToLocalTableEntryMap(SnmpCollection snmpcoll) {
        HashMap<Integer, LldpLocTableEntry> localPortNumberToLocTableEntryMap = new HashMap<Integer, LldpLocTableEntry>();
        for (LldpLocTableEntry lldpLocTableEntry : snmpcoll.getLldpLocTable()) {
            localPortNumberToLocTableEntryMap.put(lldpLocTableEntry.getLldpLocPortNum(), lldpLocTableEntry);
        }
        return localPortNumberToLocTableEntryMap;
    }

    private Integer getLldpRemIfIndex(LldpRemTableEntry lldpRemTableEntry) {
        Integer ifindex = -1;
        switch (lldpRemTableEntry.getLldpRemPortidSubtype()) {
            case 1: {
                ifindex = this.getFromSysnameIfAlias(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 2: {
                ifindex = this.getFromSysnamePortComponent(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 3: {
                ifindex = this.getFromSysnameMacAddress(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemMacAddress());
                break;
            }
            case 4: {
                ifindex = this.getFromSysnameIpAddress(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemIpAddress());
                break;
            }
            case 5: {
                ifindex = this.getFromSysnameIfName(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 6: {
                ifindex = this.getFromSysnameAgentCircuitId(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 7: {
                try {
                    ifindex = Integer.parseInt(lldpRemTableEntry.getLldpRemPortid());
                    break;
                }
                catch (NumberFormatException e) {
                    ifindex = this.getFromSysnameIfName(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                }
            }
        }
        return ifindex;
    }

    private Integer getLldpLocIfIndex(String sysname, LldpLocTableEntry lldpLocTableEntry) {
        Integer ifindex = -1;
        switch (lldpLocTableEntry.getLldpLocPortIdSubtype()) {
            case 1: {
                ifindex = this.getFromSysnameIfAlias(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 2: {
                ifindex = this.getFromSysnamePortComponent(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 3: {
                ifindex = this.getFromSysnameMacAddress(sysname, lldpLocTableEntry.getLldpLocMacAddress());
                break;
            }
            case 4: {
                ifindex = this.getFromSysnameIpAddress(sysname, lldpLocTableEntry.getLldpLocIpAddress());
                break;
            }
            case 5: {
                ifindex = this.getFromSysnameIfName(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 6: {
                ifindex = this.getFromSysnameAgentCircuitId(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 7: {
                try {
                    ifindex = Integer.parseInt(lldpLocTableEntry.getLldpLocPortid());
                    break;
                }
                catch (NumberFormatException e) {
                    ifindex = this.getFromSysnameIfName(sysname, lldpLocTableEntry.getLldpLocPortid());
                }
            }
        }
        return ifindex;
    }

    protected Integer getFromSysnameAgentCircuitId(String lldpRemSysname, String lldpRemPortid) {
        LogUtils.warnf((Object)this, (String)"getFromSysnameAgentCircuitId: AgentCircuitId LLDP PortSubTypeId not supported", (Object[])new Object[0]);
        return null;
    }

    protected Integer getFromSysnameIfName(String lldpRemSysname, String lldpRemPortid) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.sysName", (Object)lldpRemSysname));
        criteria.add((Criterion)Restrictions.eq((String)"ifName", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty()) {
            return ((OnmsSnmpInterface)interfaces.get(0)).getIfIndex();
        }
        return null;
    }

    protected abstract Integer getFromSysnameIpAddress(String var1, InetAddress var2);

    protected Integer getFromSysnameMacAddress(String lldpRemSysname, String lldpRemPortid) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.sysName", (Object)lldpRemSysname));
        criteria.add((Criterion)Restrictions.eq((String)"physAddr", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty()) {
            return ((OnmsSnmpInterface)interfaces.get(0)).getIfIndex();
        }
        return null;
    }

    protected Integer getFromSysnamePortComponent(String lldpRemSysname, String lldpRemPortid) {
        LogUtils.warnf((Object)this, (String)"getFromSysnamePortComponent:PortComponent LLDP PortSubTypeId not supported", (Object[])new Object[0]);
        return null;
    }

    protected Integer getFromSysnameIfAlias(String lldpRemSysname, String lldpRemPortid) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.sysName", (Object)lldpRemSysname));
        criteria.add((Criterion)Restrictions.eq((String)"ifAlias", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty()) {
            return ((OnmsSnmpInterface)interfaces.get(0)).getIfIndex();
        }
        return null;
    }

    protected void processCdpCacheTable(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime) throws SQLException {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpcoll.getCdpCacheTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processCdpCacheTable: Starting CDP cache table processing for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processCdpCacheTable: Zero CDP cache table entries for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        ArrayList<CdpInterface> cdpInterfaces = new ArrayList<CdpInterface>();
        for (CdpCacheTableEntry cdpEntry : snmpcoll.getCdpCacheTable()) {
            int cdpIfIndex = cdpEntry.getCdpCacheIfIndex();
            if (cdpIfIndex < 0) {
                LogUtils.debugf((Object)this, (String)"processCdpCacheTable: ifIndex not valid: %d", (Object[])new Object[]{cdpIfIndex});
                continue;
            }
            LogUtils.debugf((Object)this, (String)"processCdpCacheTable: ifIndex found: %d", (Object[])new Object[]{cdpIfIndex});
            List<Object> targetCdpNodeIds = new ArrayList();
            String targetSysName = cdpEntry.getCdpCacheDeviceId();
            InetAddress cdpTargetIpAddr = cdpEntry.getCdpCacheIpv4Address();
            int cdpAddrType = cdpEntry.getCdpCacheAddressType();
            String cdpTargetIpAddrString = null;
            if (cdpAddrType != 1) {
                LogUtils.warnf((Object)this, (String)"processCdpCacheTable: CDP address type not ip: %d", (Object[])new Object[]{cdpAddrType});
            } else {
                cdpTargetIpAddrString = InetAddressUtils.str((InetAddress)cdpTargetIpAddr);
                if (cdpTargetIpAddr == null || cdpTargetIpAddr.isLoopbackAddress() || m_zeroAddress.equals(cdpTargetIpAddr)) {
                    LogUtils.debugf((Object)this, (String)"processCdpCacheTable: IP address is not valid: %s", (Object[])new Object[]{cdpTargetIpAddrString});
                    cdpTargetIpAddrString = null;
                } else {
                    LogUtils.debugf((Object)this, (String)"processCdpCacheTable: Target IP address found: %s", (Object[])new Object[]{cdpTargetIpAddrString});
                    targetCdpNodeIds = this.getNodeidFromIp(dbConn, cdpTargetIpAddr);
                    if (targetCdpNodeIds.isEmpty()) {
                        LogUtils.infof((Object)this, (String)"processCdpCacheTable: No Target node IDs found: interface %s not added to linkable SNMP node. Skipping.", (Object[])new Object[]{cdpTargetIpAddrString});
                        this.sendNewSuspectEvent(cdpTargetIpAddr, snmpcoll.getTarget(), snmpcoll.getPackageName());
                        continue;
                    }
                }
            }
            if (targetCdpNodeIds.isEmpty()) {
                LogUtils.debugf((Object)this, (String)"processCdpCacheTable: finding nodeids using CDP deviceid(sysname): %d", (Object[])new Object[]{targetSysName});
                targetCdpNodeIds = this.getNodeIdsFromSysName(targetSysName);
            }
            for (Integer n : targetCdpNodeIds) {
                LogUtils.infof((Object)this, (String)"processCdpCacheTable: Target node ID found: %d.", (Object[])new Object[]{n});
                String cdpTargetDevicePort = cdpEntry.getCdpCacheDevicePort();
                if (cdpTargetDevicePort == null) {
                    LogUtils.warnf((Object)this, (String)"processCdpCacheTable: Target device port not found. Skipping.", (Object[])new Object[0]);
                    continue;
                }
                LogUtils.debugf((Object)this, (String)"processCdpCacheTable: Target device port name found: %s", (Object[])new Object[]{cdpTargetDevicePort});
                int cdpTargetIfindex = this.getIfIndexByName(dbConn, n, cdpTargetDevicePort);
                if (cdpTargetIfindex == -1) {
                    LogUtils.infof((Object)this, (String)"processCdpCacheTable: No valid target ifIndex found but interface added to linkable SNMP node using ifindex  = -1.", (Object[])new Object[0]);
                }
                CdpInterface cdpIface = new CdpInterface(cdpIfIndex);
                cdpIface.setCdpTargetNodeId(n);
                cdpIface.setCdpTargetIfIndex(cdpTargetIfindex);
                if (cdpTargetIpAddrString == null) {
                    cdpIface.setCdpTargetIpAddr(this.getIpInterfaceDao().findPrimaryInterfaceByNodeId(n).getIpAddress());
                } else {
                    cdpIface.setCdpTargetIpAddr(cdpTargetIpAddr);
                }
                LogUtils.debugf((Object)this, (String)"processCdpCacheTable: Adding interface to linkable SNMP node: %s", (Object[])new Object[]{cdpIface});
                cdpInterfaces.add(cdpIface);
            }
        }
        node.setCdpInterfaces(cdpInterfaces);
    }

    private List<Integer> getNodeIdsFromSysName(String targetSysName) {
        ArrayList<Integer> nodeids = new ArrayList<Integer>();
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.add((Criterion)Restrictions.eq((String)"sysName", (Object)targetSysName));
        List nodes = this.getNodeDao().findMatching(criteria);
        for (OnmsNode node : nodes) {
            nodeids.add(node.getId());
        }
        return nodeids;
    }

    protected void processRouteTable(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime) throws SQLException {
        if (LogUtils.isDebugEnabled((Object)this)) {
            int routes = snmpcoll.getIpRouteTable().size();
            if (routes > 0) {
                LogUtils.debugf((Object)this, (String)"processRouteTable: Starting route table processing for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
                LogUtils.debugf((Object)this, (String)"processRouteTable: processing # %d routing interfaces", (Object[])new Object[]{routes});
            } else {
                LogUtils.debugf((Object)this, (String)"processRouteTable: Zero route table entries for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        ArrayList<RouterInterface> routeInterfaces = new ArrayList<RouterInterface>();
        for (SnmpStore ent : snmpcoll.getIpRouteTable()) {
            InetAddress routemask;
            InetAddress routedest;
            Integer ifindex;
            Integer ifindexforatinterface = ifindex = ent.getInt32("ipRouteIfIndex");
            InetAddress nexthop = ent.getIPAddress("ipRouteNextHop");
            boolean store = true;
            if (nexthop == null) {
                LogUtils.warnf((Object)this, (String)"processRouteTable: next hop not found on node %d. Skipping.", (Object[])new Object[]{node.getNodeId()});
                store = false;
            }
            if ((routedest = ent.getIPAddress("ipRouteDest")) == null) {
                LogUtils.warnf((Object)this, (String)"processRouteTable: route destination not found on node %d. Skipping.", (Object[])new Object[]{node.getNodeId()});
                store = false;
            }
            if ((routemask = ent.getIPAddress("ipRouteMask")) == null) {
                LogUtils.warnf((Object)this, (String)"processRouteTable: route mask not found on node %d. Skipping.", (Object[])new Object[]{node.getNodeId()});
                store = false;
            } else if (routemask.getHostAddress().equals("255.255.255.255")) {
                LogUtils.warnf((Object)this, (String)"processRouteTable: route mask 255.255.255.255 on node %d. Skipping.", (Object[])new Object[]{node.getNodeId()});
                store = false;
            }
            LogUtils.debugf((Object)this, (String)"processRouteTable: processing routedest/routemask/routenexthop %s/%s/%s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)routedest), InetAddressUtils.str((InetAddress)routemask), InetAddressUtils.str((InetAddress)nexthop)});
            if (ifindex == null || ifindex < 0) {
                LogUtils.warnf((Object)this, (String)"processRouteTable: Invalid ifIndex %d on node %d. Skipping.", (Object[])new Object[]{ifindex, node.getNodeId()});
                store = false;
            } else if (ifindex == 0 && (ifindexforatinterface = AbstractQueryManager.getIfIndexFromRouteTableEntries(nexthop, snmpcoll.getIpRouteTable())) < 1) {
                LogUtils.warnf((Object)this, (String)"processRouteTable: Not usable ifIndex %d on node %d.", (Object[])new Object[]{ifindex, node.getNodeId()});
                ifindexforatinterface = ifindex;
            }
            LogUtils.debugf((Object)this, (String)"processRouteTable: parsing routeDest/routeMask/nextHop: %s/%s/%s - ifIndex = %d", (Object[])new Object[]{InetAddressUtils.str((InetAddress)routedest), InetAddressUtils.str((InetAddress)routemask), InetAddressUtils.str((InetAddress)nexthop), ifindex});
            Integer routemetric1 = ent.getInt32("ipRouteMetric1");
            RouterInterface routeIface = this.getNodeidMaskFromIp(dbConn, nexthop);
            if (routeIface == null) {
                routeIface = this.getNodeFromIp(dbConn, nexthop);
            }
            if (routeIface == null) {
                LogUtils.infof((Object)this, (String)"processRouteTable: No node ID found for next hop IP address %s. Not adding the IP route interface to the linkable SNMP node.", (Object[])new Object[]{InetAddressUtils.str((InetAddress)nexthop)});
                this.sendNewSuspectEvent(nexthop, snmpcoll.getTarget(), snmpcoll.getPackageName());
            } else {
                int snmpiftype = -2;
                if (ifindex > 0) {
                    snmpiftype = this.getSnmpIfType(dbConn, node.getNodeId(), ifindex);
                }
                if (snmpiftype == -1) {
                    LogUtils.warnf((Object)this, (String)"processRouteTable: interface has an invalid ifType (%d). Skipping.", (Object[])new Object[]{snmpiftype});
                } else if (nexthop.isLoopbackAddress()) {
                    LogUtils.infof((Object)this, (String)"processRouteTable: next hop is a loopback address. Skipping.", (Object[])new Object[0]);
                } else if (m_zeroAddress.equals(nexthop)) {
                    LogUtils.infof((Object)this, (String)"processRouteTable: next hop is a broadcast address. Skipping.", (Object[])new Object[0]);
                } else if (nexthop.isMulticastAddress()) {
                    LogUtils.infof((Object)this, (String)"processRouteTable: next hop is a multicast address. Skipping.", (Object[])new Object[0]);
                } else if (routemetric1 == null || routemetric1 < 0) {
                    LogUtils.infof((Object)this, (String)"processRouteTable: Route metric is invalid. Skipping.", (Object[])new Object[0]);
                } else if (store) {
                    LogUtils.debugf((Object)this, (String)"processRouteTable: Interface has a valid ifType (%d). Adding.", (Object[])new Object[]{snmpiftype});
                    routeIface.setRouteDest(routedest);
                    routeIface.setRoutemask(routemask);
                    routeIface.setSnmpiftype(snmpiftype);
                    routeIface.setIfindex(ifindexforatinterface);
                    routeIface.setMetric(routemetric1);
                    routeIface.setNextHop(nexthop);
                    routeInterfaces.add(routeIface);
                }
            }
            Integer routemetric2 = ent.getInt32("ipRouteMetric2");
            Integer routemetric3 = ent.getInt32("ipRouteMetric3");
            Integer routemetric4 = ent.getInt32("ipRouteMetric4");
            Integer routemetric5 = ent.getInt32("ipRouteMetric5");
            Integer routetype = ent.getInt32("ipRouteType");
            Integer routeproto = ent.getInt32("ipRouteProto");
            if (!snmpcoll.getSaveIpRouteTable()) continue;
            LogUtils.debugf((Object)this, (String)"processRouteTable: persisting routeDest/routeMask/nextHop: %s/%s/%s - ifIndex = %d", (Object[])new Object[]{InetAddressUtils.str((InetAddress)routedest), InetAddressUtils.str((InetAddress)routemask), InetAddressUtils.str((InetAddress)nexthop), ifindex});
            OnmsNode onmsNode = this.getNode(node.getNodeId());
            OnmsIpRouteInterface ipRouteInterface = new OnmsIpRouteInterface();
            ipRouteInterface.setLastPollTime((Date)scanTime);
            ipRouteInterface.setNode(onmsNode);
            ipRouteInterface.setRouteDest(InetAddressUtils.str((InetAddress)routedest));
            ipRouteInterface.setRouteIfIndex(ifindex);
            ipRouteInterface.setRouteMask(InetAddressUtils.str((InetAddress)routemask));
            ipRouteInterface.setRouteMetric1(routemetric1);
            ipRouteInterface.setRouteMetric2(routemetric2);
            ipRouteInterface.setRouteMetric3(routemetric3);
            ipRouteInterface.setRouteMetric4(routemetric4);
            ipRouteInterface.setRouteMetric5(routemetric5);
            ipRouteInterface.setRouteNextHop(InetAddressUtils.str((InetAddress)nexthop));
            ipRouteInterface.setRouteProto(routeproto);
            ipRouteInterface.setRouteType(routetype);
            ipRouteInterface.setStatus(Character.valueOf('A'));
            this.saveIpRouteInterface(dbConn, ipRouteInterface);
        }
        node.setRouteInterfaces(routeInterfaces);
    }

    private static Integer getIfIndexFromRouteTableEntries(InetAddress nexthop, Collection<SnmpStore> entries) {
        for (SnmpStore entry : entries) {
            InetAddress routemask;
            InetAddress routedest = entry.getIPAddress("ipRouteDest");
            if (routedest == null || (routemask = entry.getIPAddress("ipRouteMask")) == null || !InetAddressUtils.toInteger((InetAddress)routemask).and(InetAddressUtils.toInteger((InetAddress)nexthop)).equals(InetAddressUtils.toInteger((InetAddress)routedest))) continue;
            Integer retval = entry.getInt32("ipRouteIfIndex");
            LogUtils.debugf(AbstractQueryManager.class, (String)"processRouteTable: found ifindex based on subnet mask: %d", (Object[])new Object[]{retval});
            return retval;
        }
        return -1;
    }

    protected void processVlanTable(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime) throws SQLException {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpcoll.getVlanTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processVlanTable: Starting VLAN table processing for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processVlanTable: Zero VLAN table entries for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        ArrayList<OnmsVlan> vlans = new ArrayList<OnmsVlan>();
        for (SnmpStore ent : snmpcoll.getVlanTable()) {
            Integer vlanStatus;
            Integer vlanType;
            Integer vlanIndex = ent.getInt32("vtpVlanIndex");
            if (vlanIndex == null || vlanIndex < 0) {
                LogUtils.debugf((Object)this, (String)"processVlanTable: VLAN ifIndex was invalid (%d). Skipping.", (Object[])new Object[]{vlanIndex});
                continue;
            }
            String vlanName = ent.getDisplayString("vtpVlanName");
            if (vlanName == null) {
                vlanName = "default-" + vlanIndex;
                LogUtils.debugf((Object)this, (String)"processVlanTable: No VLAN name found. Setting to '%s'.", (Object[])new Object[]{vlanName});
            }
            if ((vlanType = ent.getInt32("vtpVlanType")) == null) {
                vlanType = 0;
            }
            if ((vlanStatus = ent.getInt32("vtpVlanStatus")) == null) {
                vlanStatus = 0;
            }
            OnmsNode onmsNode = this.getNode(node.getNodeId());
            OnmsVlan vlan = new OnmsVlan(vlanIndex.intValue(), vlanName, vlanStatus.intValue(), vlanType.intValue());
            vlan.setLastPollTime((Date)scanTime);
            vlan.setNode(onmsNode);
            vlan.setStatus(Character.valueOf('A'));
            vlans.add(vlan);
            LogUtils.debugf((Object)this, (String)"processVlanTable: Saving VLAN entry: %s", (Object[])new Object[]{vlan});
            this.saveVlan(dbConn, vlan);
        }
        node.setVlans(vlans);
    }

    protected void processDot1DBase(LinkableNode node, SnmpCollection snmpcoll, DBUtils d, Connection dbConn, Timestamp scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl) throws SQLException {
        LogUtils.debugf((Object)this, (String)"processDot1DBase: Starting Bridge MIB processing for Vlan: %s.", (Object[])new Object[]{vlan.getVlanName()});
        OnmsNode onmsNode = this.getNode(node.getNodeId());
        if (onmsNode == null) {
            LogUtils.debugf((Object)this, (String)"no node found!", (Object[])new Object[0]);
            return;
        }
        Dot1dBaseGroup dod1db = snmpVlanColl.getDot1dBase();
        String baseBridgeAddress = dod1db.getBridgeAddress();
        if (baseBridgeAddress == null || baseBridgeAddress.equals("000000000000")) {
            LogUtils.infof((Object)this, (String)"processDot1DBase: Invalid base bridge address (%s) on node %d", (Object[])new Object[]{baseBridgeAddress, node.getNodeId()});
            return;
        }
        this.processStpNode(onmsNode, node, snmpcoll, dbConn, scanTime, vlan, snmpVlanColl);
        if (snmpVlanColl.hasDot1dBasePortTable()) {
            Map<Integer, OnmsStpInterface> stpinterfaces = new HashMap<Integer, OnmsStpInterface>(snmpVlanColl.getDot1dBasePortTable().size());
            stpinterfaces = this.processDot1DBasePortTable(onmsNode, node, snmpcoll, scanTime, vlan, snmpVlanColl, stpinterfaces);
            if (snmpVlanColl.hasDot1dStpPortTable()) {
                stpinterfaces = this.processDot1StpPortTable(node, snmpcoll, scanTime, vlan, snmpVlanColl, stpinterfaces);
            }
            this.processStpInterfaces(node, snmpcoll, dbConn, stpinterfaces);
        }
        if (snmpVlanColl.hasDot1dTpFdbTable()) {
            this.processDot1DTpFdbTable(node, vlan, snmpVlanColl, scanTime);
        }
        if (snmpVlanColl.hasQBridgeDot1dTpFdbTable()) {
            this.processQBridgeDot1dTpFdbTable(node, vlan, snmpVlanColl);
        }
        for (String physaddr : this.getPhysAddrs(node.getNodeId(), d, dbConn)) {
            LogUtils.debugf((Object)this, (String)"Try to add Bridge Identifier \"%s\" for node %d", (Object[])new Object[]{physaddr, node.getNodeId()});
            if (physaddr == null || physaddr.equals("") || physaddr.equals("000000000000")) continue;
            LogUtils.infof((Object)this, (String)"Adding Bridge Identifier %s for node %d", (Object[])new Object[]{physaddr, node.getNodeId()});
            node.addBridgeIdentifier(physaddr);
        }
    }

    protected void processQBridgeDot1dTpFdbTable(LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl) {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpVlanColl.getQBridgeDot1dFdbTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1dTpFdbTable: Starting Q-BRIDGE-MIB dot1dTpFdb table processing for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1dTpFdbTable: Zero Q-BRIDGE-MIB dot1dTpFdb table entries for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        for (QBridgeDot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getQBridgeDot1dFdbTable()) {
            String curMacAddress = dot1dfdbentry.getQBridgeDot1dTpFdbAddress();
            if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                LogUtils.infof((Object)this, (String)"processQBridgeDot1DTpFdbTable: Invalid MAC addres %s on node %d. Skipping.", (Object[])new Object[]{curMacAddress, node.getNodeId()});
                continue;
            }
            LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Found MAC address %s on node %d", (Object[])new Object[]{curMacAddress, node.getNodeId()});
            int fdbport = dot1dfdbentry.getQBridgeDot1dTpFdbPort();
            if (fdbport == 0 || fdbport == -1) {
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Invalid FDB port (%d) for MAC address %s on node %d. Skipping.", (Object[])new Object[]{fdbport, curMacAddress, node.getNodeId()});
                continue;
            }
            LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Found bridge port %d on node %d.", (Object[])new Object[]{fdbport, node.getNodeId()});
            int curfdbstatus = dot1dfdbentry.getQBridgeDot1dTpFdbStatus();
            if (curfdbstatus == 3) {
                node.addMacAddress(fdbport, curMacAddress, Integer.toString(vlan.getVlanId()));
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Found learned status on bridge port.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus == 4) {
                node.addBridgeIdentifier(curMacAddress);
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: MAC address (%s) is used as bridge identifier.", (Object[])new Object[]{curMacAddress});
                continue;
            }
            if (curfdbstatus == 2) {
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Found 'INVALID' status. Skipping.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus == 5) {
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Found 'MGMT' status. Skipping.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus == 1) {
                LogUtils.debugf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Found 'OTHER' status. Skipping.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus != -1) continue;
            LogUtils.warnf((Object)this, (String)"processQBridgeDot1DTpFdbTable: Unable to determine status. Skipping.", (Object[])new Object[0]);
        }
    }

    protected void processDot1DTpFdbTable(LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Timestamp scanTime) {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpVlanColl.getDot1dFdbTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Starting dot1dTpFdb table processing for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Zero dot1dTpFdb table entries for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        for (Dot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getDot1dFdbTable()) {
            String curMacAddress = dot1dfdbentry.getDot1dTpFdbAddress();
            int fdbport = dot1dfdbentry.getDot1dTpFdbPort();
            int curfdbstatus = dot1dfdbentry.getDot1dTpFdbStatus();
            if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                LogUtils.infof((Object)this, (String)"processDot1DTpFdbTable: Invalid MAC address %s on node %d. Skipping.", (Object[])new Object[]{curMacAddress, node.getNodeId()});
                continue;
            }
            LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Found valid MAC address %s on node %d", (Object[])new Object[]{curMacAddress, node.getNodeId()});
            if (fdbport == 0 || fdbport == -1) {
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Invalid FDB port (%d) for MAC address %s on node %d. Skipping.", (Object[])new Object[]{fdbport, curMacAddress, node.getNodeId()});
                continue;
            }
            LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: MAC address (%s) found on bridge port %d on node %d", (Object[])new Object[]{curMacAddress, fdbport, node.getNodeId()});
            if (curfdbstatus == 3 && vlan.getVlanId() != null) {
                node.addMacAddress(fdbport, curMacAddress, vlan.getVlanId().toString());
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Found learned status on bridge port.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus == 4) {
                node.addBridgeIdentifier(curMacAddress);
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: MAC address (%s) is used as bridge identifier.", (Object[])new Object[]{curMacAddress});
                continue;
            }
            if (curfdbstatus == 2) {
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Found 'INVALID' status. Skipping.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus == 5) {
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Found 'MGMT' status. Skipping.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus == 1) {
                LogUtils.debugf((Object)this, (String)"processDot1DTpFdbTable: Found 'OTHER' status. Skipping.", (Object[])new Object[0]);
                continue;
            }
            if (curfdbstatus != -1) continue;
            LogUtils.warnf((Object)this, (String)"processDot1DTpFdbTable: Unable to determine status. Skipping.", (Object[])new Object[0]);
        }
    }

    protected Map<Integer, OnmsStpInterface> processDot1StpPortTable(LinkableNode node, SnmpCollection snmpcoll, Timestamp scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Map<Integer, OnmsStpInterface> stpinterfaces) throws SQLException {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpVlanColl.getDot1dStpPortTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processDot1StpPortTable: Processing dot1StpPortTable for nodeid/ip for %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processDot1StpPortTable: Zero dot1StpPort table entries for nodeid/ip %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        for (Dot1dStpPortTableEntry dot1dstpptentry : snmpVlanColl.getDot1dStpPortTable()) {
            int stpport = dot1dstpptentry.getDot1dStpPort();
            if (stpport == -1) {
                LogUtils.infof((Object)this, (String)"processDot1StpPortTable: Found invalid STP port. Skipping.", (Object[])new Object[0]);
                continue;
            }
            OnmsStpInterface stpInterface = stpinterfaces.get(stpport);
            if (stpInterface == null) continue;
            String stpPortDesignatedBridge = dot1dstpptentry.getDot1dStpPortDesignatedBridge();
            String stpPortDesignatedPort = dot1dstpptentry.getDot1dStpPortDesignatedPort();
            if (stpPortDesignatedBridge == null) {
                LogUtils.infof((Object)this, (String)"processDot1StpPortTable: Designated bridge (%s) is invalid on node %d. Skipping.", (Object[])new Object[]{stpPortDesignatedBridge, node.getNodeId()});
                stpPortDesignatedBridge = "0000000000000000";
            }
            if (stpPortDesignatedPort == null) {
                LogUtils.infof((Object)this, (String)"processDot1StpPortTable: Designated port (%s) is invalid on node %d. Skipping.", (Object[])new Object[]{stpPortDesignatedPort, node.getNodeId()});
                stpPortDesignatedPort = "0000";
            }
            stpInterface.setStpPortState(Integer.valueOf(dot1dstpptentry.getDot1dStpPortState()));
            stpInterface.setStpPortPathCost(Integer.valueOf(dot1dstpptentry.getDot1dStpPortPathCost()));
            stpInterface.setStpPortDesignatedBridge(stpPortDesignatedBridge);
            stpInterface.setStpPortDesignatedRoot(dot1dstpptentry.getDot1dStpPortDesignatedRoot());
            stpInterface.setStpPortDesignatedCost(Integer.valueOf(dot1dstpptentry.getDot1dStpPortDesignatedCost()));
            stpInterface.setStpPortDesignatedPort(stpPortDesignatedPort);
            LogUtils.debugf((Object)this, (String)"processDot1StpPortTable: found stpport/designatedbridge/designatedport %d/%s/%s", (Object[])new Object[]{stpport, stpPortDesignatedBridge, stpPortDesignatedPort});
        }
        return stpinterfaces;
    }

    protected void processStpInterfaces(LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Map<Integer, OnmsStpInterface> stpinterfaces) throws SQLException {
        for (OnmsStpInterface stpInterface : stpinterfaces.values()) {
            node.addStpInterface(stpInterface);
            if (!snmpcoll.getSaveStpInterfaceTable()) continue;
            LogUtils.debugf((Object)this, (String)"processStpInterfaces: saving %s in stpinterface table", (Object[])new Object[]{stpInterface.toString()});
            this.saveStpInterface(dbConn, stpInterface);
        }
    }

    protected Map<Integer, OnmsStpInterface> processDot1DBasePortTable(OnmsNode onmsNode, LinkableNode node, SnmpCollection snmpcoll, Timestamp scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Map<Integer, OnmsStpInterface> stpinterfaces) throws SQLException {
        if (LogUtils.isDebugEnabled((Object)this)) {
            if (snmpVlanColl.getDot1dBasePortTable().size() > 0) {
                LogUtils.debugf((Object)this, (String)"processDot1DBasePortTable: Processing dot1BasePortTable for nodeid/ip %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            } else {
                LogUtils.debugf((Object)this, (String)"processDot1DBasePortTable: Zero dot1BasePort table entries for nodeid/ip %d/%s", (Object[])new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
            }
        }
        for (Dot1dBasePortTableEntry dot1dbaseptentry : snmpVlanColl.getDot1dBasePortTable()) {
            int baseport = dot1dbaseptentry.getBaseBridgePort();
            int ifindex = dot1dbaseptentry.getBaseBridgePortIfindex();
            LogUtils.debugf((Object)this, (String)"processDot1DBasePortTable: processing bridge port (%d) with ifIndex (%d).", (Object[])new Object[]{baseport, ifindex});
            if (baseport == -1 || ifindex == -1) {
                LogUtils.infof((Object)this, (String)"processDot1DBasePortTable: Invalid base port (%d) or ifIndex (%d). Skipping.", (Object[])new Object[]{baseport, ifindex});
                continue;
            }
            node.setIfIndexBridgePort(ifindex, baseport);
            OnmsStpInterface stpInterface = new OnmsStpInterface(onmsNode, Integer.valueOf(baseport), vlan.getVlanId());
            stpInterface.setBridgePort(Integer.valueOf(baseport));
            stpInterface.setVlan(vlan.getVlanId());
            stpInterface.setIfIndex(Integer.valueOf(ifindex));
            stpInterface.setStatus(Character.valueOf('A'));
            stpInterface.setLastPollTime((Date)scanTime);
            stpinterfaces.put(baseport, stpInterface);
        }
        return stpinterfaces;
    }

    protected void processStpNode(OnmsNode onmsNode, LinkableNode node, SnmpCollection snmpcoll, Connection dbConn, Timestamp scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl) throws SQLException {
        LogUtils.debugf((Object)this, (String)"processStpNode: Starting stpnode processing for Vlan: %s", (Object[])new Object[]{vlan.getVlanName()});
        Dot1dBaseGroup dod1db = snmpVlanColl.getDot1dBase();
        String baseBridgeAddress = dod1db.getBridgeAddress();
        LogUtils.debugf((Object)this, (String)"processStpNode: processing Dot1dBaseGroup in stpnode", (Object[])new Object[0]);
        OnmsStpNode stpNode = new OnmsStpNode(onmsNode, vlan.getVlanId());
        stpNode.setLastPollTime((Date)scanTime);
        stpNode.setStatus(Character.valueOf('A'));
        stpNode.setBaseBridgeAddress(baseBridgeAddress);
        LogUtils.debugf((Object)this, (String)"processStpNode: baseBridgeAddress = %s", (Object[])new Object[]{baseBridgeAddress});
        stpNode.setBaseNumPorts(Integer.valueOf(dod1db.getNumberOfPorts()));
        stpNode.setBaseType(Integer.valueOf(dod1db.getBridgeType()));
        stpNode.setBaseVlanName(vlan.getVlanName());
        if (snmpVlanColl.hasDot1dStp()) {
            LogUtils.debugf((Object)this, (String)"processStpNode: processing Dot1dStpGroup in stpnode", (Object[])new Object[0]);
            Dot1dStpGroup dod1stp = snmpVlanColl.getDot1dStp();
            stpNode.setStpProtocolSpecification(Integer.valueOf(dod1stp.getStpProtocolSpecification()));
            stpNode.setStpPriority(Integer.valueOf(dod1stp.getStpPriority()));
            stpNode.setStpRootCost(Integer.valueOf(dod1stp.getStpRootCost()));
            stpNode.setStpRootPort(Integer.valueOf(dod1stp.getStpRootPort()));
            String stpDesignatedRoot = dod1stp.getStpDesignatedRoot();
            if (stpDesignatedRoot == null || stpDesignatedRoot == "0000000000000000") {
                LogUtils.debugf((Object)this, (String)("store: Dot1dStpGroup found stpDesignatedRoot " + stpDesignatedRoot + ", not adding to Linkable node"), (Object[])new Object[0]);
                stpDesignatedRoot = "0000000000000000";
            } else if (stpNode.getBaseVlan() != null) {
                node.setVlanStpRoot(vlan.getVlanId().toString(), stpDesignatedRoot);
            }
            stpNode.setStpDesignatedRoot(stpDesignatedRoot);
            LogUtils.debugf((Object)this, (String)"processStpNode: stpDesignatedRoot = %s", (Object[])new Object[]{stpDesignatedRoot});
        }
        if (snmpcoll.getSaveStpNodeTable()) {
            LogUtils.debugf((Object)this, (String)"processStpNode: saving %s in stpnode table", (Object[])new Object[]{stpNode.toString()});
            this.saveStpNode(dbConn, stpNode);
        }
        if (vlan.getVlanId() != null) {
            LogUtils.debugf((Object)this, (String)"processStpNode: Found Bridge Identifier %s for Vlan %d.", (Object[])new Object[]{baseBridgeAddress, vlan.getVlanId()});
            node.addBridgeIdentifier(baseBridgeAddress, Integer.toString(vlan.getVlanId()));
        }
    }
}

