/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.config.EventExpander;
import org.opennms.netmgt.model.events.EventProcessor;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class EventParmRegexFilterProcessor
implements EventProcessor,
InitializingBean {
    private EventConfDao m_eventConfDao;
    private Map<String, Filter> m_filterMap = new HashMap<String, Filter>();

    public void process(Header eventHeader, org.opennms.netmgt.xml.event.Event event) throws SQLException {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        Event econf = EventExpander.lookup((EventConfDao)this.m_eventConfDao, (org.opennms.netmgt.xml.event.Event)event);
        if (econf.getFilters() != null) {
            for (Filter fConf : econf.getFilters().getFilterCollection()) {
                if (this.m_filterMap.containsKey(fConf.getEventparm() + "|" + event.getUei())) continue;
                this.m_filterMap.put(fConf.getEventparm() + "|" + event.getUei(), fConf);
                if (!log.isDebugEnabled()) continue;
                log.debug("adding [" + fConf.getEventparm() + "|" + event.getUei() + "] to filter map");
            }
            for (Parm parm : event.getParmCollection()) {
                if (parm.getParmName() == null || parm.getValue().getContent() == null || !this.m_filterMap.containsKey(parm.getParmName() + "|" + event.getUei())) continue;
                Filter f = this.m_filterMap.get(parm.getParmName() + "|" + event.getUei());
                if (log.isDebugEnabled()) {
                    log.debug("filtering " + parm.getParmName() + " with " + f.getPattern());
                }
                Pattern pattern = Pattern.compile(f.getPattern());
                Matcher matcher = pattern.matcher(parm.getValue().getContent().trim());
                parm.getValue().setContent(matcher.replaceAll(f.getReplacement()));
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_eventConfDao != null ? 1 : 0) != 0, (String)"property eventConfDao must be set");
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }
}

