/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpRecordHandler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.opennms.netmgt.xml.event.Log;
import org.xml.sax.InputSource;

final class TcpStreamHandler
implements Runnable {
    private List<EventHandler> m_handlers;
    private volatile boolean m_stop;
    private Fiber m_parent;
    private Socket m_connection;
    private Thread m_context;
    private int m_recsPerConn;

    TcpStreamHandler(Fiber parent, Socket sock, List<EventHandler> handlers, int number) {
        this.m_parent = parent;
        this.m_connection = sock;
        this.m_handlers = handlers;
        this.m_stop = false;
        this.m_context = null;
        this.m_recsPerConn = number;
    }

    boolean isAlive() {
        boolean rc = false;
        if (this.m_context != null) {
            rc = this.m_context.isAlive();
        }
        return rc;
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            LogUtils.debugf((Object)this, (String)"Interrupting and joining the thread context %s", (Object[])new Object[]{this.m_context.getName()});
            this.m_context.interrupt();
            this.m_context.join();
            LogUtils.debugf((Object)this, (String)"Context stopped and joined", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread tchunker;
        Thread thread = this.m_context = Thread.currentThread();
        synchronized (thread) {
            this.m_context.notifyAll();
        }
        if (this.m_stop) {
            LogUtils.debugf((Object)this, (String)"The stop flag was set prior to thread entry, closing connection", (Object[])new Object[0]);
            try {
                this.m_connection.close();
            }
            catch (IOException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"An error occured while closing the connection.", (Object[])new Object[0]);
            }
            LogUtils.debugf((Object)this, (String)"Thread context exiting", (Object[])new Object[0]);
            return;
        }
        InetAddress sender = this.m_connection.getInetAddress();
        LogUtils.debugf((Object)this, (String)"Event Log Stream Handler Started for %s", (Object[])new Object[]{sender});
        LinkedList<Object> pipeXchange = new LinkedList<Object>();
        TcpRecordHandler chunker = new TcpRecordHandler(this.m_connection, pipeXchange);
        Thread thread2 = tchunker = new Thread((Runnable)chunker, "TCPRecord Chunker[" + InetAddressUtils.str((InetAddress)this.m_connection.getInetAddress()) + ":" + this.m_connection.getPort() + "]");
        synchronized (thread2) {
            tchunker.start();
            try {
                tchunker.wait();
            }
            catch (InterruptedException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"The thread was interrupted.", (Object[])new Object[0]);
            }
        }
        block45: while (!this.m_stop && this.m_parent.getStatus() != 3 && this.m_parent.getStatus() != 4 && this.m_recsPerConn != 0) {
            PipedInputStream pipeIn = null;
            LinkedList<Object> e = pipeXchange;
            synchronized (e) {
                while (pipeXchange.isEmpty()) {
                    if (chunker.isAlive()) {
                        try {
                            pipeXchange.wait(500L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            LogUtils.errorf((Object)this, (Throwable)e2, (String)"The thread was interrupted.", (Object[])new Object[0]);
                        }
                    }
                    break block45;
                }
                Object o = pipeXchange.removeFirst();
                if (o instanceof Throwable) {
                    break;
                }
                try {
                    pipeIn = new PipedInputStream((PipedOutputStream)o);
                }
                catch (IOException e3) {
                    LogUtils.errorf((Object)this, (Throwable)e3, (String)"An I/O exception occured construction a record reader.", (Object[])new Object[0]);
                    break;
                }
                Object e3 = o;
                synchronized (e3) {
                    o.notify();
                }
            }
            this.m_recsPerConn -= this.m_recsPerConn > 0 ? 1 : 0;
            BufferedInputStream stream = new BufferedInputStream(pipeIn);
            Log eLog = null;
            boolean doCleanup = false;
            try {
                eLog = (Log)JaxbUtils.unmarshal(Log.class, (InputSource)new InputSource(stream));
                LogUtils.debugf((Object)this, (String)"Event record converted", (Object[])new Object[0]);
            }
            catch (Exception e4) {
                LogUtils.errorf((Object)this, (Throwable)e4, (String)"Could not unmarshall the XML record.", (Object[])new Object[0]);
                doCleanup = true;
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            if (doCleanup) {
                try {
                    while (((InputStream)stream).read() != -1) {
                    }
                    continue;
                }
                catch (IOException e5) {
                    continue;
                }
            }
            Event[] events = eLog.getEvents().getEvent();
            Arrays.sort(events, new Comparator<Event>(){

                @Override
                public int compare(Event e1, Event e2) {
                    boolean e2t;
                    boolean e1t = e1.getTime() != null;
                    boolean bl = e2t = e2.getTime() != null;
                    if (e1t && !e2t) {
                        return 1;
                    }
                    if (!e1t && e2t) {
                        return -1;
                    }
                    if (!e1t && !e2t) {
                        return 0;
                    }
                    DateFormat fmt = DateFormat.getDateTimeInstance(0, 0);
                    Date de1 = null;
                    try {
                        de1 = fmt.parse(e1.getTime());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    Date de2 = null;
                    try {
                        de2 = fmt.parse(e2.getTime());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (de1 != null && de2 != null) {
                        return (int)(de1.getTime() - de2.getTime());
                    }
                    if (de1 == null && de2 != null) {
                        return -1;
                    }
                    if (de1 != null && de2 == null) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (events != null && events.length != 0) {
                ArrayList<Event> okEvents = new ArrayList<Event>(events.length);
                List<EventHandler> list = this.m_handlers;
                synchronized (list) {
                    for (EventHandler hdl : this.m_handlers) {
                        for (Event event : events) {
                            try {
                                LogUtils.debugf((Object)this, (String)"handling event: %s", (Object[])new Object[]{event});
                                if (!hdl.processEvent(event) || okEvents.contains(event)) continue;
                                okEvents.add(event);
                            }
                            catch (Throwable t) {
                                LogUtils.warnf((Object)this, (Throwable)t, (String)"An exception occured while processing an event.", (Object[])new Object[0]);
                            }
                        }
                    }
                }
                boolean hasReceipt = false;
                EventReceipt receipt = new EventReceipt();
                for (Object event : okEvents) {
                    if (event.getUuid() == null) continue;
                    receipt.addUuid(event.getUuid());
                    hasReceipt = true;
                }
                if (!hasReceipt) continue;
                try {
                    Object event;
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.m_connection.getOutputStream(), "UTF-8"));
                    JaxbUtils.marshal((Object)receipt, (Writer)writer);
                    ((Writer)writer).flush();
                    event = this.m_handlers;
                    synchronized (event) {
                        for (EventHandler hdl : this.m_handlers) {
                            try {
                                hdl.receiptSent(receipt);
                            }
                            catch (Throwable t) {
                                LogUtils.warnf((Object)this, (Throwable)t, (String)"An exception occured while processing an event receipt.", (Object[])new Object[0]);
                            }
                        }
                    }
                    if (!LogUtils.isDebugEnabled((Object)this)) continue;
                    try {
                        StringWriter swriter = new StringWriter();
                        JaxbUtils.marshal((Object)receipt, (Writer)swriter);
                        LogUtils.debugf((Object)this, (String)"Sent Event Receipt {", (Object[])new Object[0]);
                        LogUtils.debugf((Object)this, (String)swriter.getBuffer().toString(), (Object[])new Object[0]);
                        LogUtils.debugf((Object)this, (String)"}", (Object[])new Object[0]);
                    }
                    catch (Throwable e6) {
                        LogUtils.errorf((Object)this, (Throwable)e6, (String)"An error occured during marshalling of event receipt for the log.", (Object[])new Object[0]);
                    }
                    continue;
                }
                catch (IOException e7) {
                    LogUtils.warnf((Object)this, (Throwable)e7, (String)"Failed to send event-receipt XML document.", (Object[])new Object[0]);
                    break;
                }
            }
            LogUtils.debugf((Object)this, (String)"The agent sent an empty event stream", (Object[])new Object[0]);
        }
        try {
            LogUtils.debugf((Object)this, (String)"stopping record handler", (Object[])new Object[0]);
            chunker.stop();
            LogUtils.debugf((Object)this, (String)"record handler stopped", (Object[])new Object[0]);
        }
        catch (InterruptedException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"The thread was interrupted while trying to close the record handler.", (Object[])new Object[0]);
        }
        try {
            LogUtils.debugf((Object)this, (String)"closing connnection", (Object[])new Object[0]);
            this.m_connection.close();
            LogUtils.debugf((Object)this, (String)"connnection closed ", (Object[])new Object[0]);
        }
        catch (IOException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An I/O exception occured while closing the TCP/IP connection.", (Object[])new Object[0]);
        }
        LogUtils.debugf((Object)this, (String)"Thread exiting", (Object[])new Object[0]);
    }
}

