/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventHandler;
import org.opennms.netmgt.eventd.UndeclaredEventException;
import org.opennms.netmgt.model.events.EventIpcBroadcaster;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventIpcManagerProxy;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EventIpcManagerDefaultImpl
implements EventIpcManager,
EventIpcBroadcaster,
InitializingBean {
    private Map<String, List<EventListener>> m_ueiListeners = new HashMap<String, List<EventListener>>();
    private List<EventListener> m_listeners = new ArrayList<EventListener>();
    private Map<String, EventListenerExecutor> m_listenerThreads = new HashMap<String, EventListenerExecutor>();
    private ExecutorService m_eventHandlerPool;
    private EventHandler m_eventHandler;
    private Integer m_handlerPoolSize;
    private Integer m_handlerQueueLength;
    private EventIpcManagerProxy m_eventIpcManagerProxy;

    public void send(Event event) throws EventProxyException {
        this.sendNow(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        this.sendNow(eventLog);
    }

    public void sendNow(Event event) {
        Assert.notNull((Object)event, (String)"event argument cannot be null");
        Events events = new Events();
        events.addEvent(event);
        Log eventLog = new Log();
        eventLog.setEvents(events);
        this.sendNow(eventLog);
    }

    public void sendNow(Log eventLog) {
        Assert.notNull((Object)eventLog, (String)"eventLog argument cannot be null");
        try {
            this.m_eventHandlerPool.execute(this.m_eventHandler.createRunnable(eventLog));
        }
        catch (RejectedExecutionException e) {
            EventIpcManagerDefaultImpl.log().warn("Unable to queue event log to the event handler pool queue: " + e, (Throwable)e);
            throw new UndeclaredEventException(e);
        }
    }

    public void broadcastNow(Event event) {
        if (EventIpcManagerDefaultImpl.log().isDebugEnabled()) {
            EventIpcManagerDefaultImpl.log().debug("Event ID " + event.getDbid() + " to be broadcasted: " + event.getUei());
        }
        if (this.m_listeners.isEmpty()) {
            EventIpcManagerDefaultImpl.log().debug("No listeners interested in all events");
        }
        for (EventListener listener : this.m_listeners) {
            this.queueEventToListener(event, listener);
        }
        if (event.getUei() == null) {
            if (EventIpcManagerDefaultImpl.log().isDebugEnabled()) {
                EventIpcManagerDefaultImpl.log().debug("Event ID " + event.getDbid() + " does not have a UEI, so skipping UEI matching");
            }
            return;
        }
        HashSet<EventListener> sentToListeners = new HashSet<EventListener>();
        String uei = event.getUei();
        while (uei.length() > 0) {
            int i;
            if (this.m_ueiListeners.containsKey(uei)) {
                for (EventListener listener : this.m_ueiListeners.get(uei)) {
                    if (sentToListeners.contains(listener)) continue;
                    this.queueEventToListener(event, listener);
                    sentToListeners.add(listener);
                }
            }
            if ((i = uei.lastIndexOf("/", uei.length() - 2)) <= 0) break;
            uei = uei.substring(0, i + 1);
        }
        if (sentToListeners.isEmpty() && EventIpcManagerDefaultImpl.log().isDebugEnabled()) {
            EventIpcManagerDefaultImpl.log().debug("No listener interested in event ID " + event.getDbid() + ": " + event.getUei());
        }
    }

    private void queueEventToListener(Event event, EventListener listener) {
        this.m_listenerThreads.get(listener.getName()).addEvent(event);
    }

    public synchronized void addEventListener(EventListener listener) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        this.createListenerThread(listener);
        this.addMatchAllForListener(listener);
        for (String uei : this.m_ueiListeners.keySet()) {
            this.removeUeiForListener(uei, listener);
        }
    }

    public synchronized void addEventListener(EventListener listener, Collection<String> ueis) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull(ueis, (String)"ueilist argument cannot be null");
        if (ueis.isEmpty()) {
            EventIpcManagerDefaultImpl.log().warn("Not adding event listener " + listener.getName() + " because the ueilist argument contains no entries");
            return;
        }
        if (EventIpcManagerDefaultImpl.log().isDebugEnabled()) {
            EventIpcManagerDefaultImpl.log().debug("Adding event listener " + listener.getName() + " for UEIs: " + StringUtils.collectionToCommaDelimitedString(ueis));
        }
        this.createListenerThread(listener);
        for (String uei : ueis) {
            this.addUeiForListener(uei, listener);
        }
        this.removeMatchAllForListener(listener);
    }

    public synchronized void addEventListener(EventListener listener, String uei) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull((Object)uei, (String)"uei argument cannot be null");
        this.addEventListener(listener, Collections.singletonList(uei));
    }

    public synchronized void removeEventListener(EventListener listener, Collection<String> ueis) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull(ueis, (String)"ueilist argument cannot be null");
        for (String uei : ueis) {
            this.removeUeiForListener(uei, listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener, String uei) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        Assert.notNull((Object)uei, (String)"uei argument cannot be null");
        this.removeUeiForListener(uei, listener);
    }

    public synchronized void removeEventListener(EventListener listener) {
        Assert.notNull((Object)listener, (String)"listener argument cannot be null");
        this.removeMatchAllForListener(listener);
        for (String uei : this.m_ueiListeners.keySet()) {
            this.removeUeiForListener(uei, listener);
        }
        if (this.m_listenerThreads.containsKey(listener.getName())) {
            this.m_listenerThreads.get(listener.getName()).stop();
            this.m_listenerThreads.remove(listener.getName());
        }
    }

    private void createListenerThread(EventListener listener) {
        if (this.m_listenerThreads.containsKey(listener.getName())) {
            return;
        }
        EventListenerExecutor listenerThread = new EventListenerExecutor(listener, this.m_handlerQueueLength);
        this.m_listenerThreads.put(listener.getName(), listenerThread);
    }

    private void addUeiForListener(String uei, EventListener listener) {
        List<EventListener> listenersList;
        if (!this.m_ueiListeners.containsKey(uei)) {
            this.m_ueiListeners.put(uei, new ArrayList());
        }
        if (!(listenersList = this.m_ueiListeners.get(uei)).contains(listener)) {
            listenersList.add(listener);
        }
    }

    private void removeUeiForListener(String uei, EventListener listener) {
        if (this.m_ueiListeners.containsKey(uei)) {
            this.m_ueiListeners.get(uei).remove(listener);
        }
    }

    private boolean addMatchAllForListener(EventListener listener) {
        return this.m_listeners.add(listener);
    }

    private boolean removeMatchAllForListener(EventListener listener) {
        return this.m_listeners.remove(listener);
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(EventIpcManagerDefaultImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Assert.state((this.m_eventHandlerPool == null ? 1 : 0) != 0, (String)"afterPropertiesSet() has already been called");
        Assert.state((this.m_eventHandler != null ? 1 : 0) != 0, (String)"eventHandler not set");
        Assert.state((this.m_handlerPoolSize != null ? 1 : 0) != 0, (String)"handlerPoolSize not set");
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)"OpenNMS.Eventd");
            this.m_eventHandlerPool = new ThreadPoolExecutor((int)this.m_handlerPoolSize, (int)this.m_handlerPoolSize, 0L, TimeUnit.MILLISECONDS, this.m_handlerQueueLength == null ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(this.m_handlerQueueLength), (ThreadFactory)new LogPreservingThreadFactory(EventIpcManagerDefaultImpl.class.getSimpleName(), this.m_handlerPoolSize.intValue(), true));
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
        if (this.m_eventIpcManagerProxy != null) {
            this.m_eventIpcManagerProxy.setDelegate((EventIpcManager)this);
        }
    }

    public EventHandler getEventHandler() {
        return this.m_eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.m_eventHandler = eventHandler;
    }

    public int getHandlerPoolSize() {
        return this.m_handlerPoolSize;
    }

    public void setHandlerPoolSize(int handlerPoolSize) {
        Assert.state((this.m_eventHandlerPool == null ? 1 : 0) != 0, (String)"handlerPoolSize property cannot be set after afterPropertiesSet() is called");
        this.m_handlerPoolSize = handlerPoolSize;
    }

    public int getHandlerQueueLength() {
        return this.m_handlerQueueLength;
    }

    public void setHandlerQueueLength(int size) {
        Assert.state((this.m_eventHandlerPool == null ? 1 : 0) != 0, (String)"handlerQueueLength property cannot be set after afterPropertiesSet() is called");
        this.m_handlerQueueLength = size;
    }

    public EventIpcManagerProxy getEventIpcManagerProxy() {
        return this.m_eventIpcManagerProxy;
    }

    public void setEventIpcManagerProxy(EventIpcManagerProxy eventIpcManagerProxy) {
        this.m_eventIpcManagerProxy = eventIpcManagerProxy;
    }

    private static class EventListenerExecutor {
        private final EventListener m_listener;
        private final ExecutorService m_delegateThread;

        EventListenerExecutor(EventListener listener, Integer handlerQueueLength) {
            this.m_listener = listener;
            this.m_delegateThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, handlerQueueLength == null ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(handlerQueueLength), (ThreadFactory)new LogPreservingThreadFactory(this.m_listener.getName(), 1, true), new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    EventIpcManagerDefaultImpl.log().warn("Listener " + EventListenerExecutor.this.m_listener.getName() + "'s event queue is full, discarding event");
                }
            });
        }

        public void addEvent(final Event event) {
            this.m_delegateThread.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (EventIpcManagerDefaultImpl.log().isInfoEnabled()) {
                            EventIpcManagerDefaultImpl.log().info("run: calling onEvent on " + EventListenerExecutor.this.m_listener.getName() + " for event " + event.getUei() + " dbid " + event.getDbid() + " with time " + event.getTime());
                        }
                        String log4jPrefix = ThreadCategory.getPrefix();
                        try {
                            EventListenerExecutor.this.m_listener.onEvent(event);
                        }
                        finally {
                            ThreadCategory.setPrefix((String)log4jPrefix);
                        }
                    }
                    catch (Throwable t) {
                        EventIpcManagerDefaultImpl.log().warn("run: an unexpected error occured during ListenerThread " + EventListenerExecutor.this.m_listener.getName() + " run: " + t, t);
                    }
                }
            });
        }

        public void stop() {
            this.m_delegateThread.shutdown();
        }
    }

    public static class DiscardTrapsAndSyslogEvents
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }
}

