/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.collectd.CollectableService;
import org.opennms.netmgt.collectd.CollectdInstrumentation;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorUpdates;
import org.opennms.netmgt.collectd.DefaultCollectdInstrumentation;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.CollectorConfigDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Collectd
extends AbstractServiceDaemon
implements EventListener {
    private static CollectdInstrumentation s_instrumentation = null;
    private static final String LOG4J_CATEGORY = "OpenNMS.Collectd";
    private final Map<String, ServiceCollector> m_collectors = new HashMap<String, ServiceCollector>(4);
    private final List<CollectableService> m_collectableServices;
    private volatile Scheduler m_scheduler;
    private volatile CollectorConfigDao m_collectorConfigDao;
    private volatile IpInterfaceDao m_ifaceDao;
    private final SchedulingCompletedFlag m_schedulingCompletedFlag = new SchedulingCompletedFlag();
    private volatile EventIpcManager m_eventIpcManager;
    private volatile TransactionTemplate m_transTemplate;
    private volatile NodeDao m_nodeDao;

    public static CollectdInstrumentation instrumentation() {
        if (s_instrumentation == null) {
            String className = System.getProperty("org.opennms.collectd.instrumentationClass", DefaultCollectdInstrumentation.class.getName());
            try {
                s_instrumentation = (CollectdInstrumentation)ClassUtils.forName((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Throwable e) {
                s_instrumentation = new DefaultCollectdInstrumentation();
            }
        }
        return s_instrumentation;
    }

    public Collectd() {
        super(LOG4J_CATEGORY);
        this.m_collectableServices = Collections.synchronizedList(new LinkedList());
    }

    protected void onInit() {
        Assert.notNull((Object)this.m_collectorConfigDao, (String)"collectorConfigDao must not be null");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"eventIpcManager must not be null");
        Assert.notNull((Object)this.m_transTemplate, (String)"transTemplate must not be null");
        Assert.notNull((Object)this.m_ifaceDao, (String)"ifaceDao must not be null");
        Assert.notNull((Object)this.m_nodeDao, (String)"nodeDao must not be null");
        this.log().debug("init: Initializing collection daemon");
        Collectd.instrumentation();
        this.instantiateCollectors();
        this.getScheduler().schedule(0L, this.ifScheduler());
        this.installMessageSelectors();
    }

    private void installMessageSelectors() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        ueiList.add("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/configureSNMP");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        ueiList.add("uei.opennms.org/internal/reloadDaemonConfig");
        ueiList.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        this.getEventIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    private ReadyRunnable ifScheduler() {
        ReadyRunnable interfaceScheduler = new ReadyRunnable(){

            @Override
            public boolean isReady() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String prefix = ThreadCategory.getPrefix();
                try {
                    ThreadCategory.setPrefix((String)Collectd.LOG4J_CATEGORY);
                    Collectd.this.scheduleExistingInterfaces();
                }
                catch (SQLException e) {
                    Collectd.this.log().error("start: Failed to schedule existing interfaces", (Throwable)e);
                }
                finally {
                    Collectd.this.setSchedulingCompleted(true);
                    ThreadCategory.setPrefix((String)prefix);
                }
            }
        };
        return interfaceScheduler;
    }

    private void createScheduler() {
        try {
            this.log().debug("init: Creating collectd scheduler");
            this.setScheduler(new LegacyScheduler("Collectd", this.getCollectorConfigDao().getSchedulerThreads()));
        }
        catch (RuntimeException e) {
            this.log().fatal("init: Failed to create collectd scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStart() {
        try {
            this.log().debug("start: Starting collectd scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            this.log().fatal("start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        this.getScheduler().stop();
        this.deinstallMessageSelectors();
        this.setScheduler(null);
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleExistingInterfaces() throws SQLException {
        Collectd.instrumentation().beginScheduleExistingInterfaces();
        try {
            this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    for (String name : Collectd.this.getCollectorNames()) {
                        Collectd.this.scheduleInterfacesWithService(name);
                    }
                    return null;
                }
            });
        }
        finally {
            Collectd.instrumentation().endScheduleExistingInterfaces();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInterfacesWithService(String svcName) {
        Collectd.instrumentation().beginScheduleInterfacesWithService(svcName);
        try {
            this.log().info("scheduleInterfacesWithService: svcName = " + svcName);
            Collection<OnmsIpInterface> ifsWithServices = this.findInterfacesWithService(svcName);
            for (OnmsIpInterface iface : ifsWithServices) {
                this.scheduleInterface(iface, svcName, true);
            }
        }
        finally {
            Collectd.instrumentation().endScheduleInterfacesWithService(svcName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<OnmsIpInterface> findInterfacesWithService(String svcName) {
        Collectd.instrumentation().beginFindInterfacesWithService(svcName);
        int count = -1;
        try {
            List ifaces = this.getIpInterfaceDao().findByServiceType(svcName);
            count = ifaces.size();
            List list = ifaces;
            return list;
        }
        finally {
            Collectd.instrumentation().endFindInterfacesWithService(svcName, count);
        }
    }

    private void scheduleInterface(int nodeId, String ipAddress, String svcName, boolean existing) {
        OnmsIpInterface iface = this.getIpInterface(nodeId, ipAddress);
        if (iface == null) {
            this.log().error("Unable to find interface with address " + ipAddress + " on node " + nodeId);
            return;
        }
        OnmsMonitoredService svc = iface.getMonitoredServiceByServiceType(svcName);
        if (svc == null) {
            this.log().error("Unable to find service " + svcName + " on interface with address " + ipAddress + " on node " + nodeId);
            return;
        }
        this.scheduleInterface(iface, svc.getServiceType().getName(), existing);
    }

    private void scheduleNode(int nodeId, final boolean existing) {
        this.getCollectorConfigDao().rebuildPackageIpListMap();
        OnmsNode node = this.m_nodeDao.getHierarchy(Integer.valueOf(nodeId));
        node.visit((EntityVisitor)new AbstractEntityVisitor(){

            public void visitMonitoredService(OnmsMonitoredService monSvc) {
                Collectd.this.scheduleInterface(monSvc.getIpInterface(), monSvc.getServiceName(), existing);
            }
        });
    }

    private OnmsIpInterface getIpInterface(int nodeId, String ipAddress) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.load((Serializable)Integer.valueOf(nodeId));
        OnmsIpInterface iface = node.getIpInterfaceByIpAddress(ipAddress);
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInterface(OnmsIpInterface iface, String svcName, boolean existing) {
        String ipAddress = InetAddressUtils.str((InetAddress)iface.getIpAddress());
        if (ipAddress == null) {
            LogUtils.warnf((Object)((Object)this), (String)"Unable to schedule interface %s, could not determine IP address.", (Object[])new Object[]{iface});
            return;
        }
        Collectd.instrumentation().beginScheduleInterface(iface.getNode().getId(), ipAddress, svcName);
        try {
            StringBuffer sb;
            Collection<CollectionSpecification> matchingSpecs = this.getSpecificationsForInterface(iface, svcName);
            if (this.log().isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("scheduleInterface: found ");
                sb.append(Integer.toString(matchingSpecs.size()));
                sb.append(" matching specs for interface: ");
                sb.append(iface);
                this.log().debug(sb.toString());
            }
            for (CollectionSpecification spec : matchingSpecs) {
                if (!existing && this.alreadyScheduled(iface, spec)) {
                    if (!this.log().isDebugEnabled()) continue;
                    sb = new StringBuffer();
                    sb.append("scheduleInterface: svc/pkgName ");
                    sb.append(iface);
                    sb.append('/');
                    sb.append(spec);
                    sb.append(" already in collectable service list, skipping.");
                    this.log().debug(sb.toString());
                    continue;
                }
                try {
                    if (this.log().isDebugEnabled()) {
                        sb = new StringBuffer();
                        sb.append("scheduleInterface: now scheduling interface: ");
                        sb.append(iface);
                        sb.append('/');
                        sb.append(svcName);
                        this.log().debug(sb.toString());
                    }
                    CollectableService cSvc = null;
                    cSvc = new CollectableService(iface, this.m_ifaceDao, spec, this.getScheduler(), this.m_schedulingCompletedFlag, this.m_transTemplate.getTransactionManager());
                    this.m_collectableServices.add(cSvc);
                    this.getScheduler().schedule(0L, cSvc.getReadyRunnable());
                    if (!this.log().isDebugEnabled()) continue;
                    sb = new StringBuffer();
                    sb.append("scheduleInterface: ");
                    sb.append(iface);
                    sb.append('/');
                    sb.append(svcName);
                    sb.append(" collection, scheduled");
                    this.log().debug(sb.toString());
                }
                catch (CollectionInitializationException e) {
                    sb = new StringBuffer();
                    sb.append("scheduleInterface: Unable to schedule ");
                    sb.append(iface);
                    sb.append('/');
                    sb.append(svcName);
                    sb.append(", reason: ");
                    sb.append(e.getMessage());
                    if (this.log().isTraceEnabled()) {
                        this.log().trace(sb.toString(), (Throwable)e);
                        continue;
                    }
                    this.log().info(sb.toString());
                }
                catch (Throwable t) {
                    sb = new StringBuffer();
                    sb.append("scheduleInterface: Uncaught exception, failed to schedule interface ");
                    sb.append(iface);
                    sb.append('/');
                    sb.append(svcName);
                    sb.append(". ");
                    sb.append(t);
                    this.log().error(sb.toString(), t);
                }
            }
        }
        finally {
            Collectd.instrumentation().endScheduleInterface(iface.getNode().getId(), ipAddress, svcName);
        }
    }

    public Collection<CollectionSpecification> getSpecificationsForInterface(OnmsIpInterface iface, String svcName) {
        LinkedList<CollectionSpecification> matchingPkgs = new LinkedList<CollectionSpecification>();
        for (CollectdPackage wpkg : this.getCollectorConfigDao().getPackages()) {
            StringBuffer sb;
            if (!wpkg.serviceInPackageAndEnabled(svcName)) {
                if (!this.log().isDebugEnabled()) continue;
                StringBuffer sb2 = new StringBuffer();
                sb2.append("getSpecificationsForInterface: address/service: ");
                sb2.append(iface);
                sb2.append("/");
                sb2.append(svcName);
                sb2.append(" not scheduled, service is not enabled or does not exist in package: ");
                sb2.append(wpkg.getName());
                this.log().debug(sb2.toString());
                continue;
            }
            String ipAddress = InetAddressUtils.str((InetAddress)iface.getIpAddress());
            if (!wpkg.interfaceInPackage(ipAddress)) {
                if (!this.log().isDebugEnabled()) continue;
                sb = new StringBuffer();
                sb.append("getSpecificationsForInterface: address/service: ");
                sb.append(iface);
                sb.append("/");
                sb.append(svcName);
                sb.append(" not scheduled, interface does not belong to package: ");
                sb.append(wpkg.getName());
                this.log().debug(sb.toString());
                continue;
            }
            if (this.log().isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("getSpecificationsForInterface: address/service: ");
                sb.append(iface);
                sb.append("/");
                sb.append(svcName);
                sb.append(" scheduled, interface does belong to package: ");
                sb.append(wpkg.getName());
                this.log().debug(sb.toString());
            }
            matchingPkgs.add(new CollectionSpecification(wpkg, svcName, this.getServiceCollector(svcName)));
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyScheduled(OnmsIpInterface iface, CollectionSpecification spec) {
        StringBuffer sb;
        String ipAddress = InetAddressUtils.str((InetAddress)iface.getIpAddress());
        if (ipAddress == null) {
            LogUtils.warnf((Object)((Object)this), (String)"Cannot determine if interface %s is already scheduled.  Unable to look up IP address.", (Object[])new Object[]{iface});
            return false;
        }
        String svcName = spec.getServiceName();
        String pkgName = spec.getPackageName();
        boolean isScheduled = false;
        if (this.log().isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("alreadyScheduled: determining if interface: ");
            sb.append(iface);
            sb.append(" is already scheduled.");
        }
        List<CollectableService> list = this.m_collectableServices;
        synchronized (list) {
            for (CollectableService cSvc : this.m_collectableServices) {
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if (!InetAddressUtils.str((InetAddress)addr).equals(ipAddress) || !cSvc.getPackageName().equals(pkgName) || !cSvc.getServiceName().equals(svcName)) continue;
                isScheduled = true;
                break;
            }
        }
        if (this.log().isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("alreadyScheduled: interface ");
            sb.append(iface);
            sb.append("already scheduled check: ");
            sb.append(isScheduled);
        }
        return isScheduled;
    }

    private void setSchedulingCompleted(boolean schedulingCompleted) {
        this.m_schedulingCompletedFlag.setSchedulingCompleted(schedulingCompleted);
    }

    private void refreshServicePackages() {
        for (CollectableService thisService : this.m_collectableServices) {
            thisService.refreshPackage(this.getCollectorConfigDao());
        }
    }

    private List<CollectableService> getCollectableServices() {
        return this.m_collectableServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(final Event event) {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    Collectd.this.onEventInTransaction(event);
                    return null;
                }
            });
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    private void onEventInTransaction(Event event) {
        this.log().debug("received event, uei = " + event.getUei());
        try {
            if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
                this.handleScheduledOutagesChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/configureSNMP")) {
                this.handleConfigureSNMP(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
                this.handleNodeGainedService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/primarySnmpInterfaceChanged")) {
                this.handlePrimarySnmpInterfaceChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/reinitializePrimarySnmpInterface")) {
                this.handleReinitializePrimarySnmpInterface(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
                this.handleInterfaceReparented(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted")) {
                this.handleNodeDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
                this.handleDupNodeDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
                this.handleInterfaceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
                this.handleServiceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
                this.handleReloadDaemonConfig(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
                this.handleNodeCategoryMembershipChanged(event);
            }
        }
        catch (InsufficientInformationException e) {
            this.handleInsufficientInfo(e);
        }
    }

    protected void handleInsufficientInfo(InsufficientInformationException e) {
        this.log().info(e.getMessage());
    }

    private void handleDupNodeDeleted(Event event) throws InsufficientInformationException {
        this.handleNodeDeleted(event);
    }

    private void handleScheduledOutagesChanged(Event event) {
        try {
            this.log().info("Reloading Collectd config factory");
            CollectdConfigFactory.reload();
            this.refreshServicePackages();
        }
        catch (Throwable e) {
            this.log().error("Failed to reload CollectdConfigFactory because " + e.getMessage(), e);
        }
    }

    private void deinstallMessageSelectors() {
        this.getEventIpcManager().removeEventListener((EventListener)this);
    }

    private void handleConfigureSNMP(Event event) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("configureSNMPHandler: processing configure SNMP event..." + event);
        }
        SnmpEventInfo info = null;
        try {
            info = new SnmpEventInfo(event);
            if (StringUtils.isBlank((String)info.getFirstIPAddress())) {
                this.log().error("configureSNMPHandler: event contained invalid firstIpAddress.  " + event);
                return;
            }
            this.log().debug("configureSNMPHandler: processing configure SNMP event: " + info);
            SnmpPeerFactory.getInstance().define(info);
            SnmpPeerFactory.saveCurrent();
            this.log().debug("configureSNMPHandler: process complete. " + info);
        }
        catch (Throwable e) {
            this.log().error("configureSNMPHandler: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterfaceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        ThreadCategory log = this.log();
        String ipAddr = event.getInterface();
        if (EventUtils.isNonIpInterface(ipAddr)) {
            this.log().debug("handleInterfaceDeleted: the deleted interface was a non-ip interface. Nothing to do here.");
            return;
        }
        Long nodeId = event.getNodeid();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if ((long)cSvc.getNodeId() != nodeId || !addr.getHostName().equals(ipAddr)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    this.log().debug("Marking CollectableService for deletion because an interface was deleted:  Service nodeid=" + cSvc.getNodeId() + ", deleted node:" + nodeId + "service address:" + addr.getHostName() + "deleted interface:" + ipAddr);
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceDeletedHandler: processing of interfaceDeleted event for " + nodeId + "/" + ipAddr + " completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterfaceReparented(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        ThreadCategory log = this.log();
        if (log.isDebugEnabled()) {
            log.debug("interfaceReparentedHandler:  processing interfaceReparented event for " + event.getInterface());
        }
        if (event.getInterface() == null) {
            return;
        }
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                oldNodeIdStr = parmContent;
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            newNodeIdStr = parmContent;
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            log.warn("interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        OnmsIpInterface iface = null;
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc2 = null;
            for (CollectableService cSvc2 : this.getCollectableServices()) {
                InetAddress addr = (InetAddress)cSvc2.getAddress();
                if (!addr.equals(event.getInterfaceAddress())) continue;
                CollectableService collectableService = cSvc2;
                synchronized (collectableService) {
                    if (log.isDebugEnabled()) {
                        log.debug("interfaceReparentedHandler: got a CollectableService match for " + event.getInterface());
                    }
                    CollectorUpdates updates = cSvc2.getCollectorUpdates();
                    if (iface == null) {
                        iface = this.getIpInterface(event.getNodeid().intValue(), event.getInterface());
                    }
                    updates.markForReparenting(oldNodeIdStr, newNodeIdStr, iface);
                    if (log.isDebugEnabled()) {
                        log.debug("interfaceReparentedHandler: marking " + event.getInterface() + " for reparenting for service SNMP.");
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceReparentedHandler: processing of interfaceReparented event for interface " + event.getInterface() + " completed.");
        }
    }

    private void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        ThreadCategory log = this.log();
        Long nodeId = event.getNodeid();
        this.unscheduleNodeAndMarkForDeletion(nodeId);
        if (log.isDebugEnabled()) {
            log.debug("nodeDeletedHandler: processing of nodeDeleted event for nodeid " + nodeId + " completed.");
        }
    }

    private void handleNodeCategoryMembershipChanged(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        ThreadCategory log = this.log();
        Long nodeId = event.getNodeid();
        this.unscheduleNodeAndMarkForDeletion(nodeId);
        if (log.isDebugEnabled()) {
            log.debug("nodeCategoryMembershipChanged: unscheduling nodeid " + nodeId + " completed.");
        }
        this.scheduleNode(nodeId.intValue(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleNodeAndMarkForDeletion(Long nodeId) {
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                if ((long)cSvc.getNodeId() != nodeId) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    this.log().debug("Marking CollectableService for deletion because a node was deleted:  Service nodeid=" + cSvc.getNodeId() + ", deleted node:" + nodeId);
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
    }

    private void handleNodeGainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        this.scheduleForCollection(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReloadDaemonConfig(Event event) {
        String daemonName = "Threshd";
        boolean isTarget = false;
        for (Parm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Threshd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        if (isTarget) {
            String thresholdsFile = ConfigFileConstants.getFileName((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
            String threshdFile = ConfigFileConstants.getFileName((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME);
            String targetFile = thresholdsFile;
            for (Object parm : event.getParmCollection()) {
                if (!"configFile".equals(parm.getParmName()) || !threshdFile.equalsIgnoreCase(parm.getValue().getContent())) continue;
                targetFile = threshdFile;
            }
            EventBuilder ebldr = null;
            try {
                Object parm;
                if (targetFile.equals(thresholdsFile)) {
                    ThresholdingConfigFactory.reload();
                }
                if (targetFile.equals(threshdFile)) {
                    ThreshdConfigFactory.reload();
                    ThresholdingConfigFactory.reload();
                }
                ebldr = new EventBuilder("uei.opennms.org/internal/thresholdConfigChange", "Collectd");
                this.getEventIpcManager().sendNow(ebldr.getEvent());
                this.log().debug("handleReloadDaemonConfig: Reloading thresholding configuration in collectd");
                parm = this.m_collectableServices;
                synchronized (parm) {
                    for (CollectableService service : this.m_collectableServices) {
                        service.reinitializeThresholding();
                    }
                }
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Collectd");
                ebldr.addParam("daemonName", "Threshd");
                ebldr.addParam("configFile", targetFile);
            }
            catch (Throwable e) {
                this.log().error("handleReloadDaemonConfig: Error reloading/processing thresholds configuration: " + e.getMessage(), e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Collectd");
                ebldr.addParam("daemonName", "Threshd");
                ebldr.addParam("configFile", targetFile);
                ebldr.addParam("reason", e.getMessage());
            }
            finally {
                if (ebldr != null) {
                    this.getEventIpcManager().sendNow(ebldr.getEvent());
                }
            }
        }
    }

    private void scheduleForCollection(Event event) {
        this.getCollectorConfigDao().rebuildPackageIpListMap();
        this.scheduleInterface(event.getNodeid().intValue(), event.getInterface(), event.getService(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrimarySnmpInterfaceChanged(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        ThreadCategory log = this.log();
        if (log.isDebugEnabled()) {
            log.debug("primarySnmpInterfaceChangedHandler:  processing primary SNMP interface changed event...");
        }
        if (!event.getService().equals("SNMP")) {
            return;
        }
        String oldPrimaryIfAddr = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("oldPrimarySnmpAddress")) continue;
            oldPrimaryIfAddr = parmContent;
        }
        if (oldPrimaryIfAddr != null) {
            List<CollectableService> list = this.getCollectableServices();
            synchronized (list) {
                CollectableService cSvc = null;
                ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
                while (liter.hasNext()) {
                    cSvc = liter.next();
                    InetAddress addr = (InetAddress)cSvc.getAddress();
                    String addrString = InetAddressUtils.str((InetAddress)addr);
                    if (addrString == null || !addrString.equals(oldPrimaryIfAddr)) continue;
                    CollectableService collectableService = cSvc;
                    synchronized (collectableService) {
                        CollectorUpdates updates = cSvc.getCollectorUpdates();
                        updates.markForDeletion();
                        if (log.isDebugEnabled()) {
                            log.debug("primarySnmpInterfaceChangedHandler: marking " + oldPrimaryIfAddr + " as deleted for service SNMP.");
                        }
                    }
                    liter.remove();
                }
            }
        }
        this.scheduleForCollection(event);
        if (log.isDebugEnabled()) {
            log.debug("primarySnmpInterfaceChangedHandler: processing of primarySnmpInterfaceChanged event for nodeid " + event.getNodeid() + " completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReinitializePrimarySnmpInterface(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        Long nodeid = event.getNodeid();
        String ipAddress = event.getInterface();
        ThreadCategory log = this.log();
        OnmsIpInterface iface = null;
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            for (CollectableService cSvc : this.getCollectableServices()) {
                InetAddress addr = (InetAddress)cSvc.getAddress();
                String addrString = InetAddressUtils.str((InetAddress)addr);
                if (log.isDebugEnabled()) {
                    log.debug("Comparing CollectableService ip address = " + addrString + " and event ip interface = " + ipAddress);
                }
                if (addrString == null || !addrString.equals(ipAddress)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    if (iface == null) {
                        iface = this.getIpInterface(nodeid.intValue(), ipAddress);
                    }
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    updates.markForReinitialization(iface);
                    if (log.isDebugEnabled()) {
                        log.debug("reinitializePrimarySnmpInterfaceHandler: marking " + ipAddress + " for reinitialization for service SNMP.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        ThreadCategory log = this.log();
        Long nodeId = event.getNodeid();
        String ipAddr = event.getInterface();
        String svcName = event.getService();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if ((long)cSvc.getNodeId() != nodeId || !addr.getHostName().equals(ipAddr) || !cSvc.getServiceName().equals(svcName)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    this.log().debug("Marking CollectableService for deletion because a service was deleted:  Service nodeid=" + cSvc.getNodeId() + ", deleted node:" + nodeId + ", service address:" + addr.getHostName() + ", deleted interface:" + ipAddr + ", service servicename:" + cSvc.getServiceName() + ", deleted service name:" + svcName + ", event source " + event.getSource());
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("serviceDeletedHandler: processing of serviceDeleted event for " + nodeId + "/" + ipAddr + "/" + svcName + " completed.");
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    private Scheduler getScheduler() {
        if (this.m_scheduler == null) {
            this.createScheduler();
        }
        return this.m_scheduler;
    }

    public void setCollectorConfigDao(CollectorConfigDao collectorConfigDao) {
        this.m_collectorConfigDao = collectorConfigDao;
    }

    private CollectorConfigDao getCollectorConfigDao() {
        return this.m_collectorConfigDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ifSvcDao) {
        this.m_ifaceDao = ifSvcDao;
    }

    private IpInterfaceDao getIpInterfaceDao() {
        return this.m_ifaceDao;
    }

    public void setTransactionTemplate(TransactionTemplate transTemplate) {
        this.m_transTemplate = transTemplate;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setServiceCollector(String svcName, ServiceCollector collector) {
        this.m_collectors.put(svcName, collector);
    }

    public ServiceCollector getServiceCollector(String svcName) {
        return this.m_collectors.get(svcName);
    }

    public Set<String> getCollectorNames() {
        return this.m_collectors.keySet();
    }

    private void instantiateCollectors() {
        this.log().debug("instantiateCollectors: Loading collectors");
        Collection collectors = this.getCollectorConfigDao().getCollectors();
        for (Collector collector : collectors) {
            String svcName = collector.getService();
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("instantiateCollectors: Loading collector " + svcName + ", classname " + collector.getClassName());
                }
                Class<?> cc = Class.forName(collector.getClassName());
                ServiceCollector sc = (ServiceCollector)cc.newInstance();
                sc.initialize(Collections.<String, String>emptyMap());
                this.setServiceCollector(svcName, sc);
            }
            catch (Throwable t) {
                this.log().warn("instantiateCollectors: Failed to load collector " + collector.getClassName() + " for service " + svcName + ": " + t, t);
            }
        }
    }

    static class SchedulingCompletedFlag {
        volatile boolean m_schedulingCompleted = false;

        SchedulingCompletedFlag() {
        }

        public synchronized void setSchedulingCompleted(boolean schedulingCompleted) {
            this.m_schedulingCompleted = schedulingCompleted;
        }

        public synchronized boolean isSchedulingCompleted() {
            return this.m_schedulingCompleted;
        }
    }
}

