/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.config.collector.AttributeGroup;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;

public abstract class AbstractCollectionResource
implements CollectionResource {
    protected CollectionAgent m_agent;
    private Map<AttributeGroupType, AttributeGroup> m_attributeGroups;

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected AbstractCollectionResource(CollectionAgent agent) {
        this.m_agent = agent;
        this.m_attributeGroups = new HashMap<AttributeGroupType, AttributeGroup>();
    }

    public String getOwnerName() {
        return this.m_agent.getHostAddress();
    }

    public File getResourceDir(RrdRepository repository) {
        return new File(repository.getRrdBaseDir(), this.m_agent.getStorageDir().toString());
    }

    protected void addAttribute(CollectionAttribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        this.log().debug("Adding attribute " + attr.getClass().getName() + ": " + attr + " to group " + group);
        group.addAttribute(attr);
    }

    protected AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_attributeGroups.get(groupType);
        if (group == null) {
            group = new AttributeGroup((CollectionResource)this, groupType);
            this.m_attributeGroups.put(groupType, group);
        }
        return group;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource((CollectionResource)this);
        for (AttributeGroup group : this.m_attributeGroups.values()) {
            group.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
    }

    public abstract int getType();

    public abstract boolean rescanNeeded();

    public abstract boolean shouldPersist(ServiceParameters var1);

    public String getLabel() {
        return null;
    }

    public TimeKeeper getTimeKeeper() {
        return null;
    }
}

