/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

public final class NamedSnmpVar
implements Collectable {
    private final String m_type;
    private Class<?> m_typeClass;
    private final String m_name;
    private final String m_oid;
    private final boolean m_isTabular;
    private final int m_column;
    public static final String SNMPINT32 = "org.opennms.protocols.snmp.SnmpInt32";
    public static final String SNMPUINT32 = "org.opennms.protocols.snmp.SnmpUInt32";
    public static final String SNMPCOUNTER32 = "org.opennms.protocols.snmp.SnmpCounter32";
    public static final String SNMPCOUNTER64 = "org.opennms.protocols.snmp.SnmpCounter64";
    public static final String SNMPGAUGE32 = "org.opennms.protocols.snmp.SnmpGauge32";
    public static final String SNMPTIMETICKS = "org.opennms.protocols.snmp.SnmpTimeTicks";
    public static final String SNMPOCTETSTRING = "org.opennms.protocols.snmp.SnmpOctetString";
    public static final String SNMPOPAQUE = "org.opennms.protocols.snmp.SnmpOpaque";
    public static final String SNMPIPADDRESS = "org.opennms.protocols.snmp.SnmpIPAddress";
    public static final String SNMPOBJECTID = "org.opennms.protocols.snmp.SnmpObjectId";
    public static final String SNMPV2PARTYCLOCK = "org.opennms.protocols.snmp.SnmpV2PartyClock";
    public static final String SNMPNOSUCHINSTANCE = "org.opennms.protocols.snmp.SnmpNoSuchInstance";
    public static final String SNMPNOSUCHOBJECT = "org.opennms.protocols.snmp.SnmpNoSuchObject";
    public static final String SNMPENDOFMIBVIEW = "org.opennms.protocols.snmp.SnmpEndOfMibView";
    public static final String SNMPNULL = "org.opennms.protocols.snmp.SnmpNull";

    public NamedSnmpVar(String type, String alias, String oid) {
        this.m_type = type;
        this.m_typeClass = null;
        this.m_name = alias;
        this.m_oid = oid;
        this.m_isTabular = false;
        this.m_column = 0;
    }

    public NamedSnmpVar(String type, String alias, String oid, int column) {
        this.m_type = type;
        this.m_typeClass = null;
        this.m_name = alias;
        this.m_oid = oid;
        this.m_isTabular = true;
        this.m_column = column;
    }

    public String getType() {
        return this.m_type;
    }

    public Class<?> getTypeClass() throws ClassNotFoundException {
        if (this.m_typeClass == null) {
            this.m_typeClass = Class.forName(this.m_type);
        }
        return this.m_typeClass;
    }

    public String getAlias() {
        return this.m_name;
    }

    public String getOid() {
        return this.m_oid;
    }

    public SnmpObjId getSnmpObjId() {
        return SnmpObjId.get((String)this.m_oid);
    }

    public boolean isTableEntry() {
        return this.m_isTabular;
    }

    public CollectionTracker getCollectionTracker() {
        return this.m_isTabular ? new ColumnTracker(this.getSnmpObjId()) : new SingleInstanceTracker(this.getSnmpObjId(), SnmpInstId.INST_ZERO);
    }

    public int getColumn() {
        return this.m_column;
    }

    public static CollectionTracker[] getTrackersFor(NamedSnmpVar[] columns) {
        if (columns == null) {
            return new CollectionTracker[0];
        }
        CollectionTracker[] trackers = new CollectionTracker[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            trackers[i] = columns[i].getCollectionTracker();
        }
        return trackers;
    }
}

