/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;

public class Win32ServicePlugin
extends SnmpPlugin {
    private static final String SV_SVC_OPERATING_STATE_OID = ".1.3.6.1.4.1.77.1.2.3.1.3";
    private static final String DEFAULT_SERVICE_NAME = "Server";

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        String serviceName = ParameterMap.getKeyedString(qualifiers, (String)"service-name", (String)DEFAULT_SERVICE_NAME);
        int snLength = serviceName.length();
        StringBuffer serviceOidBuf = new StringBuffer(SV_SVC_OPERATING_STATE_OID);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : serviceName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        if (Win32ServicePlugin.log().isDebugEnabled()) {
            Win32ServicePlugin.log().debug("For Win32 service '" + serviceName + "', OID to check is " + serviceOidBuf.toString());
        }
        qualifiers.put("vbname", serviceOidBuf.toString());
        qualifiers.put("vbvalue", "1");
        return super.isProtocolSupported(address, qualifiers);
    }

    public static ThreadCategory log() {
        return ThreadCategory.getInstance(Win32ServicePlugin.class);
    }
}

