/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.model.events.StoppableEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class Capsd
extends AbstractServiceDaemon {
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    @Autowired
    private Scheduler m_scheduler = null;
    private StoppableEventListener m_eventListener;
    private ExecutorService m_suspectRunner;
    private ExecutorService m_rescanRunner;
    @Autowired
    private SuspectEventProcessorFactory m_suspectEventProcessorFactory;
    @Autowired
    private CapsdDbSyncer m_capsdDbSyncer;

    public Capsd() {
        super("OpenNMS.Capsd");
    }

    protected void onStop() {
        this.m_eventListener.stop();
        this.m_suspectRunner.shutdown();
        this.m_rescanRunner.shutdown();
        if (this.m_scheduler != null) {
            this.m_scheduler.stop();
        }
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_suspectRunner != null ? 1 : 0) != 0, (String)"must set the suspectRunner property");
        Assert.state((this.m_rescanRunner != null ? 1 : 0) != 0, (String)"must set the rescanRunner property");
        Assert.state((this.m_eventListener != null ? 1 : 0) != 0, (String)"must set the eventListener property");
        if (System.getProperty("org.opennms.provisiond.enableDiscovery", "true").equalsIgnoreCase("true")) {
            throw new IllegalStateException("Provisiond is configured to handle discovery events. Please disable Capsd in service-configuration.xml, or set org.opennms.provisiond.enableDiscovery=false in opennms.properties!");
        }
        this.log().debug("init: Loading services into database...");
        this.m_capsdDbSyncer.syncServices();
        this.log().debug("init: Syncing management state...");
        this.m_capsdDbSyncer.syncManagementState();
        this.log().debug("init: Syncing primary SNMP interface state...");
        this.m_capsdDbSyncer.syncSnmpPrimaryState();
    }

    protected void onStart() {
        SuspectEventProcessor.setQueuedSuspectsTracker(new HashSet<String>());
        RescanProcessor.setQueuedRescansTracker(new HashSet<Integer>());
        this.log().debug("start: Starting rescan scheduler");
        this.m_scheduler.start();
    }

    protected void onPause() {
    }

    protected void onResume() {
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanSuspectInterface(String ifAddr) throws UnknownHostException {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            InetAddress addr = InetAddressUtils.addr((String)ifAddr);
            SuspectEventProcessor proc = this.m_suspectEventProcessorFactory.createSuspectEventProcessor(InetAddressUtils.str((InetAddress)addr));
            proc.run();
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanInterfaceParent(Integer nodeId) {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.m_scheduler.forceRescan(nodeId);
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    public void setSuspectRunner(ExecutorService suspectRunner) {
        this.m_suspectRunner = suspectRunner;
    }

    public void setRescanRunner(ExecutorService rescanRunner) {
        this.m_rescanRunner = rescanRunner;
    }

    public void setEventListener(StoppableEventListener eventListener) {
        this.m_eventListener = eventListener;
    }

    static {
        m_address = InetAddressUtils.getLocalHostAddressAsString();
    }
}

