/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSessionInitializer;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.ConnectionFactoryConnectorPoolImpl;
import org.opennms.netmgt.provision.support.ConnectionFactoryNewConnectorImpl;

public abstract class ConnectionFactory {
    private static final ConcurrentHashMap<Integer, ConnectionFactory> s_connectorPool = new ConcurrentHashMap();
    private int m_references = 0;
    private final long m_timeout;

    public final long getTimeout() {
        return this.m_timeout;
    }

    protected ConnectionFactory(int timeoutInMillis) {
        this.m_timeout = timeoutInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConnectionFactory getFactory(int timeoutInMillis) {
        ConcurrentHashMap<Integer, ConnectionFactory> concurrentHashMap = s_connectorPool;
        synchronized (concurrentHashMap) {
            ConnectionFactory factory = s_connectorPool.get(timeoutInMillis);
            if (factory == null) {
                LogUtils.debugf(ConnectionFactoryConnectorPoolImpl.class, (String)"Creating a ConnectionFactory for timeout %d, there are %d factories total", (Object[])new Object[]{timeoutInMillis, s_connectorPool.size()});
                ConnectionFactory newFactory = ConnectionFactory.createConnectionFactory(timeoutInMillis);
                factory = s_connectorPool.putIfAbsent(timeoutInMillis, newFactory);
                if (factory == null) {
                    factory = newFactory;
                } else {
                    LogUtils.debugf(ConnectionFactoryConnectorPoolImpl.class, (String)"ConnectionFactory for timeout %d was already created in another thread!", (Object[])new Object[]{timeoutInMillis});
                    ConnectionFactory.dispose(newFactory);
                }
            }
            ++factory.m_references;
            return factory;
        }
    }

    private static final ConnectionFactory createConnectionFactory(int timeout) {
        return new ConnectionFactoryNewConnectorImpl(timeout);
    }

    public abstract ConnectFuture connect(SocketAddress var1, IoSessionInitializer<? extends ConnectFuture> var2, IoHandler var3);

    public abstract ConnectFuture reConnect(SocketAddress var1, IoSessionInitializer<? extends ConnectFuture> var2, IoHandler var3);

    protected abstract void dispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dispose(ConnectionFactory factory) {
        if (--factory.m_references <= 0) {
            ConcurrentHashMap<Integer, ConnectionFactory> concurrentHashMap = s_connectorPool;
            synchronized (concurrentHashMap) {
                LogUtils.debugf((Object)factory, (String)"Disposing of factory %s for interval %d", (Object[])new Object[]{factory, factory.m_timeout});
                Iterator<Map.Entry<Integer, ConnectionFactory>> i = s_connectorPool.entrySet().iterator();
                while (i.hasNext()) {
                    if (i.next().getValue() != factory) continue;
                    i.remove();
                }
            }
            factory.dispose();
        }
    }
}

