/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.AliasBuilder;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.OrderBuilder;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.utils.LogUtils;

public class CriteriaBuilder {
    private Class<?> m_class;
    private OrderBuilder m_orderBuilder = new OrderBuilder();
    private Set<Fetch> m_fetch = new LinkedHashSet<Fetch>();
    private AliasBuilder m_aliasBuilder = new AliasBuilder();
    private boolean m_distinct = false;
    private Set<Restriction> m_restrictions = new LinkedHashSet<Restriction>();
    private boolean m_negateNext = false;
    private Integer m_limit = null;
    private Integer m_offset = null;
    private String m_matchType = "all";
    private static final Restriction[] EMPTY_RESTRICTION_ARRAY = new Restriction[0];

    public CriteriaBuilder(Class<?> clazz) {
        this.m_class = clazz;
    }

    public Criteria toCriteria() {
        Criteria criteria = new Criteria(this.m_class);
        criteria.setOrders(this.m_orderBuilder.getOrderCollection());
        criteria.setAliases(this.m_aliasBuilder.getAliasCollection());
        criteria.setFetchTypes(this.m_fetch);
        criteria.setDistinct(this.m_distinct);
        criteria.setLimit(this.m_limit);
        criteria.setOffset(this.m_offset);
        if ("any".equals(this.m_matchType)) {
            criteria.setRestrictions(Collections.singleton(Restrictions.any(this.m_restrictions.toArray(EMPTY_RESTRICTION_ARRAY))));
        } else {
            criteria.setRestrictions(this.m_restrictions);
        }
        return criteria;
    }

    public CriteriaBuilder match(String type) {
        if (!"all".equals(type) && !"any".equals(type)) {
            throw new IllegalArgumentException("match type must be 'all' or 'any'");
        }
        this.m_matchType = type;
        return this;
    }

    public CriteriaBuilder fetch(String attribute) {
        this.m_fetch.add(new Fetch(attribute));
        return this;
    }

    public CriteriaBuilder fetch(String attribute, Fetch.FetchType type) {
        this.m_fetch.add(new Fetch(attribute, type));
        return this;
    }

    public CriteriaBuilder join(String associationPath, String alias) {
        return this.alias(associationPath, alias, Alias.JoinType.LEFT_JOIN);
    }

    public CriteriaBuilder alias(String associationPath, String alias) {
        return this.alias(associationPath, alias, Alias.JoinType.LEFT_JOIN);
    }

    public CriteriaBuilder join(String associationPath, String alias, Alias.JoinType type) {
        return this.alias(associationPath, alias, type);
    }

    public CriteriaBuilder alias(String associationPath, String alias, Alias.JoinType type) {
        this.m_aliasBuilder.alias(associationPath, alias, type);
        return this;
    }

    public CriteriaBuilder limit(Integer limit) {
        this.m_limit = limit == null || limit == 0 ? null : limit;
        return this;
    }

    public CriteriaBuilder offset(Integer offset) {
        this.m_offset = offset == null || offset == 0 ? null : offset;
        return this;
    }

    public CriteriaBuilder clearOrder() {
        this.m_orderBuilder.clear();
        return this;
    }

    public CriteriaBuilder orderBy(String attribute) {
        return this.orderBy(attribute, true);
    }

    public CriteriaBuilder orderBy(String attribute, boolean ascending) {
        this.m_orderBuilder.append(new Order(attribute, ascending));
        return this;
    }

    public CriteriaBuilder asc() {
        this.m_orderBuilder.asc();
        return this;
    }

    public CriteriaBuilder desc() {
        this.m_orderBuilder.desc();
        return this;
    }

    public CriteriaBuilder distinct() {
        this.m_distinct = true;
        return this;
    }

    public CriteriaBuilder count() {
        this.m_orderBuilder.clear();
        this.m_limit = null;
        this.m_offset = null;
        return this;
    }

    public CriteriaBuilder distinct(boolean isDistinct) {
        this.m_distinct = isDistinct;
        return this;
    }

    private boolean addRestriction(Restriction restriction) {
        if (this.m_negateNext) {
            this.m_negateNext = false;
            return this.m_restrictions.add(Restrictions.not(restriction));
        }
        return this.m_restrictions.add(restriction);
    }

    public CriteriaBuilder isNull(String attribute) {
        this.addRestriction(Restrictions.isNull(attribute));
        return this;
    }

    public CriteriaBuilder isNotNull(String attribute) {
        this.addRestriction(Restrictions.isNotNull(attribute));
        return this;
    }

    public CriteriaBuilder id(Integer id) {
        this.addRestriction(Restrictions.id(id));
        return this;
    }

    public CriteriaBuilder eq(String attribute, Object comparator) {
        this.addRestriction(Restrictions.eq(attribute, comparator));
        return this;
    }

    public CriteriaBuilder ne(String attribute, Object comparator) {
        if (this.m_negateNext) {
            this.m_negateNext = false;
            this.addRestriction(Restrictions.eq(attribute, comparator));
        } else {
            this.addRestriction(Restrictions.not(Restrictions.eq(attribute, comparator)));
        }
        return this;
    }

    public CriteriaBuilder gt(String attribute, Object comparator) {
        this.addRestriction(Restrictions.gt(attribute, comparator));
        return this;
    }

    public CriteriaBuilder ge(String attribute, Object comparator) {
        this.addRestriction(Restrictions.ge(attribute, comparator));
        return this;
    }

    public CriteriaBuilder lt(String attribute, Object comparator) {
        this.addRestriction(Restrictions.lt(attribute, comparator));
        return this;
    }

    public CriteriaBuilder le(String attribute, Object comparator) {
        this.addRestriction(Restrictions.le(attribute, comparator));
        return this;
    }

    public CriteriaBuilder like(String attribute, Object comparator) {
        this.addRestriction(Restrictions.like(attribute, comparator));
        return this;
    }

    public CriteriaBuilder ilike(String attribute, Object comparator) {
        this.addRestriction(Restrictions.ilike(attribute, comparator));
        return this;
    }

    public CriteriaBuilder iplike(String attribute, Object comparator) {
        this.addRestriction(Restrictions.iplike(attribute, comparator));
        return this;
    }

    public CriteriaBuilder contains(String attribute, Object comparator) {
        this.addRestriction(Restrictions.ilike(attribute, "%" + comparator + "%"));
        return this;
    }

    public CriteriaBuilder in(String attribute, List<?> list) {
        this.addRestriction(Restrictions.in(attribute, list));
        return this;
    }

    public CriteriaBuilder between(String attribute, Object begin, Object end) {
        this.addRestriction(Restrictions.between(attribute, begin, end));
        return this;
    }

    public CriteriaBuilder sql(Object sql) {
        if (sql instanceof String) {
            this.addRestriction(Restrictions.sql((String)sql));
        } else {
            LogUtils.warnf((Object)this, (String)("sql(): " + sql.getClass().getName() + " is not a string type, can't add"), (Object[])new Object[0]);
        }
        return this;
    }

    public CriteriaBuilder not() {
        this.m_negateNext = true;
        return this;
    }

    public CriteriaBuilder and(Restriction lhs, Restriction rhs) {
        this.addRestriction(Restrictions.and(lhs, rhs));
        return this;
    }

    public CriteriaBuilder or(Restriction lhs, Restriction rhs) {
        AnyRestriction restriction = Restrictions.or(lhs, rhs);
        this.addRestriction(restriction);
        return this;
    }
}

