/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.Restriction;

public class Criteria {
    private static final Pattern SPLIT_ON = Pattern.compile("\\.");
    private Class<?> m_class;
    private List<Order> m_orders = new ArrayList<Order>();
    private List<Alias> m_aliases = new ArrayList<Alias>();
    private Set<Fetch> m_fetchTypes = new LinkedHashSet<Fetch>();
    private Set<Restriction> m_restrictions = new LinkedHashSet<Restriction>();
    private boolean m_distinct = false;
    private Integer m_limit = null;
    private Integer m_offset = null;

    public void visit(CriteriaVisitor visitor) {
        visitor.visitClass(this.getCriteriaClass());
        for (Order order : this.getOrders()) {
            visitor.visitOrder(order);
        }
        visitor.visitOrdersFinished();
        for (Alias alias : this.getAliases()) {
            visitor.visitAlias(alias);
        }
        visitor.visitAliasesFinished();
        for (Fetch fetch : this.getFetchTypes()) {
            visitor.visitFetch(fetch);
        }
        visitor.visitFetchesFinished();
        for (Restriction restriction : this.getRestrictions()) {
            visitor.visitRestriction(restriction);
        }
        visitor.visitRestrictionsFinished();
        visitor.visitDistinct(this.isDistinct());
        visitor.visitLimit(this.getLimit());
        visitor.visitOffset(this.getOffset());
    }

    public Criteria(Class<?> clazz) {
        this.m_class = clazz;
    }

    public Class<?> getCriteriaClass() {
        return this.m_class;
    }

    public List<Order> getOrders() {
        return Collections.unmodifiableList(this.m_orders);
    }

    public void setOrders(Collection<? extends Order> orderCollection) {
        this.m_orders.clear();
        this.m_orders.addAll(orderCollection);
    }

    public List<Fetch> getFetchTypes() {
        return Collections.unmodifiableList(new ArrayList<Fetch>(this.m_fetchTypes));
    }

    public void setFetchTypes(Collection<? extends Fetch> fetchTypes) {
        this.m_fetchTypes.clear();
        this.m_fetchTypes.addAll(fetchTypes);
    }

    public List<Alias> getAliases() {
        return Collections.unmodifiableList(this.m_aliases);
    }

    public void setAliases(Collection<? extends Alias> aliases) {
        this.m_aliases.clear();
        this.m_aliases.addAll(aliases);
    }

    public List<Restriction> getRestrictions() {
        return Collections.unmodifiableList(new ArrayList<Restriction>(this.m_restrictions));
    }

    public void setRestrictions(Collection<? extends Restriction> restrictions) {
        this.m_restrictions.clear();
        this.m_restrictions.addAll(restrictions);
    }

    public void addRestriction(Restriction restriction) {
        this.m_restrictions.add(restriction);
    }

    public boolean isDistinct() {
        return this.m_distinct;
    }

    public void setDistinct(boolean distinct) {
        this.m_distinct = distinct;
    }

    public Integer getLimit() {
        return this.m_limit;
    }

    public void setLimit(Integer limit) {
        this.m_limit = limit;
    }

    public Integer getOffset() {
        return this.m_offset;
    }

    public void setOffset(Integer offset) {
        this.m_offset = offset;
    }

    public Class<?> getType(String path) throws IntrospectionException {
        return this.getType(this.getCriteriaClass(), path);
    }

    private Class<?> getType(Class<?> clazz, String path) throws IntrospectionException {
        String[] split = SPLIT_ON.split(path);
        List<String> pathSections = Arrays.asList(split);
        return this.getType(clazz, pathSections, new ArrayList<Alias>(this.getAliases()));
    }

    private Class<?> getType(Class<?> clazz, List<String> pathSections, List<Alias> aliases) throws IntrospectionException {
        if (pathSections.isEmpty()) {
            return clazz;
        }
        String pathElement = pathSections.get(0);
        List<String> remaining = pathSections.subList(1, pathSections.size());
        Iterator<Alias> aliasIterator = aliases.iterator();
        while (aliasIterator.hasNext()) {
            Alias alias = aliasIterator.next();
            if (alias.getAlias().equals(alias.getAssociationPath()) || !alias.getAlias().equals(pathElement)) continue;
            aliasIterator.remove();
            String associationPath = alias.getAssociationPath();
            ArrayList<String> paths = new ArrayList<String>();
            paths.addAll(Arrays.asList(SPLIT_ON.split(associationPath)));
            paths.addAll(remaining);
            return this.getType(clazz, paths, aliases);
        }
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            Type[] t;
            if (!pathElement.equals(pd.getName())) continue;
            Class<?> propertyType = pd.getPropertyType();
            if (Collection.class.isAssignableFrom(propertyType) && (t = this.getGenericReturnType(pd)) != null && t.length == 1) {
                return this.getType((Class)t[0], remaining, aliases);
            }
            return this.getType(propertyType, remaining, aliases);
        }
        return null;
    }

    private Type[] getGenericReturnType(PropertyDescriptor pd) {
        Type returnType;
        Method m = pd.getReadMethod();
        if (m != null && (returnType = m.getGenericReturnType()) != null && returnType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)returnType;
            return pt.getActualTypeArguments();
        }
        return new Type[0];
    }

    public String toString() {
        return "Criteria [class=" + this.m_class + ", orders=" + this.m_orders + ", aliases=" + this.m_aliases + ", fetchTypes=" + this.m_fetchTypes + ", restrictions=" + this.m_restrictions + ", distinct=" + this.m_distinct + ", limit=" + this.m_limit + ", offset=" + this.m_offset + "]";
    }

    public static interface CriteriaVisitor {
        public void visitClass(Class<?> var1);

        public void visitOrder(Order var1);

        public void visitOrdersFinished();

        public void visitAlias(Alias var1);

        public void visitAliasesFinished();

        public void visitFetch(Fetch var1);

        public void visitFetchesFinished();

        public void visitRestriction(Restriction var1);

        public void visitRestrictionsFinished();

        public void visitDistinct(boolean var1);

        public void visitLimit(Integer var1);

        public void visitOffset(Integer var1);
    }
}

