/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.opennms.core.utils.ThreadCategory;
import org.slf4j.Logger;

public abstract class LogUtils {
    public static void tracef(Object logee, String format, Object ... args) {
        LogUtils.tracef(logee, null, format, args);
    }

    public static void tracef(Object logee, Throwable throwable, String format, Object ... args) {
        Logger log = LogUtils.getLogger(logee);
        if (log.isTraceEnabled()) {
            String logMessage;
            String string = logMessage = args == null || args.length < 1 ? format : String.format(format, args);
            if (throwable == null) {
                log.trace(logMessage);
            } else {
                log.trace(logMessage, throwable);
            }
        }
    }

    public static void debugf(Object logee, String format, Object ... args) {
        LogUtils.debugf(logee, null, format, args);
    }

    public static void debugf(Object logee, Throwable throwable, String format, Object ... args) {
        Logger log = LogUtils.getLogger(logee);
        if (log.isDebugEnabled()) {
            String logMessage;
            String string = logMessage = args == null || args.length < 1 ? format : String.format(format, args);
            if (throwable == null) {
                log.debug(logMessage);
            } else {
                log.debug(logMessage, throwable);
            }
        }
    }

    public static void infof(Object logee, String format, Object ... args) {
        LogUtils.infof(logee, null, format, args);
    }

    public static void infof(Object logee, Throwable throwable, String format, Object ... args) {
        Logger log = LogUtils.getLogger(logee);
        if (log.isInfoEnabled()) {
            String logMessage;
            String string = logMessage = args == null || args.length < 1 ? format : String.format(format, args);
            if (throwable == null) {
                log.info(logMessage);
            } else {
                log.info(logMessage, throwable);
            }
        }
    }

    public static void warnf(Object logee, String format, Object ... args) {
        LogUtils.warnf(logee, null, format, args);
    }

    public static void warnf(Object logee, Throwable throwable, String format, Object ... args) {
        Logger log = LogUtils.getLogger(logee);
        if (log.isWarnEnabled()) {
            String logMessage;
            String string = logMessage = args == null || args.length < 1 ? format : String.format(format, args);
            if (throwable == null) {
                log.warn(logMessage);
            } else {
                log.warn(logMessage, throwable);
            }
        }
    }

    public static void errorf(Object logee, String format, Object ... args) {
        LogUtils.errorf(logee, null, format, args);
    }

    public static void errorf(Object logee, Throwable throwable, String format, Object ... args) {
        Logger log = LogUtils.getLogger(logee);
        if (log.isErrorEnabled()) {
            String logMessage;
            String string = logMessage = args == null || args.length < 1 ? format : String.format(format, args);
            if (throwable == null) {
                log.error(logMessage);
            } else {
                log.error(logMessage, throwable);
            }
        }
    }

    public static void fatalf(Object logee, String format, Object ... args) {
        LogUtils.errorf(logee, null, format, args);
    }

    public static void fatalf(Object logee, Throwable throwable, String format, Object ... args) {
        LogUtils.errorf(logee, throwable, format, args);
    }

    public static void logToConsole() {
        Properties logConfig = new Properties();
        logConfig.setProperty("log4j.reset", "true");
        logConfig.setProperty("log4j.rootCategory", "INFO, CONSOLE");
        logConfig.setProperty("log4j.appender.CONSOLE", "org.apache.log4j.ConsoleAppender");
        logConfig.setProperty("log4j.appender.CONSOLE.layout", "org.apache.log4j.PatternLayout");
        logConfig.setProperty("log4j.appender.CONSOLE.layout.ConversionPattern", "%d %-5p [%t] %c: %m%n");
        PropertyConfigurator.configure((Properties)logConfig);
    }

    public static void logToFile(String file) {
        Properties logConfig = new Properties();
        logConfig.setProperty("log4j.reset", "true");
        logConfig.setProperty("log4j.rootCategory", "INFO, FILE");
        logConfig.setProperty("log4j.appender.FILE", "org.apache.log4j.RollingFileAppender");
        logConfig.setProperty("log4j.appender.FILE.MaxFileSize", "100MB");
        logConfig.setProperty("log4j.appender.FILE.MaxBackupIndex", "4");
        logConfig.setProperty("log4j.appender.FILE.File", file);
        logConfig.setProperty("log4j.appender.FILE.layout", "org.apache.log4j.PatternLayout");
        logConfig.setProperty("log4j.appender.FILE.layout.ConversionPattern", "%d %-5p [%t] %c: %m%n");
        PropertyConfigurator.configure((Properties)logConfig);
    }

    public static void enableDebugging() {
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.ALL);
    }

    public static boolean isTraceEnabled(Object logee) {
        return LogUtils.getLogger(logee).isTraceEnabled();
    }

    public static boolean isDebugEnabled(Object logee) {
        return LogUtils.getLogger(logee).isDebugEnabled();
    }

    private static Logger getLogger(Object logee) {
        Logger log = logee instanceof Class ? ThreadCategory.getSlf4jInstance((Class)logee) : (logee instanceof String ? ThreadCategory.getSlf4jInstance((String)logee) : ThreadCategory.getSlf4jInstance(logee.getClass()));
        return log;
    }
}

