/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import org.opennms.core.utils.LogUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class SimpleNamespaceFilter
extends XMLFilterImpl {
    private String m_namespaceUri;
    private boolean m_addNamespace = false;
    private boolean m_addedNamespace = false;

    public SimpleNamespaceFilter(String namespaceUri, boolean addNamespace) {
        LogUtils.debugf((Object)this, (String)"SimpleNamespaceFilter initalized with namespace %s (%s)", (Object[])new Object[]{namespaceUri, addNamespace});
        this.m_namespaceUri = addNamespace ? namespaceUri.intern() : "".intern();
        this.m_addNamespace = addNamespace;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.m_addNamespace) {
            this.startControlledPrefixMapping();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.m_addNamespace) {
            if (LogUtils.isTraceEnabled((Object)this)) {
                LogUtils.tracef((Object)this, (String)"start: uri = %s, new uri = %s, localName = %s, qName = %s, attributes = %s", (Object[])new Object[]{uri, this.m_namespaceUri, localName, qName, attributes});
            }
            super.startElement(this.m_namespaceUri, localName, qName, attributes);
        } else {
            if (LogUtils.isTraceEnabled((Object)this)) {
                LogUtils.tracef((Object)this, (String)"start: uri = %s, new uri = %s, localName = %s, qName = %s, attributes = %s", (Object[])new Object[]{uri, uri, localName, qName, attributes});
            }
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_addNamespace) {
            if (LogUtils.isTraceEnabled((Object)this)) {
                LogUtils.tracef((Object)this, (String)"end:   uri = %s, new uri = %s, localName = %s, qName = %s", (Object[])new Object[]{uri, this.m_namespaceUri, localName, qName});
            }
            super.endElement(this.m_namespaceUri, localName, qName);
        } else {
            if (LogUtils.isTraceEnabled((Object)this)) {
                LogUtils.tracef((Object)this, (String)"end:   uri = %s, new uri = %s, localName = %s, qName = %s", (Object[])new Object[]{uri, uri, localName, qName});
            }
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String url) throws SAXException {
        if (LogUtils.isTraceEnabled((Object)this)) {
            LogUtils.tracef((Object)this, (String)"startPrefixMapping: prefix = %s, url = %s", (Object[])new Object[]{prefix, url});
        }
        if (this.m_addNamespace) {
            this.startControlledPrefixMapping();
        } else {
            super.startPrefixMapping(prefix, url);
        }
    }

    private void startControlledPrefixMapping() throws SAXException {
        if (LogUtils.isTraceEnabled((Object)this)) {
            LogUtils.tracef((Object)this, (String)"startControlledPrefixMapping", (Object[])new Object[0]);
        }
        if (this.m_addNamespace && !this.m_addedNamespace) {
            super.startPrefixMapping("".intern(), this.m_namespaceUri);
            this.m_addedNamespace = true;
        }
    }
}

