/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.wmi;

import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.opennms.core.utils.LogUtils;
import org.opennms.protocols.wmi.IWmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.wbem.OnmsWbemFlagReturnEnum;
import org.opennms.protocols.wmi.wbem.OnmsWbemObject;
import org.opennms.protocols.wmi.wbem.OnmsWbemObjectSet;
import org.opennms.protocols.wmi.wbem.jinterop.OnmsWbemObjectImpl;
import org.opennms.protocols.wmi.wbem.jinterop.OnmsWbemObjectSetImpl;

public class WmiClient
implements IWmiClient {
    private JIComServer m_ComStub = null;
    private IJIComObject m_ComObject = null;
    private IJIDispatch m_Dispatch = null;
    private String m_Address = null;
    private JISession m_Session = null;
    private IJIDispatch m_WbemServices = null;
    private static final String WMI_CLSID = "76A6415B-CB41-11d1-8B02-00600806D9B6";
    private static final String WMI_PROGID = "WbemScripting.SWbemLocator";

    public WmiClient(String address) throws WmiException {
        JISystem.setAutoRegisteration((boolean)true);
        JISystem.getLogger().setLevel(Level.OFF);
        this.m_Address = address;
    }

    @Override
    public OnmsWbemObjectSet performInstanceOf(String wmiClass) throws WmiException {
        try {
            JIVariant[] results = this.m_WbemServices.callMethodA("InstancesOf", new Object[]{new JIString(wmiClass), 0, JIVariant.OPTIONAL_PARAM()});
            IJIDispatch wOSd = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            return new OnmsWbemObjectSetImpl(wOSd);
        }
        catch (JIException e) {
            throw new WmiException("Failed to perform WMI operation (\\\\" + wmiClass + ") : " + e.getMessage(), e);
        }
    }

    @Override
    public OnmsWbemObjectSet performExecQuery(String strQuery) throws WmiException {
        return this.performExecQuery(strQuery, "WQL", OnmsWbemFlagReturnEnum.wbemFlagReturnImmediately.getReturnFlagValue());
    }

    @Override
    public OnmsWbemObjectSet performExecQuery(String strQuery, String strQueryLanguage, Integer flags) throws WmiException {
        try {
            JIVariant[] results = this.m_WbemServices.callMethodA("ExecQuery", new Object[]{new JIString(strQuery), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch wOSd = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            return new OnmsWbemObjectSetImpl(wOSd);
        }
        catch (JIException e) {
            throw new WmiException("Failed to execute query '" + strQuery + "': " + e.getMessage(), e);
        }
    }

    public OnmsWbemObject performWmiGet(String strObjectPath) throws WmiException {
        try {
            JIVariant[] results = this.m_WbemServices.callMethodA("Get", new Object[]{new JIString(strObjectPath), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch obj_dsp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            return new OnmsWbemObjectImpl(obj_dsp);
        }
        catch (JIException e) {
            throw new WmiException("Failed to perform get '" + strObjectPath + "': " + e.getMessage(), e);
        }
    }

    public OnmsWbemObjectSet performSubclassOf(String strSuperClass) throws WmiException {
        try {
            JIVariant[] results = this.m_WbemServices.callMethodA("SubclassesOf", new Object[]{new JIString(strSuperClass), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch objset_dsp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            return new OnmsWbemObjectSetImpl(objset_dsp);
        }
        catch (JIException e) {
            throw new WmiException("Failed to perform SubclassesOf '" + strSuperClass + "': " + e.getMessage(), e);
        }
    }

    public OnmsWbemObjectSet performSubclassOf() throws WmiException {
        try {
            JIVariant[] results = this.m_WbemServices.callMethodA("SubclassesOf", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch objset_dsp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            return new OnmsWbemObjectSetImpl(objset_dsp);
        }
        catch (JIException e) {
            throw new WmiException("Failed to perform SubclassesOf: " + e.getMessage(), e);
        }
    }

    public static Object convertToNativeType(JIVariant type) throws WmiException {
        try {
            if (type.isArray()) {
                Object[] array;
                ArrayList<Object> objs = new ArrayList<Object>();
                for (Object element : array = (Object[])type.getObjectAsArray().getArrayInstance()) {
                    objs.add(WmiClient.convertToNativeType((JIVariant)element));
                }
                return objs;
            }
            switch (type.getType()) {
                case 1: {
                    return null;
                }
                case 8: {
                    return type.getObjectAsString().getString();
                }
                case 2: {
                    return type.getObjectAsShort();
                }
                case 3: {
                    return type.getObjectAsInt();
                }
                case 17: {
                    return type.getObjectAsUnsigned().getValue();
                }
                case 11: {
                    return type.getObjectAsBoolean();
                }
                case 14: {
                    return Float.valueOf(type.getObjectAsFloat());
                }
                case 7: {
                    return type.getObjectAsDate();
                }
            }
            throw new WmiException("Unknown type presented (" + type.getType() + "), defaulting to Object: " + type.toString());
        }
        catch (JIException e) {
            throw new WmiException("Failed to conver WMI type to native object: " + e.getMessage(), e);
        }
    }

    @Override
    public void connect(String domain, String username, String password) throws WmiException {
        try {
            this.m_Session = JISession.createSession((String)domain, (String)username, (String)password);
            this.m_Session.useSessionSecurity(true);
            this.m_Session.setGlobalSocketTimeout(5000);
            this.m_ComStub = new JIComServer(JIProgId.valueOf((String)WMI_PROGID), this.m_Address, this.m_Session);
            IJIComObject unknown = this.m_ComStub.createInstance();
            this.m_ComObject = unknown.queryInterface(WMI_CLSID);
            this.m_Dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)this.m_ComObject.queryInterface("00020400-0000-0000-c000-000000000046"));
            JIVariant[] results = this.m_Dispatch.callMethodA("ConnectServer", new Object[]{new JIString(this.m_Address), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), 0, JIVariant.OPTIONAL_PARAM()});
            this.m_WbemServices = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        }
        catch (JIException e) {
            if (this.m_Session != null) {
                try {
                    JISession.destroySession((JISession)this.m_Session);
                }
                catch (JIException e1) {
                    LogUtils.errorf((Object)this, (Throwable)e1, (String)"Failed to destroy session after incomplete connect with host '%s'.", (Object[])new Object[]{this.m_Address});
                }
            }
            throw new WmiException("Failed to establish COM session with host '" + this.m_Address + "': " + e.getMessage(), e);
        }
        catch (UnknownHostException e) {
            if (this.m_Session != null) {
                try {
                    JISession.destroySession((JISession)this.m_Session);
                }
                catch (JIException e1) {
                    LogUtils.errorf((Object)this, (Throwable)e1, (String)"Failed to destroy session after unknown host '%s'.", (Object[])new Object[]{this.m_Address});
                }
            }
            throw new WmiException("Unknown host '" + this.m_Address + "'. Failed to connect to WMI agent.", e);
        }
    }

    @Override
    public void disconnect() throws WmiException {
        try {
            JISession.destroySession((JISession)this.m_Session);
        }
        catch (JIException e) {
            throw new WmiException("Failed to destroy J-Interop session: " + e.getMessage(), e);
        }
    }

    public static Date convertWmiDate(String dateStr) throws ParseException {
        return new SimpleDateFormat("yyyyMMddHHmmss.ssssss+000").parse(dateStr);
    }

    private static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static boolean isDate(String str) {
        try {
            DateFormat.getDateInstance().parse(str);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

