/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.net.InetAddress;
import java.util.Queue;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.IcmpMessengerIOException;
import org.opennms.netmgt.icmp.jna.JnaPingReply;
import org.opennms.netmgt.icmp.jna.JnaPingRequest;
import org.opennms.netmgt.icmp.jna.PingReplyListener;
import org.opennms.netmgt.icmp.jna.V4Pinger;
import org.opennms.netmgt.icmp.jna.V6Pinger;
import org.opennms.protocols.rt.Messenger;

public class JnaIcmpMessenger
implements Messenger<JnaPingRequest, JnaPingReply>,
PingReplyListener {
    private V4Pinger m_v4;
    private V6Pinger m_v6;
    private Queue<JnaPingReply> pendingReplies = null;

    public JnaIcmpMessenger(int pingerId) throws Exception {
        Throwable error = null;
        try {
            this.m_v4 = new V4Pinger(pingerId);
            this.m_v4.addPingReplyListener(this);
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Unable to initialize IPv4 Pinger.", (Object[])new Object[0]);
            error = t;
            this.m_v4 = null;
        }
        try {
            this.m_v6 = new V6Pinger(pingerId);
            this.m_v6.addPingReplyListener(this);
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Unable to initialize IPv6 Pinger.", (Object[])new Object[0]);
            if (error == null) {
                error = t;
            }
            this.m_v6 = null;
        }
        if (this.m_v4 == null && this.m_v6 == null) {
            IcmpMessengerIOException exception = new IcmpMessengerIOException("IPv4 and IPv6 are not available.", error);
            LogUtils.warnf((Object)this, (Throwable)exception, (String)"Unable to initialize JNA ICMP messenger", (Object[])new Object[0]);
            throw exception;
        }
    }

    public boolean isV4Available() {
        return this.m_v4 != null;
    }

    public boolean isV6Available() {
        return this.m_v6 != null;
    }

    public void sendRequest(JnaPingRequest request) {
        request.send(this.m_v4, this.m_v6);
    }

    public void start(Queue<JnaPingReply> replyQueue) {
        this.pendingReplies = replyQueue;
        this.m_v4.start();
        this.m_v6.start();
    }

    @Override
    public void onPingReply(InetAddress address, EchoPacket packet) {
        this.pendingReplies.offer(new JnaPingReply(address, packet));
    }
}

