/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jmx;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.opennms.netmgt.dao.DaemonStatusDao;
import org.opennms.netmgt.dao.ServiceInfo;
import org.opennms.netmgt.dao.jmx.JmxObjectNameException;
import org.opennms.netmgt.model.ServiceDaemon;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jmx.access.MBeanProxyFactoryBean;

public class JmxDaemonStatusDao
implements DaemonStatusDao {
    private MBeanServer mbeanServer;

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Override
    public Map<String, ServiceInfo> getCurrentDaemonStatus() {
        Set<ObjectName> mBeanNames;
        HashMap<String, ServiceInfo> serviceInfo = new HashMap<String, ServiceInfo>();
        try {
            mBeanNames = this.queryMbeanServerForNames(new ObjectName("opennms:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new JmxObjectNameException("Object name 'opennms:*' was malformed!", e);
        }
        catch (NullPointerException e) {
            throw new JmxObjectNameException("Object name param is null.", e);
        }
        for (ObjectName mBeanName : mBeanNames) {
            ServiceDaemon serviceDaemon = this.buildProxy(mBeanName);
            String name = serviceDaemon.getName();
            String status = serviceDaemon.status();
            serviceInfo.put(name, new ServiceInfo(name, status));
        }
        serviceInfo.put("test", new ServiceInfo("test", "started"));
        return serviceInfo;
    }

    private Set<ObjectName> queryMbeanServerForNames(ObjectName foo1, QueryExp foo2) {
        return this.mbeanServer.queryNames(foo1, foo2);
    }

    public Collection<ServiceInfo> getCurrentDaemonStatusColl() {
        return this.getCurrentDaemonStatus().values();
    }

    @Override
    public ServiceDaemon getServiceHandle(String service) {
        Set<ObjectName> mBeanNames;
        try {
            mBeanNames = this.queryMbeanServerForNames(new ObjectName("opennms:Name=" + service + ",*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new JmxObjectNameException("Object name 'opennms:Name=" + service + ",*' was malformed!", e);
        }
        catch (NullPointerException e) {
            throw new JmxObjectNameException("Object name param is null.", e);
        }
        ObjectName mBeanName = (ObjectName)DataAccessUtils.requiredUniqueResult(mBeanNames);
        return this.buildProxy(mBeanName);
    }

    private ServiceDaemon buildProxy(ObjectName mBeanName) {
        MBeanProxyFactoryBean mBeanProxyFactoryBean = new MBeanProxyFactoryBean();
        try {
            mBeanProxyFactoryBean.setObjectName((Object)mBeanName.getCanonicalName());
        }
        catch (MalformedObjectNameException e) {
            throw new JmxObjectNameException("Object name '" + mBeanName.getCanonicalName() + "' was malformed!", e);
        }
        mBeanProxyFactoryBean.setProxyInterface(ServiceDaemon.class);
        mBeanProxyFactoryBean.afterPropertiesSet();
        return (ServiceDaemon)mBeanProxyFactoryBean.getObject();
    }
}

