/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db.columnchanges;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.netmgt.dao.db.ColumnChange;
import org.opennms.netmgt.dao.db.ColumnChangeReplacement;

public class NextValReplacement
implements ColumnChangeReplacement {
    private final String m_sequence;
    private final Connection m_connection;
    private final PreparedStatement m_statement;

    public NextValReplacement(String sequence, DataSource dataSource) throws SQLException {
        this.m_sequence = sequence;
        this.m_connection = dataSource.getConnection();
        this.m_statement = this.m_connection.prepareStatement("SELECT nextval('" + this.m_sequence + "')");
    }

    private PreparedStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public Integer getColumnReplacement(ResultSet rs, Map<String, ColumnChange> columnChanges) throws SQLException {
        ResultSet r = this.getStatement().executeQuery();
        if (!r.next()) {
            r.close();
            throw new SQLException("Query for next value of sequence did not return any rows.");
        }
        int i = r.getInt(1);
        r.close();
        return i;
    }

    @Override
    public boolean addColumnIfColumnIsNew() {
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.finalize();
    }

    protected void finalize() throws SQLException {
        if (this.m_statement != null) {
            this.m_statement.close();
        }
        if (this.m_connection != null) {
            this.m_connection.close();
        }
    }
}

