/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collector;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;

public class ServiceParameters {
    Map<String, Object> m_parameters;

    public ServiceParameters(Map<String, Object> parameters) {
        this.m_parameters = parameters;
    }

    public Map<String, Object> getParameters() {
        return this.m_parameters;
    }

    public String toString() {
        return "domain: " + this.getDomain() + ", " + "storeByNodeID: " + this.getStoreByNodeID() + ", " + "storeByIfAlias: " + this.getStoreByIfAlias() + ", " + "storFlagOverride: " + this.getStorFlagOverride() + ", " + "ifAliasComment: " + this.getIfAliasComment();
    }

    public String getDomain() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"domain", (String)"default");
    }

    public String getStoreByNodeID() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"storeByNodeID", (String)"normal");
    }

    public String getStoreByIfAlias() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"storeByIfAlias", (String)"false");
    }

    public String getStorFlagOverride() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"storFlagOverride", (String)"false");
    }

    public String getIfAliasComment() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"ifAliasComment", null);
    }

    public boolean aliasesEnabled() {
        return this.getStoreByIfAlias().equals("true");
    }

    public boolean overrideStorageFlag() {
        return !this.getStorFlagOverride().equals("false");
    }

    public void logIfAliasConfig() {
        this.log().info(this.toString());
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public boolean forceStoreByAlias(String alias) {
        if (alias == null || alias.equals("")) {
            return false;
        }
        String comment = this.getIfAliasComment();
        int si = -1;
        if (comment != null && !comment.equals("")) {
            si = alias.indexOf(comment);
        }
        if (si == 0) {
            return false;
        }
        return this.overrideStorageFlag();
    }

    public String getCollectionName() {
        if (this.getParameters().containsKey("collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)"collection", (String)"default");
        }
        if (this.getParameters().containsKey("http-collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)"http-collection", (String)"default");
        }
        if (this.getParameters().containsKey("nsclient-collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)"nsclient-collection", (String)"default");
        }
        if (this.m_parameters.containsKey("wmi-collection")) {
            return ParameterMap.getKeyedString(this.getParameters(), (String)"wmi-collection", (String)"default");
        }
        return "default";
    }

    public int getSnmpPort(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"port", (int)current);
    }

    public int getSnmpRetries(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"retry", (int)current);
    }

    public int getSnmpTimeout(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"timeout", (int)current);
    }

    public String getSnmpReadCommunity(String current) {
        String readCommunity = ParameterMap.getKeyedString(this.getParameters(), (String)"read-community", null);
        if (readCommunity == null) {
            readCommunity = ParameterMap.getKeyedString(this.m_parameters, (String)"readCommunity", (String)current);
        }
        return readCommunity;
    }

    public String getSnmpWriteCommunity(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"write-community", (String)current);
    }

    public InetAddress getSnmpProxyFor(InetAddress current) {
        String address = ParameterMap.getKeyedString(this.getParameters(), (String)"proxy-host", null);
        InetAddress addr = null;
        if (address != null && (addr = InetAddressUtils.addr((String)address)) == null) {
            this.log().error("determineProxyHost: Problem converting proxy host string to InetAddress");
        }
        return addr == null ? current : addr;
    }

    public int getSnmpVersion(int current) {
        String version = ParameterMap.getKeyedString(this.getParameters(), (String)"version", null);
        if (version != null) {
            if (version.equals("v1")) {
                return 1;
            }
            if (version.equals("v2c")) {
                return 2;
            }
            if (version.equals("v3")) {
                return 3;
            }
        }
        return current;
    }

    public int getSnmpMaxVarsPerPdu(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"max-vars-per-pdu", (int)current);
    }

    public int getSnmpMaxRepetitions(int current) {
        int maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, (String)"max-repetitions", (int)-1);
        if (maxRepetitions == -1) {
            maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, (String)"maxRepetitions", (int)current);
        }
        return maxRepetitions;
    }

    public int getSnmpMaxRequestSize(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"max-request-size", (int)current);
    }

    public String getSnmpSecurityName(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"security-name", (String)current);
    }

    public String getSnmpAuthPassPhrase(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"auth-passphrase", (String)current);
    }

    public String getSnmpAuthProtocol(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"auth-protocol", (String)current);
    }

    public String getSnmpPrivPassPhrase(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"privacy-passphrase", (String)current);
    }

    public String getSnmpPrivProtocol(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"privacy-protocol", (String)current);
    }
}

