/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.netmgt.config.MergeableDefinition;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;

public class SnmpConfigManager {
    private SnmpConfig m_config;
    private List<MergeableDefinition> m_definitions = new ArrayList<MergeableDefinition>();

    public SnmpConfigManager(SnmpConfig config) {
        this.m_config = config;
        for (Definition def : this.m_config.getDefinitionCollection()) {
            this.m_definitions.add(new MergeableDefinition(def));
        }
    }

    public SnmpConfig getConfig() {
        return this.m_config;
    }

    private List<MergeableDefinition> getDefinitions() {
        return this.m_definitions;
    }

    private void addDefinition(MergeableDefinition def) {
        this.m_definitions.add(def);
        this.getConfig().addDefinition(def.getConfigDef());
    }

    private void removeEmptyDefinitions() {
        Iterator<MergeableDefinition> iter = this.getDefinitions().iterator();
        while (iter.hasNext()) {
            MergeableDefinition def = iter.next();
            if (!def.isEmpty()) continue;
            this.getConfig().removeDefinition(def.getConfigDef());
            iter.remove();
        }
    }

    public void mergeIntoConfig(Definition eventDef) {
        MergeableDefinition eventDefinition = new MergeableDefinition(eventDef);
        this.purgeRangesFromDefinitions(eventDefinition);
        if (eventDefinition.isTrivial()) {
            return;
        }
        MergeableDefinition matchingDef = this.findMatchingDefinition(eventDefinition);
        if (matchingDef == null) {
            this.addDefinition(eventDefinition);
        } else {
            matchingDef.mergeMatchingAttributeDef(eventDefinition);
        }
    }

    private void purgeRangesFromDefinitions(MergeableDefinition eventDefinition) {
        this.purgeOtherDefs(null, eventDefinition);
    }

    MergeableDefinition findDefMatchingAttributes(Definition eventDef) {
        MergeableDefinition newDef = new MergeableDefinition(eventDef);
        return this.findMatchingDefinition(newDef);
    }

    private MergeableDefinition findMatchingDefinition(MergeableDefinition def) {
        for (MergeableDefinition d : this.getDefinitions()) {
            if (!d.matches(def)) continue;
            return d;
        }
        return null;
    }

    private void purgeOtherDefs(MergeableDefinition updatedDef, MergeableDefinition eventDefinition) {
        for (MergeableDefinition def : this.getDefinitions()) {
            if (updatedDef != null && def.getConfigDef() == updatedDef.getConfigDef()) continue;
            def.removeRanges(eventDefinition);
        }
        this.removeEmptyDefinitions();
    }

    public void optimizeAllDefs() {
        Definition[] defs = this.getConfig().getDefinition();
        for (int i = 0; i < defs.length; ++i) {
            MergeableDefinition definition = new MergeableDefinition(defs[i]);
            if (definition.getConfigDef().getSpecificCount() > 0) {
                definition.optimizeSpecifics();
            }
            if (definition.getConfigDef().getRangeCount() <= 1) continue;
            definition.optimizeRanges();
        }
        this.getConfig().setDefinition(defs);
    }
}

