/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.opennms.protocols.icmp6.ICMPv6EchoReply;
import org.opennms.protocols.icmp6.ICMPv6EchoRequest;
import org.opennms.protocols.icmp6.ICMPv6Packet;
import org.opennms.protocols.icmp6.ICMPv6Socket;

public class TestInitialization {
    public static void main(String[] args) {
        try {
            final ICMPv6Socket socket = new ICMPv6Socket();
            Runnable r = new Runnable(){

                public void run() {
                    System.err.println("Starting receiver");
                    while (true) {
                        try {
                            while (true) {
                                this.processReply(socket);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(1);
                            continue;
                        }
                        break;
                    }
                }

                private void processReply(ICMPv6Socket socket2) throws IOException {
                    DatagramPacket responsePacket = socket2.receive();
                    ICMPv6Packet icmpPacket = new ICMPv6Packet(responsePacket.getData(), responsePacket.getOffset(), responsePacket.getLength());
                    if (icmpPacket.getType() == ICMPv6Packet.Type.EchoReply) {
                        ICMPv6EchoReply reply = new ICMPv6EchoReply(icmpPacket);
                        double rtt = (double)reply.getRoundTripTime() / 1000.0;
                        String host = responsePacket.getAddress().getHostAddress();
                        System.err.printf("%d bytes from %s, icmp_seq=%d time=%f\n", responsePacket.getLength(), host, reply.getSequenceNumber(), rtt);
                    }
                }
            };
            Thread receiver = new Thread(r);
            receiver.start();
            int id = (int)(Math.random() * 32767.0);
            long threadId = (long)(Math.random() * 2.147483647E9);
            for (int seqNum = 0; seqNum < 10; ++seqNum) {
                ICMPv6EchoRequest request = new ICMPv6EchoRequest(id, seqNum, threadId);
                byte[] bytes = request.toBytes();
                DatagramPacket packet = new DatagramPacket(bytes, 0, bytes.length, InetAddress.getByName("::1"), 0);
                socket.send(packet);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

