/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.opennms.netmgt.model.discovery.IPAddressRange;

public class IPAddressRangeSet
implements Iterable<IPAddressRange> {
    List<IPAddressRange> m_ranges = new LinkedList<IPAddressRange>();

    public void add(IPAddressRange range) {
        IPAddressRange working = range;
        ListIterator<IPAddressRange> it = this.m_ranges.listIterator();
        while (it.hasNext()) {
            IPAddressRange r = it.next();
            if (working.comesBefore(r) && !working.adjoins(r)) {
                it.previous();
                it.add(working);
                return;
            }
            if (!working.combinable(r)) continue;
            working = working.combine(r);
            it.remove();
        }
        this.m_ranges.add(working);
    }

    public void remove(IPAddressRange range) {
        ListIterator<IPAddressRange> it = this.m_ranges.listIterator();
        while (it.hasNext()) {
            IPAddressRange r = it.next();
            IPAddressRange[] remaining = r.remove(range);
            if (remaining.length == 0) {
                it.remove();
                continue;
            }
            if (remaining.length == 1) {
                it.set(remaining[0]);
                continue;
            }
            if (remaining.length != 2) continue;
            it.set(remaining[0]);
            it.add(remaining[1]);
        }
    }

    public IPAddressRange[] toArray() {
        return this.m_ranges.toArray(new IPAddressRange[this.m_ranges.size()]);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (IPAddressRange r : this) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(r);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Iterator<IPAddressRange> iterator() {
        return Collections.unmodifiableList(this.m_ranges).iterator();
    }

    public void addAll(IPAddressRangeSet ranges) {
        for (IPAddressRange r : ranges) {
            this.add(r);
        }
    }

    public void removeAll(IPAddressRangeSet ranges) {
        for (IPAddressRange r : ranges) {
            this.remove(r);
        }
    }
}

