/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;

public class IPAddress
implements Comparable<IPAddress> {
    final byte[] m_ipAddr;

    public IPAddress(IPAddress addr) {
        this.m_ipAddr = addr.m_ipAddr;
    }

    public IPAddress(String dottedNotation) {
        this.m_ipAddr = InetAddressUtils.toIpAddrBytes((String)dottedNotation);
    }

    public IPAddress(InetAddress inetAddress) {
        this.m_ipAddr = inetAddress.getAddress();
    }

    public IPAddress(byte[] ipAddrOctets) {
        this.m_ipAddr = ipAddrOctets;
    }

    public InetAddress toInetAddress() {
        return InetAddressUtils.getInetAddress((byte[])this.m_ipAddr);
    }

    public byte[] toOctets() {
        return this.m_ipAddr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPAddress) {
            return Arrays.equals(this.m_ipAddr, ((IPAddress)obj).toOctets());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_ipAddr);
    }

    @Override
    public int compareTo(IPAddress o) {
        return new ByteArrayComparator().compare(this.m_ipAddr, o.toOctets());
    }

    public String toUserString() {
        return this.toInetAddress().getHostAddress().replaceFirst("(^|:)(0:)+", "::");
    }

    public String toString() {
        return this.toUserString();
    }

    public String toDbString() {
        return InetAddressUtils.toIpAddrString((byte[])this.m_ipAddr);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.m_ipAddr);
    }

    public IPAddress incr() {
        byte[] b = new byte[this.m_ipAddr.length];
        int carry = 1;
        for (int i = this.m_ipAddr.length - 1; i >= 0; --i) {
            b[i] = (byte)(this.m_ipAddr[i] + carry);
            carry = b[i] == 0 ? carry : 0;
        }
        if (carry > 0) {
            throw new IllegalStateException("you have tried to increment the max ip address");
        }
        return new IPAddress(b);
    }

    public IPAddress decr() {
        byte[] b = new byte[this.m_ipAddr.length];
        int borrow = 1;
        for (int i = this.m_ipAddr.length - 1; i >= 0; --i) {
            b[i] = (byte)(this.m_ipAddr[i] - borrow);
            borrow = b[i] == -1 ? borrow : 0;
        }
        if (borrow > 0) {
            throw new IllegalStateException("you have tried to decrement the '0' ip address");
        }
        return new IPAddress(b);
    }

    public boolean isPredecessorOf(IPAddress other) {
        return other.decr().equals(this);
    }

    public boolean isSuccessorOf(IPAddress other) {
        return other.incr().equals(this);
    }

    public boolean isLessThan(IPAddress other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(IPAddress other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(IPAddress other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(IPAddress other) {
        return this.compareTo(other) >= 0;
    }

    public static IPAddress min(IPAddress a, IPAddress b) {
        return a.isLessThan(b) ? a : b;
    }

    public static IPAddress max(IPAddress a, IPAddress b) {
        return a.isGreaterThan(b) ? a : b;
    }
}

