/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="vlan")
@Entity
@Table(name="vlan", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "vlanId"})})
public class OnmsVlan {
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_vlanId;
    private String m_vlanName;
    private Integer m_vlanType = -1;
    private Integer m_vlanStatus = -1;
    private Character m_status;
    private Date m_lastPollTime;

    public OnmsVlan() {
    }

    public OnmsVlan(int index, String name, int status, int type) {
        this.m_vlanId = index;
        this.m_vlanName = name;
        this.m_vlanStatus = status;
        this.m_vlanType = type;
    }

    public OnmsVlan(int index, String name, int status) {
        this.m_vlanId = index;
        this.m_vlanName = name;
        this.m_vlanStatus = status;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Integer getVlanId() {
        return this.m_vlanId;
    }

    public void setVlanId(Integer vlanId) {
        this.m_vlanId = vlanId;
    }

    @XmlAttribute(name="name")
    @Column(nullable=false)
    public String getVlanName() {
        return this.m_vlanName;
    }

    public void setVlanName(String vlanName) {
        this.m_vlanName = vlanName;
    }

    @XmlAttribute(name="type")
    @Column
    public Integer getVlanType() {
        return this.m_vlanType;
    }

    public void setVlanType(Integer vlanType) {
        this.m_vlanType = vlanType;
    }

    @XmlAttribute
    @Column
    public Integer getVlanStatus() {
        return this.m_vlanStatus;
    }

    public void setVlanStatus(Integer vlanStatus) {
        this.m_vlanStatus = vlanStatus;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Character getStatus() {
        return this.m_status;
    }

    public void setStatus(Character status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("dbId", (Object)this.m_id).append("node", (Object)this.m_node).append("id", (Object)this.m_vlanId).append("name", (Object)this.m_vlanName).append("type", (Object)this.m_vlanType).append("status", (Object)this.m_vlanStatus).append("dbStatus", (Object)this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }
}

