/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.util.Assert;

public class SnmpRowResult
implements Comparable<SnmpRowResult> {
    private final Map<SnmpObjId, SnmpResult> m_results = new TreeMap<SnmpObjId, SnmpResult>();
    private SnmpInstId m_instance;
    private int m_columnCount;

    public SnmpRowResult(int columnCount, SnmpInstId instance) {
        this.m_instance = instance;
        this.m_columnCount = columnCount;
    }

    public boolean isComplete(SnmpObjId ... ignoreColumns) {
        if (this.m_results.size() == this.m_columnCount) {
            return true;
        }
        if (this.m_results.size() > 0 && ignoreColumns.length > 0) {
            int total = this.m_results.size();
            for (SnmpObjId col : ignoreColumns) {
                if (this.m_results.containsKey(col)) continue;
                ++total;
            }
            return total == this.m_columnCount;
        }
        return false;
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public List<SnmpResult> getResults() {
        return new ArrayList<SnmpResult>(this.m_results.values());
    }

    public void addResult(SnmpObjId column, SnmpResult result) {
        Assert.isTrue((boolean)this.m_instance.equals(result.getInstance()), (String)("unexpected result " + result + " passed to row with instance " + this.m_instance));
        this.m_results.put(column, result);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("columnCount", this.m_columnCount).append("results", this.m_results).toString();
    }

    @Override
    public int compareTo(SnmpRowResult other) {
        return new CompareToBuilder().append(this.getResults(), other.getResults()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpRowResult) {
            SnmpRowResult other = (SnmpRowResult)obj;
            return new EqualsBuilder().append(this.getResults(), other.getResults()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getResults()).toHashCode();
    }

    public SnmpInstId getInstance() {
        return this.m_instance;
    }

    public SnmpValue getValue(SnmpObjId base) {
        for (SnmpResult result : this.getResults()) {
            if (!base.equals(result.getBase())) continue;
            return result.getValue();
        }
        return null;
    }
}

