/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.syslogd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.syslogd.Configuration;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.xml.sax.ContentHandler;

public class SyslogdConfiguration
implements Serializable {
    private Configuration _configuration;
    private UeiList _ueiList;
    private HideMessage _hideMessage;
    private List<String> _importFileList = new ArrayList<String>();

    public void addImportFile(String vImportFile) throws IndexOutOfBoundsException {
        this._importFileList.add(vImportFile);
    }

    public void addImportFile(int index, String vImportFile) throws IndexOutOfBoundsException {
        this._importFileList.add(index, vImportFile);
    }

    public Enumeration<String> enumerateImportFile() {
        return Collections.enumeration(this._importFileList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SyslogdConfiguration) {
            SyslogdConfiguration temp = (SyslogdConfiguration)obj;
            if (this._configuration != null) {
                if (temp._configuration == null) {
                    return false;
                }
                if (!this._configuration.equals(temp._configuration)) {
                    return false;
                }
            } else if (temp._configuration != null) {
                return false;
            }
            if (this._ueiList != null) {
                if (temp._ueiList == null) {
                    return false;
                }
                if (!this._ueiList.equals(temp._ueiList)) {
                    return false;
                }
            } else if (temp._ueiList != null) {
                return false;
            }
            if (this._hideMessage != null) {
                if (temp._hideMessage == null) {
                    return false;
                }
                if (!this._hideMessage.equals(temp._hideMessage)) {
                    return false;
                }
            } else if (temp._hideMessage != null) {
                return false;
            }
            if (this._importFileList != null) {
                if (temp._importFileList == null) {
                    return false;
                }
                if (!((Object)this._importFileList).equals(temp._importFileList)) {
                    return false;
                }
            } else if (temp._importFileList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public HideMessage getHideMessage() {
        return this._hideMessage;
    }

    public String getImportFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._importFileList.size()) {
            throw new IndexOutOfBoundsException("getImportFile: Index value '" + index + "' not in range [0.." + (this._importFileList.size() - 1) + "]");
        }
        return this._importFileList.get(index);
    }

    public String[] getImportFile() {
        String[] array = new String[]{};
        return this._importFileList.toArray(array);
    }

    public List<String> getImportFileCollection() {
        return this._importFileList;
    }

    public int getImportFileCount() {
        return this._importFileList.size();
    }

    public UeiList getUeiList() {
        return this._ueiList;
    }

    public int hashCode() {
        int result = 17;
        if (this._configuration != null) {
            result = 37 * result + this._configuration.hashCode();
        }
        if (this._ueiList != null) {
            result = 37 * result + this._ueiList.hashCode();
        }
        if (this._hideMessage != null) {
            result = 37 * result + this._hideMessage.hashCode();
        }
        if (this._importFileList != null) {
            result = 37 * result + ((Object)this._importFileList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateImportFile() {
        return this._importFileList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllImportFile() {
        this._importFileList.clear();
    }

    public boolean removeImportFile(String vImportFile) {
        boolean removed = this._importFileList.remove(vImportFile);
        return removed;
    }

    public String removeImportFileAt(int index) {
        String obj = this._importFileList.remove(index);
        return obj;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    public void setHideMessage(HideMessage hideMessage) {
        this._hideMessage = hideMessage;
    }

    public void setImportFile(int index, String vImportFile) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._importFileList.size()) {
            throw new IndexOutOfBoundsException("setImportFile: Index value '" + index + "' not in range [0.." + (this._importFileList.size() - 1) + "]");
        }
        this._importFileList.set(index, vImportFile);
    }

    public void setImportFile(String[] vImportFileArray) {
        this._importFileList.clear();
        for (int i = 0; i < vImportFileArray.length; ++i) {
            this._importFileList.add(vImportFileArray[i]);
        }
    }

    public void setImportFile(List<String> vImportFileList) {
        this._importFileList.clear();
        this._importFileList.addAll(vImportFileList);
    }

    public void setImportFileCollection(List<String> importFileList) {
        this._importFileList = importFileList;
    }

    public void setUeiList(UeiList ueiList) {
        this._ueiList = ueiList;
    }

    public static SyslogdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SyslogdConfiguration)Unmarshaller.unmarshal(SyslogdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

