/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Range;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Definition
extends Configuration
implements Serializable {
    private static final long serialVersionUID = 6077248084936410239L;
    private static final Range[] EMPTY_RANGE = new Range[0];
    private static final String[] EMPTY_IP_MATCH = new String[0];
    @XmlElement(name="range")
    private List<Range> _rangeList = new ArrayList<Range>();
    @XmlElement(name="specific")
    private List<String> _specificList = new ArrayList<String>();
    @XmlElement(name="ip-match")
    private List<String> _ipMatchList = new ArrayList<String>();

    public void addIpMatch(String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(vIpMatch);
    }

    public void addIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(index, vIpMatch);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public Enumeration<String> enumerateIpMatch() {
        return Collections.enumeration(this._ipMatchList);
    }

    public Enumeration<Range> enumerateRange() {
        return Collections.enumeration(this._rangeList);
    }

    public Enumeration<String> enumerateSpecific() {
        return Collections.enumeration(this._specificList);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Definition temp = (Definition)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getRangeCollection(), temp.getRangeCollection()).append(this.getSpecificCollection(), temp.getSpecificCollection()).append(this.getIpMatchCollection(), temp.getIpMatchCollection()).isEquals();
    }

    public String getIpMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("getIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        return this._ipMatchList.get(index);
    }

    public String[] getIpMatch() {
        return this._ipMatchList.toArray(EMPTY_IP_MATCH);
    }

    public List<String> getIpMatchCollection() {
        return this._ipMatchList;
    }

    public int getIpMatchCount() {
        return this._ipMatchList.size();
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("getRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        return this._rangeList.get(index);
    }

    public Range[] getRange() {
        return this._rangeList.toArray(EMPTY_RANGE);
    }

    public List<Range> getRangeCollection() {
        return this._rangeList;
    }

    public int getRangeCount() {
        return this._rangeList.size();
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        return this._specificList.get(index);
    }

    public String[] getSpecific() {
        return this._specificList.toArray(EMPTY_IP_MATCH);
    }

    public List<String> getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this._rangeList != null) {
            result = 37 * result + ((Object)this._rangeList).hashCode();
        }
        if (this._specificList != null) {
            result = 37 * result + ((Object)this._specificList).hashCode();
        }
        if (this._ipMatchList != null) {
            result = 37 * result + ((Object)this._ipMatchList).hashCode();
        }
        return result;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateIpMatch() {
        return this._ipMatchList.iterator();
    }

    public Iterator<Range> iterateRange() {
        return this._rangeList.iterator();
    }

    public Iterator<String> iterateSpecific() {
        return this._specificList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIpMatch() {
        this._ipMatchList.clear();
    }

    public void removeAllRange() {
        this._rangeList.clear();
    }

    public void removeAllSpecific() {
        this._specificList.clear();
    }

    public boolean removeIpMatch(String vIpMatch) {
        return this._ipMatchList.remove(vIpMatch);
    }

    public String removeIpMatchAt(int index) {
        return this._ipMatchList.remove(index);
    }

    public boolean removeRange(Range vRange) {
        return this._rangeList.remove(vRange);
    }

    public Range removeRangeAt(int index) {
        return this._rangeList.remove(index);
    }

    public boolean removeSpecific(String vSpecific) {
        return this._specificList.remove(vSpecific);
    }

    public String removeSpecificAt(int index) {
        return this._specificList.remove(index);
    }

    public void setIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("setIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        this._ipMatchList.set(index, vIpMatch);
    }

    public void setIpMatch(String[] vIpMatchArray) {
        this._ipMatchList.clear();
        for (int i = 0; i < vIpMatchArray.length; ++i) {
            this._ipMatchList.add(vIpMatchArray[i]);
        }
    }

    public void setIpMatch(List<String> vIpMatchList) {
        this._ipMatchList.clear();
        this._ipMatchList.addAll(vIpMatchList);
    }

    public void setIpMatchCollection(List<String> ipMatchList) {
        this._ipMatchList = ipMatchList;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("setRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] vRangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < vRangeArray.length; ++i) {
            this._rangeList.add(vRangeArray[i]);
        }
    }

    public void setRange(List<Range> vRangeList) {
        this._rangeList.clear();
        this._rangeList.addAll(vRangeList);
    }

    public void setRangeCollection(List<Range> rangeList) {
        this._rangeList = rangeList;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] vSpecificArray) {
        this._specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this._specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<String> vSpecificList) {
        this._specificList.clear();
        this._specificList.addAll(vSpecificList);
    }

    public void setSpecificCollection(List<String> specificList) {
        this._specificList = specificList;
    }

    public static Configuration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Configuration)Unmarshaller.unmarshal(Definition.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("ranges", this.getRangeCollection()).append("specifics", this.getSpecificCollection()).append("ip-matches", this.getIpMatchCollection()).toString();
    }
}

