/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.NodeOutage;
import org.opennms.netmgt.config.poller.Package;
import org.xml.sax.ContentHandler;

public class PollerConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private String _nextOutageId = "SELECT nextval('outageNxtId')";
    private String _serviceUnresponsiveEnabled;
    private String _xmlrpc = "false";
    private String _pathOutageEnabled = "false";
    private NodeOutage _nodeOutage;
    private List<Package> _packageList;
    private List<Monitor> _monitorList;

    public PollerConfiguration() {
        this.setNextOutageId("SELECT nextval('outageNxtId')");
        this.setXmlrpc("false");
        this.setPathOutageEnabled("false");
        this._packageList = new ArrayList<Package>();
        this._monitorList = new ArrayList<Monitor>();
    }

    public void addMonitor(Monitor vMonitor) throws IndexOutOfBoundsException {
        this._monitorList.add(vMonitor);
    }

    public void addMonitor(int index, Monitor vMonitor) throws IndexOutOfBoundsException {
        this._monitorList.add(index, vMonitor);
    }

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public Enumeration<Monitor> enumerateMonitor() {
        return Collections.enumeration(this._monitorList);
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PollerConfiguration) {
            PollerConfiguration temp = (PollerConfiguration)obj;
            if (this._threads != temp._threads) {
                return false;
            }
            if (this._has_threads != temp._has_threads) {
                return false;
            }
            if (this._nextOutageId != null) {
                if (temp._nextOutageId == null) {
                    return false;
                }
                if (!this._nextOutageId.equals(temp._nextOutageId)) {
                    return false;
                }
            } else if (temp._nextOutageId != null) {
                return false;
            }
            if (this._serviceUnresponsiveEnabled != null) {
                if (temp._serviceUnresponsiveEnabled == null) {
                    return false;
                }
                if (!this._serviceUnresponsiveEnabled.equals(temp._serviceUnresponsiveEnabled)) {
                    return false;
                }
            } else if (temp._serviceUnresponsiveEnabled != null) {
                return false;
            }
            if (this._xmlrpc != null) {
                if (temp._xmlrpc == null) {
                    return false;
                }
                if (!this._xmlrpc.equals(temp._xmlrpc)) {
                    return false;
                }
            } else if (temp._xmlrpc != null) {
                return false;
            }
            if (this._pathOutageEnabled != null) {
                if (temp._pathOutageEnabled == null) {
                    return false;
                }
                if (!this._pathOutageEnabled.equals(temp._pathOutageEnabled)) {
                    return false;
                }
            } else if (temp._pathOutageEnabled != null) {
                return false;
            }
            if (this._nodeOutage != null) {
                if (temp._nodeOutage == null) {
                    return false;
                }
                if (!this._nodeOutage.equals(temp._nodeOutage)) {
                    return false;
                }
            } else if (temp._nodeOutage != null) {
                return false;
            }
            if (this._packageList != null) {
                if (temp._packageList == null) {
                    return false;
                }
                if (!((Object)this._packageList).equals(temp._packageList)) {
                    return false;
                }
            } else if (temp._packageList != null) {
                return false;
            }
            if (this._monitorList != null) {
                if (temp._monitorList == null) {
                    return false;
                }
                if (!((Object)this._monitorList).equals(temp._monitorList)) {
                    return false;
                }
            } else if (temp._monitorList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Monitor getMonitor(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._monitorList.size()) {
            throw new IndexOutOfBoundsException("getMonitor: Index value '" + index + "' not in range [0.." + (this._monitorList.size() - 1) + "]");
        }
        return this._monitorList.get(index);
    }

    public Monitor[] getMonitor() {
        Monitor[] array = new Monitor[]{};
        return this._monitorList.toArray(array);
    }

    public List<Monitor> getMonitorCollection() {
        return this._monitorList;
    }

    public int getMonitorCount() {
        return this._monitorList.size();
    }

    public String getNextOutageId() {
        return this._nextOutageId;
    }

    public NodeOutage getNodeOutage() {
        return this._nodeOutage;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public String getPathOutageEnabled() {
        return this._pathOutageEnabled;
    }

    public String getServiceUnresponsiveEnabled() {
        return this._serviceUnresponsiveEnabled;
    }

    public int getThreads() {
        return this._threads;
    }

    public String getXmlrpc() {
        return this._xmlrpc;
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this._threads;
        if (this._nextOutageId != null) {
            result = 37 * result + this._nextOutageId.hashCode();
        }
        if (this._serviceUnresponsiveEnabled != null) {
            result = 37 * result + this._serviceUnresponsiveEnabled.hashCode();
        }
        if (this._xmlrpc != null) {
            result = 37 * result + this._xmlrpc.hashCode();
        }
        if (this._pathOutageEnabled != null) {
            result = 37 * result + this._pathOutageEnabled.hashCode();
        }
        if (this._nodeOutage != null) {
            result = 37 * result + this._nodeOutage.hashCode();
        }
        if (this._packageList != null) {
            result = 37 * result + ((Object)this._packageList).hashCode();
        }
        if (this._monitorList != null) {
            result = 37 * result + ((Object)this._monitorList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Monitor> iterateMonitor() {
        return this._monitorList.iterator();
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMonitor() {
        this._monitorList.clear();
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public boolean removeMonitor(Monitor vMonitor) {
        boolean removed = this._monitorList.remove(vMonitor);
        return removed;
    }

    public Monitor removeMonitorAt(int index) {
        Monitor obj = this._monitorList.remove(index);
        return obj;
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public void setMonitor(int index, Monitor vMonitor) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._monitorList.size()) {
            throw new IndexOutOfBoundsException("setMonitor: Index value '" + index + "' not in range [0.." + (this._monitorList.size() - 1) + "]");
        }
        this._monitorList.set(index, vMonitor);
    }

    public void setMonitor(Monitor[] vMonitorArray) {
        this._monitorList.clear();
        for (int i = 0; i < vMonitorArray.length; ++i) {
            this._monitorList.add(vMonitorArray[i]);
        }
    }

    public void setMonitor(List<Monitor> vMonitorList) {
        this._monitorList.clear();
        this._monitorList.addAll(vMonitorList);
    }

    public void setMonitorCollection(List<Monitor> monitorList) {
        this._monitorList = monitorList;
    }

    public void setNextOutageId(String nextOutageId) {
        this._nextOutageId = nextOutageId;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this._nodeOutage = nodeOutage;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public void setPathOutageEnabled(String pathOutageEnabled) {
        this._pathOutageEnabled = pathOutageEnabled;
    }

    public void setServiceUnresponsiveEnabled(String serviceUnresponsiveEnabled) {
        this._serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public void setXmlrpc(String xmlrpc) {
        this._xmlrpc = xmlrpc;
    }

    public static PollerConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PollerConfiguration)Unmarshaller.unmarshal(PollerConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

