/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.poller.Parameter;
import org.xml.sax.ContentHandler;

public class Monitor
implements Serializable {
    private String _service;
    private String _className;
    private List<Parameter> _parameterList = new ArrayList<Parameter>();

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(index, vParameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this._parameterList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Monitor) {
            Monitor temp = (Monitor)obj;
            if (this._service != null) {
                if (temp._service == null) {
                    return false;
                }
                if (!this._service.equals(temp._service)) {
                    return false;
                }
            } else if (temp._service != null) {
                return false;
            }
            if (this._className != null) {
                if (temp._className == null) {
                    return false;
                }
                if (!this._className.equals(temp._className)) {
                    return false;
                }
            } else if (temp._className != null) {
                return false;
            }
            if (this._parameterList != null) {
                if (temp._parameterList == null) {
                    return false;
                }
                if (!((Object)this._parameterList).equals(temp._parameterList)) {
                    return false;
                }
            } else if (temp._parameterList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this._className;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        return this._parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this._parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this._parameterList;
    }

    public int getParameterCount() {
        return this._parameterList.size();
    }

    public String getService() {
        return this._service;
    }

    public int hashCode() {
        int result = 17;
        if (this._service != null) {
            result = 37 * result + this._service.hashCode();
        }
        if (this._className != null) {
            result = 37 * result + this._className.hashCode();
        }
        if (this._parameterList != null) {
            result = 37 * result + ((Object)this._parameterList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Parameter> iterateParameter() {
        return this._parameterList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParameter() {
        this._parameterList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this._parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this._parameterList.remove(index);
        return obj;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        this._parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this._parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this._parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this._parameterList.clear();
        this._parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this._parameterList = parameterList;
    }

    public void setService(String service) {
        this._service = service;
    }

    public static Monitor unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Monitor)Unmarshaller.unmarshal(Monitor.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

