/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.Rrd;
import org.opennms.netmgt.config.datacollection.Systems;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="snmp-collection", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"rrd", "includeCollection", "resourceType", "groups", "systems"})
@ValidateUsing(value="datacollection-config.xsd")
public class SnmpCollection
implements Serializable {
    private static final long serialVersionUID = 2466351093869349285L;
    private static final ResourceType[] EMPTY_RESOURCETYPE_ARRAY = new ResourceType[0];
    private static final IncludeCollection[] EMPTY_INCLUDECOLLECTION_ARRAY = new IncludeCollection[0];
    private String m_name;
    private Integer m_maxVarsPerPdu;
    private String m_snmpStorageFlag;
    private Rrd m_rrd;
    private List<IncludeCollection> m_includeCollections = new ArrayList<IncludeCollection>();
    private List<ResourceType> m_resourceTypes = new ArrayList<ResourceType>();
    private Groups m_groups;
    private Systems m_systems;

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.m_name;
    }

    @XmlAttribute(name="maxVarsPerPdu")
    public Integer getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    @XmlAttribute(name="snmpStorageFlag", required=true)
    public String getSnmpStorageFlag() {
        return this.m_snmpStorageFlag;
    }

    @XmlElement(name="rrd", required=true)
    public Rrd getRrd() {
        return this.m_rrd;
    }

    @XmlElement(name="include-collection")
    public IncludeCollection[] getIncludeCollection() {
        return this.m_includeCollections.toArray(EMPTY_INCLUDECOLLECTION_ARRAY);
    }

    @XmlElement(name="resourceType")
    public ResourceType[] getResourceType() {
        return this.m_resourceTypes.toArray(EMPTY_RESOURCETYPE_ARRAY);
    }

    @XmlElement(name="groups")
    public Groups getGroups() {
        return this.m_groups;
    }

    @XmlElement(name="systems")
    public Systems getSystems() {
        return this.m_systems;
    }

    public void addIncludeCollection(IncludeCollection includeCollection) throws IndexOutOfBoundsException {
        this.m_includeCollections.add(includeCollection);
    }

    public void addIncludeCollection(int index, IncludeCollection includeCollection) throws IndexOutOfBoundsException {
        this.m_includeCollections.add(index, includeCollection);
    }

    public void addResourceType(ResourceType resourceType) throws IndexOutOfBoundsException {
        this.m_resourceTypes.add(resourceType);
    }

    public void addResourceType(int index, ResourceType resourceType) throws IndexOutOfBoundsException {
        this.m_resourceTypes.add(index, resourceType);
    }

    public void deleteMaxVarsPerPdu() {
        this.m_maxVarsPerPdu = null;
    }

    public Enumeration<IncludeCollection> enumerateIncludeCollection() {
        return Collections.enumeration(this.m_includeCollections);
    }

    public Enumeration<ResourceType> enumerateResourceType() {
        return Collections.enumeration(this.m_resourceTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SnmpCollection) {
            SnmpCollection temp = (SnmpCollection)obj;
            return new EqualsBuilder().append((Object)this.m_name, (Object)temp.m_name).append((Object)this.m_maxVarsPerPdu, (Object)temp.m_maxVarsPerPdu).append((Object)this.m_snmpStorageFlag, (Object)temp.m_snmpStorageFlag).append((Object)this.m_rrd, (Object)temp.m_rrd).append(this.m_includeCollections, temp.m_includeCollections).append(this.m_resourceTypes, temp.m_resourceTypes).append((Object)this.m_groups, (Object)temp.m_groups).append((Object)this.m_systems, (Object)temp.m_systems).isEquals();
        }
        return false;
    }

    public IncludeCollection getIncludeCollection(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_includeCollections.size()) {
            throw new IndexOutOfBoundsException("getIncludeCollection: Index value '" + index + "' not in range [0.." + (this.m_includeCollections.size() - 1) + "]");
        }
        return this.m_includeCollections.get(index);
    }

    public List<IncludeCollection> getIncludeCollectionCollection() {
        return this.m_includeCollections;
    }

    public int getIncludeCollectionCount() {
        return this.m_includeCollections.size();
    }

    public ResourceType getResourceType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_resourceTypes.size()) {
            throw new IndexOutOfBoundsException("getResourceType: Index value '" + index + "' not in range [0.." + (this.m_resourceTypes.size() - 1) + "]");
        }
        return this.m_resourceTypes.get(index);
    }

    public List<ResourceType> getResourceTypeCollection() {
        return this.m_resourceTypes;
    }

    public int getResourceTypeCount() {
        return this.m_resourceTypes.size();
    }

    public boolean hasMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu != null;
    }

    public int hashCode() {
        int result = 17;
        if (this.m_name != null) {
            result = 37 * result + this.m_name.hashCode();
        }
        if (this.m_maxVarsPerPdu != null) {
            result = 37 * result + this.m_maxVarsPerPdu;
        }
        if (this.m_snmpStorageFlag != null) {
            result = 37 * result + this.m_snmpStorageFlag.hashCode();
        }
        if (this.m_rrd != null) {
            result = 37 * result + this.m_rrd.hashCode();
        }
        if (this.m_includeCollections != null) {
            result = 37 * result + ((Object)this.m_includeCollections).hashCode();
        }
        if (this.m_resourceTypes != null) {
            result = 37 * result + ((Object)this.m_resourceTypes).hashCode();
        }
        if (this.m_groups != null) {
            result = 37 * result + this.m_groups.hashCode();
        }
        if (this.m_systems != null) {
            result = 37 * result + this.m_systems.hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<IncludeCollection> iterateIncludeCollection() {
        return this.m_includeCollections.iterator();
    }

    public Iterator<ResourceType> iterateResourceType() {
        return this.m_resourceTypes.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIncludeCollection() {
        this.m_includeCollections.clear();
    }

    public void removeAllResourceType() {
        this.m_resourceTypes.clear();
    }

    public boolean removeIncludeCollection(IncludeCollection includeCollection) {
        return this.m_includeCollections.remove(includeCollection);
    }

    public IncludeCollection removeIncludeCollectionAt(int index) {
        return this.m_includeCollections.remove(index);
    }

    public boolean removeResourceType(ResourceType resourceType) {
        return this.m_resourceTypes.remove(resourceType);
    }

    public ResourceType removeResourceTypeAt(int index) {
        return this.m_resourceTypes.remove(index);
    }

    public void setGroups(Groups groups) {
        this.m_groups = groups;
    }

    public void setIncludeCollection(int index, IncludeCollection includeCollection) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_includeCollections.size()) {
            throw new IndexOutOfBoundsException("setIncludeCollection: Index value '" + index + "' not in range [0.." + (this.m_includeCollections.size() - 1) + "]");
        }
        this.m_includeCollections.set(index, includeCollection);
    }

    public void setIncludeCollection(IncludeCollection[] includeCollections) {
        this.m_includeCollections.clear();
        for (int i = 0; i < includeCollections.length; ++i) {
            this.m_includeCollections.add(includeCollections[i]);
        }
    }

    public void setIncludeCollection(List<IncludeCollection> includeCollections) {
        this.m_includeCollections.clear();
        this.m_includeCollections.addAll(includeCollections);
    }

    public void setIncludeCollectionCollection(List<IncludeCollection> includeCollections) {
        this.m_includeCollections = includeCollections;
    }

    public void setMaxVarsPerPdu(Integer maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    public void setResourceType(int index, ResourceType resourceType) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_resourceTypes.size()) {
            throw new IndexOutOfBoundsException("setResourceType: Index value '" + index + "' not in range [0.." + (this.m_resourceTypes.size() - 1) + "]");
        }
        this.m_resourceTypes.set(index, resourceType);
    }

    public void setResourceType(ResourceType[] resourceTypes) {
        this.m_resourceTypes.clear();
        for (int i = 0; i < resourceTypes.length; ++i) {
            this.m_resourceTypes.add(resourceTypes[i]);
        }
    }

    public void setResourceType(List<ResourceType> resourceTypes) {
        this.m_resourceTypes.clear();
        this.m_resourceTypes.addAll(resourceTypes);
    }

    public void setResourceTypeCollection(List<ResourceType> resourceTypes) {
        this.m_resourceTypes = resourceTypes;
    }

    public void setRrd(Rrd rrd) {
        this.m_rrd = rrd;
    }

    public void setSnmpStorageFlag(String snmpStorageFlag) {
        this.m_snmpStorageFlag = snmpStorageFlag.intern();
    }

    public void setSystems(Systems systems) {
        this.m_systems = systems;
    }

    @Deprecated
    public static SnmpCollection unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SnmpCollection)Unmarshaller.unmarshal(SnmpCollection.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

