/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.Group;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="groups", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"group"})
@ValidateUsing(value="datacollection-config.xsd")
public class Groups
implements Serializable {
    private static final long serialVersionUID = 4574413441179220427L;
    private static final Group[] EMPTY_GROUP_ARRAY = new Group[0];
    private List<Group> m_groups = new ArrayList<Group>();

    public void addGroup(Group group) throws IndexOutOfBoundsException {
        this.m_groups.add(group);
    }

    public void addGroup(int index, Group group) throws IndexOutOfBoundsException {
        this.m_groups.add(index, group);
    }

    public Enumeration<Group> enumerateGroup() {
        return Collections.enumeration(this.m_groups);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Groups) {
            Groups temp = (Groups)obj;
            if (this.m_groups != null) {
                if (temp.m_groups == null) {
                    return false;
                }
                if (!((Object)this.m_groups).equals(temp.m_groups)) {
                    return false;
                }
            } else if (temp.m_groups != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Group getGroup(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_groups.size()) {
            throw new IndexOutOfBoundsException("getGroup: Index value '" + index + "' not in range [0.." + (this.m_groups.size() - 1) + "]");
        }
        return this.m_groups.get(index);
    }

    @XmlElement(name="group")
    public Group[] getGroup() {
        return this.m_groups.toArray(EMPTY_GROUP_ARRAY);
    }

    public List<Group> getGroupCollection() {
        return this.m_groups;
    }

    public int getGroupCount() {
        return this.m_groups.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_groups != null) {
            result = 37 * result + ((Object)this.m_groups).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Group> iterateGroup() {
        return this.m_groups.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllGroup() {
        this.m_groups.clear();
    }

    public boolean removeGroup(Group group) {
        return this.m_groups.remove(group);
    }

    public Group removeGroupAt(int index) {
        return this.m_groups.remove(index);
    }

    public void setGroup(int index, Group group) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_groups.size()) {
            throw new IndexOutOfBoundsException("setGroup: Index value '" + index + "' not in range [0.." + (this.m_groups.size() - 1) + "]");
        }
        this.m_groups.set(index, group);
    }

    public void setGroup(Group[] groups) {
        this.m_groups.clear();
        for (int i = 0; i < groups.length; ++i) {
            this.m_groups.add(groups[i]);
        }
    }

    public void setGroup(List<Group> groups) {
        this.m_groups.clear();
        this.m_groups.addAll(groups);
    }

    public void setGroupCollection(List<Group> groups) {
        this.m_groups = groups;
    }

    @Deprecated
    public static Groups unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Groups)Unmarshaller.unmarshal(Groups.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

