/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="datacollection-group", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"name", "resourceType", "group", "systemDef"})
@ValidateUsing(value="datacollection-groups.xsd")
public class DatacollectionGroup
implements Serializable {
    private static final long serialVersionUID = 659689462266282039L;
    private static final SystemDef[] EMPTY_SYSTEMDEF_ARRAY = new SystemDef[0];
    private static final ResourceType[] EMPTY_RESOURCETYPE_ARRAY = new ResourceType[0];
    private static final Group[] EMPTY_GROUP_ARRAY = new Group[0];
    private String m_name;
    private List<ResourceType> m_resourceTypes = new ArrayList<ResourceType>();
    private List<Group> m_groups = new ArrayList<Group>();
    private List<SystemDef> m_systemDefs = new ArrayList<SystemDef>();

    public void addGroup(Group group) throws IndexOutOfBoundsException {
        this.m_groups.add(group);
    }

    public void addGroup(int index, Group group) throws IndexOutOfBoundsException {
        this.m_groups.add(index, group);
    }

    public void addResourceType(ResourceType resourceType) throws IndexOutOfBoundsException {
        this.m_resourceTypes.add(resourceType);
    }

    public void addResourceType(int index, ResourceType resourceType) throws IndexOutOfBoundsException {
        this.m_resourceTypes.add(index, resourceType);
    }

    public void addSystemDef(SystemDef systemDef) throws IndexOutOfBoundsException {
        this.m_systemDefs.add(systemDef);
    }

    public void addSystemDef(int index, SystemDef systemDef) throws IndexOutOfBoundsException {
        this.m_systemDefs.add(index, systemDef);
    }

    public Enumeration<Group> enumerateGroup() {
        return Collections.enumeration(this.m_groups);
    }

    public Enumeration<ResourceType> enumerateResourceType() {
        return Collections.enumeration(this.m_resourceTypes);
    }

    public Enumeration<SystemDef> enumerateSystemDef() {
        return Collections.enumeration(this.m_systemDefs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatacollectionGroup) {
            DatacollectionGroup temp = (DatacollectionGroup)obj;
            if (this.m_name != null) {
                if (temp.m_name == null) {
                    return false;
                }
                if (!this.m_name.equals(temp.m_name)) {
                    return false;
                }
            } else if (temp.m_name != null) {
                return false;
            }
            if (this.m_resourceTypes != null) {
                if (temp.m_resourceTypes == null) {
                    return false;
                }
                if (!((Object)this.m_resourceTypes).equals(temp.m_resourceTypes)) {
                    return false;
                }
            } else if (temp.m_resourceTypes != null) {
                return false;
            }
            if (this.m_groups != null) {
                if (temp.m_groups == null) {
                    return false;
                }
                if (!((Object)this.m_groups).equals(temp.m_groups)) {
                    return false;
                }
            } else if (temp.m_groups != null) {
                return false;
            }
            if (this.m_systemDefs != null) {
                if (temp.m_systemDefs == null) {
                    return false;
                }
                if (!((Object)this.m_systemDefs).equals(temp.m_systemDefs)) {
                    return false;
                }
            } else if (temp.m_systemDefs != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Group getGroup(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_groups.size()) {
            throw new IndexOutOfBoundsException("getGroup: Index value '" + index + "' not in range [0.." + (this.m_groups.size() - 1) + "]");
        }
        return this.m_groups.get(index);
    }

    @XmlElement(name="group")
    public Group[] getGroup() {
        return this.m_groups.toArray(EMPTY_GROUP_ARRAY);
    }

    public List<Group> getGroupCollection() {
        return this.m_groups;
    }

    public int getGroupCount() {
        return this.m_groups.size();
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.m_name;
    }

    public ResourceType getResourceType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_resourceTypes.size()) {
            throw new IndexOutOfBoundsException("getResourceType: Index value '" + index + "' not in range [0.." + (this.m_resourceTypes.size() - 1) + "]");
        }
        return this.m_resourceTypes.get(index);
    }

    @XmlElement(name="resourceType")
    public ResourceType[] getResourceType() {
        return this.m_resourceTypes.toArray(EMPTY_RESOURCETYPE_ARRAY);
    }

    public List<ResourceType> getResourceTypeCollection() {
        return this.m_resourceTypes;
    }

    public int getResourceTypeCount() {
        return this.m_resourceTypes.size();
    }

    public SystemDef getSystemDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_systemDefs.size()) {
            throw new IndexOutOfBoundsException("getSystemDef: Index value '" + index + "' not in range [0.." + (this.m_systemDefs.size() - 1) + "]");
        }
        return this.m_systemDefs.get(index);
    }

    @XmlElement(name="systemDef")
    public SystemDef[] getSystemDef() {
        return this.m_systemDefs.toArray(EMPTY_SYSTEMDEF_ARRAY);
    }

    public List<SystemDef> getSystemDefCollection() {
        return this.m_systemDefs;
    }

    public int getSystemDefCount() {
        return this.m_systemDefs.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_name != null) {
            result = 37 * result + this.m_name.hashCode();
        }
        if (this.m_resourceTypes != null) {
            result = 37 * result + ((Object)this.m_resourceTypes).hashCode();
        }
        if (this.m_groups != null) {
            result = 37 * result + ((Object)this.m_groups).hashCode();
        }
        if (this.m_systemDefs != null) {
            result = 37 * result + ((Object)this.m_systemDefs).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Group> iterateGroup() {
        return this.m_groups.iterator();
    }

    public Iterator<ResourceType> iterateResourceType() {
        return this.m_resourceTypes.iterator();
    }

    public Iterator<SystemDef> iterateSystemDef() {
        return this.m_systemDefs.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllGroup() {
        this.m_groups.clear();
    }

    public void removeAllResourceType() {
        this.m_resourceTypes.clear();
    }

    public void removeAllSystemDef() {
        this.m_systemDefs.clear();
    }

    public boolean removeGroup(Group group) {
        return this.m_groups.remove(group);
    }

    public Group removeGroupAt(int index) {
        return this.m_groups.remove(index);
    }

    public boolean removeResourceType(ResourceType resourceType) {
        return this.m_resourceTypes.remove(resourceType);
    }

    public ResourceType removeResourceTypeAt(int index) {
        return this.m_resourceTypes.remove(index);
    }

    public boolean removeSystemDef(SystemDef systemDef) {
        return this.m_systemDefs.remove(systemDef);
    }

    public SystemDef removeSystemDefAt(int index) {
        return this.m_systemDefs.remove(index);
    }

    public void setGroup(int index, Group group) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_groups.size()) {
            throw new IndexOutOfBoundsException("setGroup: Index value '" + index + "' not in range [0.." + (this.m_groups.size() - 1) + "]");
        }
        this.m_groups.set(index, group);
    }

    public void setGroup(Group[] groups) {
        this.m_groups.clear();
        for (int i = 0; i < groups.length; ++i) {
            this.m_groups.add(groups[i]);
        }
    }

    public void setGroup(List<Group> groups) {
        this.m_groups.clear();
        this.m_groups.addAll(groups);
    }

    public void setGroupCollection(List<Group> groups) {
        this.m_groups = groups;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    public void setResourceType(int index, ResourceType resourceType) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_resourceTypes.size()) {
            throw new IndexOutOfBoundsException("setResourceType: Index value '" + index + "' not in range [0.." + (this.m_resourceTypes.size() - 1) + "]");
        }
        this.m_resourceTypes.set(index, resourceType);
    }

    public void setResourceType(ResourceType[] resourceTypes) {
        this.m_resourceTypes.clear();
        for (int i = 0; i < resourceTypes.length; ++i) {
            this.m_resourceTypes.add(resourceTypes[i]);
        }
    }

    public void setResourceType(List<ResourceType> resourceTypes) {
        this.m_resourceTypes.clear();
        this.m_resourceTypes.addAll(resourceTypes);
    }

    public void setResourceTypeCollection(List<ResourceType> resourceTypes) {
        this.m_resourceTypes = resourceTypes;
    }

    public void setSystemDef(int index, SystemDef systemDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_systemDefs.size()) {
            throw new IndexOutOfBoundsException("setSystemDef: Index value '" + index + "' not in range [0.." + (this.m_systemDefs.size() - 1) + "]");
        }
        this.m_systemDefs.set(index, systemDef);
    }

    public void setSystemDef(SystemDef[] systemDefs) {
        this.m_systemDefs.clear();
        for (int i = 0; i < systemDefs.length; ++i) {
            this.m_systemDefs.add(systemDefs[i]);
        }
    }

    public void setSystemDef(List<SystemDef> systemDefs) {
        this.m_systemDefs.clear();
        this.m_systemDefs.addAll(systemDefs);
    }

    public void setSystemDefCollection(List<SystemDef> systemDefs) {
        this.m_systemDefs = systemDefs;
    }

    @Deprecated
    public static DatacollectionGroup unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DatacollectionGroup)Unmarshaller.unmarshal(DatacollectionGroup.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

