/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Package;
import org.xml.sax.ContentHandler;

public class CollectdConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private List<Package> _packageList = new ArrayList<Package>();
    private List<Collector> _collectorList = new ArrayList<Collector>();

    public void addCollector(Collector vCollector) throws IndexOutOfBoundsException {
        this._collectorList.add(vCollector);
    }

    public void addCollector(int index, Collector vCollector) throws IndexOutOfBoundsException {
        this._collectorList.add(index, vCollector);
    }

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public Enumeration<Collector> enumerateCollector() {
        return Collections.enumeration(this._collectorList);
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CollectdConfiguration) {
            CollectdConfiguration temp = (CollectdConfiguration)obj;
            if (this._threads != temp._threads) {
                return false;
            }
            if (this._has_threads != temp._has_threads) {
                return false;
            }
            if (this._packageList != null) {
                if (temp._packageList == null) {
                    return false;
                }
                if (!((Object)this._packageList).equals(temp._packageList)) {
                    return false;
                }
            } else if (temp._packageList != null) {
                return false;
            }
            if (this._collectorList != null) {
                if (temp._collectorList == null) {
                    return false;
                }
                if (!((Object)this._collectorList).equals(temp._collectorList)) {
                    return false;
                }
            } else if (temp._collectorList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Collector getCollector(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._collectorList.size()) {
            throw new IndexOutOfBoundsException("getCollector: Index value '" + index + "' not in range [0.." + (this._collectorList.size() - 1) + "]");
        }
        return this._collectorList.get(index);
    }

    public Collector[] getCollector() {
        Collector[] array = new Collector[]{};
        return this._collectorList.toArray(array);
    }

    public List<Collector> getCollectorCollection() {
        return this._collectorList;
    }

    public int getCollectorCount() {
        return this._collectorList.size();
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public int getThreads() {
        return this._threads;
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this._threads;
        if (this._packageList != null) {
            result = 37 * result + ((Object)this._packageList).hashCode();
        }
        if (this._collectorList != null) {
            result = 37 * result + ((Object)this._collectorList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Collector> iterateCollector() {
        return this._collectorList.iterator();
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCollector() {
        this._collectorList.clear();
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public boolean removeCollector(Collector vCollector) {
        boolean removed = this._collectorList.remove(vCollector);
        return removed;
    }

    public Collector removeCollectorAt(int index) {
        Collector obj = this._collectorList.remove(index);
        return obj;
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public void setCollector(int index, Collector vCollector) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._collectorList.size()) {
            throw new IndexOutOfBoundsException("setCollector: Index value '" + index + "' not in range [0.." + (this._collectorList.size() - 1) + "]");
        }
        this._collectorList.set(index, vCollector);
    }

    public void setCollector(Collector[] vCollectorArray) {
        this._collectorList.clear();
        for (int i = 0; i < vCollectorArray.length; ++i) {
            this._collectorList.add(vCollectorArray[i]);
        }
    }

    public void setCollector(List<Collector> vCollectorList) {
        this._collectorList.clear();
        this._collectorList.addAll(vCollectorList);
    }

    public void setCollectorCollection(List<Collector> collectorList) {
        this._collectorList = collectorList;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public static CollectdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CollectdConfiguration)Unmarshaller.unmarshal(CollectdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

