/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.capsd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.capsd.IpManagement;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.capsd.SmbConfig;
import org.xml.sax.ContentHandler;

public class CapsdConfiguration
implements Serializable {
    private long _rescanFrequency = 0L;
    private boolean _has_rescanFrequency;
    private long _initialSleepTime = 0L;
    private boolean _has_initialSleepTime;
    private int _maxSuspectThreadPoolSize;
    private boolean _has_maxSuspectThreadPoolSize;
    private int _maxRescanThreadPoolSize;
    private boolean _has_maxRescanThreadPoolSize;
    private String _managementPolicy = "managed";
    private String _abortProtocolScansIfNoRoute = "false";
    private String _deletePropagationEnabled = "true";
    private String _xmlrpc = "false";
    private List<ProtocolPlugin> _protocolPluginList;
    private SmbConfig _smbConfig;
    private List<IpManagement> _ipManagementList;

    public CapsdConfiguration() {
        this.setManagementPolicy("managed");
        this.setAbortProtocolScansIfNoRoute("false");
        this.setDeletePropagationEnabled("true");
        this.setXmlrpc("false");
        this._protocolPluginList = new ArrayList<ProtocolPlugin>();
        this._ipManagementList = new ArrayList<IpManagement>();
    }

    public void addIpManagement(IpManagement vIpManagement) throws IndexOutOfBoundsException {
        this._ipManagementList.add(vIpManagement);
    }

    public void addIpManagement(int index, IpManagement vIpManagement) throws IndexOutOfBoundsException {
        this._ipManagementList.add(index, vIpManagement);
    }

    public void addProtocolPlugin(ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        this._protocolPluginList.add(vProtocolPlugin);
    }

    public void addProtocolPlugin(int index, ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        this._protocolPluginList.add(index, vProtocolPlugin);
    }

    public void deleteInitialSleepTime() {
        this._has_initialSleepTime = false;
    }

    public void deleteMaxRescanThreadPoolSize() {
        this._has_maxRescanThreadPoolSize = false;
    }

    public void deleteMaxSuspectThreadPoolSize() {
        this._has_maxSuspectThreadPoolSize = false;
    }

    public void deleteRescanFrequency() {
        this._has_rescanFrequency = false;
    }

    public Enumeration<IpManagement> enumerateIpManagement() {
        return Collections.enumeration(this._ipManagementList);
    }

    public Enumeration<ProtocolPlugin> enumerateProtocolPlugin() {
        return Collections.enumeration(this._protocolPluginList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CapsdConfiguration) {
            CapsdConfiguration temp = (CapsdConfiguration)obj;
            if (this._rescanFrequency != temp._rescanFrequency) {
                return false;
            }
            if (this._has_rescanFrequency != temp._has_rescanFrequency) {
                return false;
            }
            if (this._initialSleepTime != temp._initialSleepTime) {
                return false;
            }
            if (this._has_initialSleepTime != temp._has_initialSleepTime) {
                return false;
            }
            if (this._maxSuspectThreadPoolSize != temp._maxSuspectThreadPoolSize) {
                return false;
            }
            if (this._has_maxSuspectThreadPoolSize != temp._has_maxSuspectThreadPoolSize) {
                return false;
            }
            if (this._maxRescanThreadPoolSize != temp._maxRescanThreadPoolSize) {
                return false;
            }
            if (this._has_maxRescanThreadPoolSize != temp._has_maxRescanThreadPoolSize) {
                return false;
            }
            if (this._managementPolicy != null) {
                if (temp._managementPolicy == null) {
                    return false;
                }
                if (!this._managementPolicy.equals(temp._managementPolicy)) {
                    return false;
                }
            } else if (temp._managementPolicy != null) {
                return false;
            }
            if (this._abortProtocolScansIfNoRoute != null) {
                if (temp._abortProtocolScansIfNoRoute == null) {
                    return false;
                }
                if (!this._abortProtocolScansIfNoRoute.equals(temp._abortProtocolScansIfNoRoute)) {
                    return false;
                }
            } else if (temp._abortProtocolScansIfNoRoute != null) {
                return false;
            }
            if (this._deletePropagationEnabled != null) {
                if (temp._deletePropagationEnabled == null) {
                    return false;
                }
                if (!this._deletePropagationEnabled.equals(temp._deletePropagationEnabled)) {
                    return false;
                }
            } else if (temp._deletePropagationEnabled != null) {
                return false;
            }
            if (this._xmlrpc != null) {
                if (temp._xmlrpc == null) {
                    return false;
                }
                if (!this._xmlrpc.equals(temp._xmlrpc)) {
                    return false;
                }
            } else if (temp._xmlrpc != null) {
                return false;
            }
            if (this._protocolPluginList != null) {
                if (temp._protocolPluginList == null) {
                    return false;
                }
                if (!((Object)this._protocolPluginList).equals(temp._protocolPluginList)) {
                    return false;
                }
            } else if (temp._protocolPluginList != null) {
                return false;
            }
            if (this._smbConfig != null) {
                if (temp._smbConfig == null) {
                    return false;
                }
                if (!this._smbConfig.equals(temp._smbConfig)) {
                    return false;
                }
            } else if (temp._smbConfig != null) {
                return false;
            }
            if (this._ipManagementList != null) {
                if (temp._ipManagementList == null) {
                    return false;
                }
                if (!((Object)this._ipManagementList).equals(temp._ipManagementList)) {
                    return false;
                }
            } else if (temp._ipManagementList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAbortProtocolScansIfNoRoute() {
        return this._abortProtocolScansIfNoRoute;
    }

    public String getDeletePropagationEnabled() {
        return this._deletePropagationEnabled;
    }

    public long getInitialSleepTime() {
        return this._initialSleepTime;
    }

    public IpManagement getIpManagement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipManagementList.size()) {
            throw new IndexOutOfBoundsException("getIpManagement: Index value '" + index + "' not in range [0.." + (this._ipManagementList.size() - 1) + "]");
        }
        return this._ipManagementList.get(index);
    }

    public IpManagement[] getIpManagement() {
        IpManagement[] array = new IpManagement[]{};
        return this._ipManagementList.toArray(array);
    }

    public List<IpManagement> getIpManagementCollection() {
        return this._ipManagementList;
    }

    public int getIpManagementCount() {
        return this._ipManagementList.size();
    }

    public String getManagementPolicy() {
        return this._managementPolicy;
    }

    public int getMaxRescanThreadPoolSize() {
        return this._maxRescanThreadPoolSize;
    }

    public int getMaxSuspectThreadPoolSize() {
        return this._maxSuspectThreadPoolSize;
    }

    public ProtocolPlugin getProtocolPlugin(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._protocolPluginList.size()) {
            throw new IndexOutOfBoundsException("getProtocolPlugin: Index value '" + index + "' not in range [0.." + (this._protocolPluginList.size() - 1) + "]");
        }
        return this._protocolPluginList.get(index);
    }

    public ProtocolPlugin[] getProtocolPlugin() {
        ProtocolPlugin[] array = new ProtocolPlugin[]{};
        return this._protocolPluginList.toArray(array);
    }

    public List<ProtocolPlugin> getProtocolPluginCollection() {
        return this._protocolPluginList;
    }

    public int getProtocolPluginCount() {
        return this._protocolPluginList.size();
    }

    public long getRescanFrequency() {
        return this._rescanFrequency;
    }

    public SmbConfig getSmbConfig() {
        return this._smbConfig;
    }

    public String getXmlrpc() {
        return this._xmlrpc;
    }

    public boolean hasInitialSleepTime() {
        return this._has_initialSleepTime;
    }

    public boolean hasMaxRescanThreadPoolSize() {
        return this._has_maxRescanThreadPoolSize;
    }

    public boolean hasMaxSuspectThreadPoolSize() {
        return this._has_maxSuspectThreadPoolSize;
    }

    public boolean hasRescanFrequency() {
        return this._has_rescanFrequency;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this._rescanFrequency ^ this._rescanFrequency >>> 32);
        result = 37 * result + (int)(this._initialSleepTime ^ this._initialSleepTime >>> 32);
        result = 37 * result + this._maxSuspectThreadPoolSize;
        result = 37 * result + this._maxRescanThreadPoolSize;
        if (this._managementPolicy != null) {
            result = 37 * result + this._managementPolicy.hashCode();
        }
        if (this._abortProtocolScansIfNoRoute != null) {
            result = 37 * result + this._abortProtocolScansIfNoRoute.hashCode();
        }
        if (this._deletePropagationEnabled != null) {
            result = 37 * result + this._deletePropagationEnabled.hashCode();
        }
        if (this._xmlrpc != null) {
            result = 37 * result + this._xmlrpc.hashCode();
        }
        if (this._protocolPluginList != null) {
            result = 37 * result + ((Object)this._protocolPluginList).hashCode();
        }
        if (this._smbConfig != null) {
            result = 37 * result + this._smbConfig.hashCode();
        }
        if (this._ipManagementList != null) {
            result = 37 * result + ((Object)this._ipManagementList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<IpManagement> iterateIpManagement() {
        return this._ipManagementList.iterator();
    }

    public Iterator<ProtocolPlugin> iterateProtocolPlugin() {
        return this._protocolPluginList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIpManagement() {
        this._ipManagementList.clear();
    }

    public void removeAllProtocolPlugin() {
        this._protocolPluginList.clear();
    }

    public boolean removeIpManagement(IpManagement vIpManagement) {
        boolean removed = this._ipManagementList.remove(vIpManagement);
        return removed;
    }

    public IpManagement removeIpManagementAt(int index) {
        IpManagement obj = this._ipManagementList.remove(index);
        return obj;
    }

    public boolean removeProtocolPlugin(ProtocolPlugin vProtocolPlugin) {
        boolean removed = this._protocolPluginList.remove(vProtocolPlugin);
        return removed;
    }

    public ProtocolPlugin removeProtocolPluginAt(int index) {
        ProtocolPlugin obj = this._protocolPluginList.remove(index);
        return obj;
    }

    public void setAbortProtocolScansIfNoRoute(String abortProtocolScansIfNoRoute) {
        this._abortProtocolScansIfNoRoute = abortProtocolScansIfNoRoute;
    }

    public void setDeletePropagationEnabled(String deletePropagationEnabled) {
        this._deletePropagationEnabled = deletePropagationEnabled;
    }

    public void setInitialSleepTime(long initialSleepTime) {
        this._initialSleepTime = initialSleepTime;
        this._has_initialSleepTime = true;
    }

    public void setIpManagement(int index, IpManagement vIpManagement) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipManagementList.size()) {
            throw new IndexOutOfBoundsException("setIpManagement: Index value '" + index + "' not in range [0.." + (this._ipManagementList.size() - 1) + "]");
        }
        this._ipManagementList.set(index, vIpManagement);
    }

    public void setIpManagement(IpManagement[] vIpManagementArray) {
        this._ipManagementList.clear();
        for (int i = 0; i < vIpManagementArray.length; ++i) {
            this._ipManagementList.add(vIpManagementArray[i]);
        }
    }

    public void setIpManagement(List<IpManagement> vIpManagementList) {
        this._ipManagementList.clear();
        this._ipManagementList.addAll(vIpManagementList);
    }

    public void setIpManagementCollection(List<IpManagement> ipManagementList) {
        this._ipManagementList = ipManagementList;
    }

    public void setManagementPolicy(String managementPolicy) {
        this._managementPolicy = managementPolicy;
    }

    public void setMaxRescanThreadPoolSize(int maxRescanThreadPoolSize) {
        this._maxRescanThreadPoolSize = maxRescanThreadPoolSize;
        this._has_maxRescanThreadPoolSize = true;
    }

    public void setMaxSuspectThreadPoolSize(int maxSuspectThreadPoolSize) {
        this._maxSuspectThreadPoolSize = maxSuspectThreadPoolSize;
        this._has_maxSuspectThreadPoolSize = true;
    }

    public void setProtocolPlugin(int index, ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._protocolPluginList.size()) {
            throw new IndexOutOfBoundsException("setProtocolPlugin: Index value '" + index + "' not in range [0.." + (this._protocolPluginList.size() - 1) + "]");
        }
        this._protocolPluginList.set(index, vProtocolPlugin);
    }

    public void setProtocolPlugin(ProtocolPlugin[] vProtocolPluginArray) {
        this._protocolPluginList.clear();
        for (int i = 0; i < vProtocolPluginArray.length; ++i) {
            this._protocolPluginList.add(vProtocolPluginArray[i]);
        }
    }

    public void setProtocolPlugin(List<ProtocolPlugin> vProtocolPluginList) {
        this._protocolPluginList.clear();
        this._protocolPluginList.addAll(vProtocolPluginList);
    }

    public void setProtocolPluginCollection(List<ProtocolPlugin> protocolPluginList) {
        this._protocolPluginList = protocolPluginList;
    }

    public void setRescanFrequency(long rescanFrequency) {
        this._rescanFrequency = rescanFrequency;
        this._has_rescanFrequency = true;
    }

    public void setSmbConfig(SmbConfig smbConfig) {
        this._smbConfig = smbConfig;
    }

    public void setXmlrpc(String xmlrpc) {
        this._xmlrpc = xmlrpc;
    }

    public static CapsdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CapsdConfiguration)Unmarshaller.unmarshal(CapsdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

