/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xmlrpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.secure.SecureXmlRpcClient;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class XmlRpcClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    SecureXmlRpcClient client;
    String serviceName;
    boolean secure = false;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String methodName = methodInvocation.getMethod().getName();
        Object[] args = methodInvocation.getArguments();
        Vector parms = new Vector(args == null ? Collections.emptyList() : Arrays.asList(args));
        String serviceMethod = this.serviceName == null ? methodName : this.serviceName + "." + methodName;
        try {
            return this.getClient().execute(serviceMethod, parms);
        }
        catch (XmlRpcException e) {
            if (e.code == 1) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (e.code == 2) {
                throw new MalformedURLException(e.getMessage());
            }
            throw new RemoteAccessException(serviceMethod, (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteAccessException(serviceMethod, (Throwable)e);
        }
    }

    private XmlRpcClient getClient() {
        if (this.client == null) {
            try {
                this.client = new SecureXmlRpcClient(this.getServiceUrl());
                this.client.setup();
            }
            catch (Throwable e) {
                throw new RemoteLookupFailureException("Invalid url ", e);
            }
        }
        return this.client;
    }
}

