/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.trapd.BroadcastEventProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Trapd
extends AbstractServiceDaemon
implements PausableFiber,
TrapProcessorFactory,
TrapNotificationListener,
InitializingBean {
    private int m_status = 0;
    private FifoQueue<TrapNotification> m_backlogQ;
    private TrapQueueProcessor m_processor;
    private BroadcastEventProcessor m_eventReader;
    private TrapdIpMgr m_trapdIpMgr;
    private String m_snmpTrapAddress;
    private Integer m_snmpTrapPort;
    private List<SnmpV3User> m_snmpV3Users;
    private boolean m_registeredForTraps;

    public Trapd() {
        super("OpenNMS.Trapd");
    }

    public TrapProcessor createTrapProcessor() {
        return new EventCreator(this.m_trapdIpMgr);
    }

    public void trapReceived(TrapNotification trapNotification) {
        this.addTrap(trapNotification);
    }

    private void addTrap(TrapNotification o) {
        try {
            this.m_backlogQ.add((Object)o);
        }
        catch (InterruptedException e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"addTrap: Error adding trap to queue, it was interrupted", (Object[])new Object[0]);
            Thread.currentThread().interrupt();
        }
        catch (FifoQueueException e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"addTrap: Error adding trap to queue", (Object[])new Object[0]);
        }
    }

    public synchronized void onInit() {
        Assert.state((this.m_trapdIpMgr != null ? 1 : 0) != 0, (String)"trapdIpMgr must be set");
        Assert.state((this.m_eventReader != null ? 1 : 0) != 0, (String)"eventReader must be set");
        Assert.state((this.m_backlogQ != null ? 1 : 0) != 0, (String)"backlogQ must be set");
        Assert.state((this.m_snmpTrapAddress != null ? 1 : 0) != 0, (String)"snmpTrapAddress must be set");
        Assert.state((this.m_snmpTrapPort != null ? 1 : 0) != 0, (String)"snmpTrapPort must be set");
        Assert.state((this.m_processor != null ? 1 : 0) != 0, (String)"processor must be set");
        try {
            this.m_trapdIpMgr.dataSourceSync();
        }
        catch (SQLException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"init: Failed to load known IP address list", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        try {
            InetAddress address = this.getInetAddress();
            LogUtils.infof((Object)((Object)this), (String)"Listening on %s:%d", (Object[])new Object[]{address == null ? "[all interfaces]" : InetAddressUtils.str((InetAddress)address), this.getSnmpTrapPort()});
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (TrapProcessorFactory)this, (InetAddress)address, (int)this.getSnmpTrapPort(), this.getSnmpV3Users());
            this.m_registeredForTraps = true;
            LogUtils.debugf((Object)((Object)this), (String)"init: Creating the trap session", (Object[])new Object[0]);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                this.managerLog().error((Object)"init: Failed to listen on SNMP trap port, perhaps something else is already listening?", (Throwable)e);
                LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"init: Failed to listen on SNMP trap port, perhaps something else is already listening?", (Object[])new Object[0]);
            } else {
                LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"init: Failed to initialize SNMP trap socket", (Object[])new Object[0]);
            }
            throw new UndeclaredThrowableException(e);
        }
        try {
            this.m_eventReader.open();
        }
        catch (Throwable e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"init: Failed to open event reader", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
    }

    private InetAddress getInetAddress() {
        if (this.m_snmpTrapAddress.equals("*")) {
            return null;
        }
        return InetAddressUtils.addr((String)this.m_snmpTrapAddress);
    }

    private Category managerLog() {
        return Logger.getLogger((String)"OpenNMS.Manager");
    }

    public synchronized void onStart() {
        this.m_status = 1;
        LogUtils.debugf((Object)((Object)this), (String)"start: Initializing the trapd config factory", (Object[])new Object[0]);
        this.m_processor.start();
        this.m_status = 2;
        LogUtils.debugf((Object)((Object)this), (String)"start: Trapd ready to receive traps", (Object[])new Object[0]);
    }

    public void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        LogUtils.debugf((Object)((Object)this), (String)"pause: Calling pause on processor", (Object[])new Object[0]);
        this.m_processor.pause();
        this.m_status = 6;
        LogUtils.debugf((Object)((Object)this), (String)"pause: Trapd paused", (Object[])new Object[0]);
    }

    public void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        LogUtils.debugf((Object)((Object)this), (String)"resume: Calling resume on processor", (Object[])new Object[0]);
        this.m_processor.resume();
        this.m_status = 2;
        LogUtils.debugf((Object)((Object)this), (String)"resume: Trapd resumed", (Object[])new Object[0]);
    }

    public synchronized void onStop() {
        this.m_status = 3;
        LogUtils.debugf((Object)((Object)this), (String)"stop: closing communication paths.", (Object[])new Object[0]);
        try {
            if (this.m_registeredForTraps) {
                LogUtils.debugf((Object)((Object)this), (String)"stop: Closing SNMP trap session.", (Object[])new Object[0]);
                SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (InetAddress)this.getInetAddress(), (int)this.getSnmpTrapPort());
                LogUtils.debugf((Object)((Object)this), (String)"stop: SNMP trap session closed.", (Object[])new Object[0]);
            } else {
                LogUtils.debugf((Object)((Object)this), (String)"stop: not attemping to closing SNMP trap session--it was never opened", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"stop: exception occurred closing session", (Object[])new Object[0]);
        }
        catch (IllegalStateException e) {
            LogUtils.debugf((Object)((Object)this), (Throwable)e, (String)"stop: The SNMP session was already closed", (Object[])new Object[0]);
        }
        LogUtils.debugf((Object)((Object)this), (String)"stop: Stopping queue processor.", (Object[])new Object[0]);
        this.m_processor.stop();
        this.m_eventReader.close();
        this.m_status = 4;
        LogUtils.debugf((Object)((Object)this), (String)"stop: Trapd stopped", (Object[])new Object[0]);
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public void trapError(int error, String msg) {
        LogUtils.warnf((Object)((Object)this), (String)("Error Processing Received Trap: error = " + error + (msg != null ? ", ref = " + msg : "")), (Object[])new Object[0]);
    }

    public TrapdIpMgr getTrapdIpMgr() {
        return this.m_trapdIpMgr;
    }

    public void setTrapdIpMgr(TrapdIpMgr trapdIpMgr) {
        this.m_trapdIpMgr = trapdIpMgr;
    }

    public BroadcastEventProcessor getEventReader() {
        return this.m_eventReader;
    }

    public void setEventReader(BroadcastEventProcessor eventReader) {
        this.m_eventReader = eventReader;
    }

    public FifoQueue<TrapNotification> getBacklogQ() {
        return this.m_backlogQ;
    }

    public void setBacklogQ(FifoQueue<TrapNotification> backlogQ) {
        this.m_backlogQ = backlogQ;
    }

    public TrapQueueProcessor getProcessor() {
        return this.m_processor;
    }

    public void setProcessor(TrapQueueProcessor processor) {
        this.m_processor = processor;
    }

    public String getSnmpTrapAddress() {
        return this.m_snmpTrapAddress;
    }

    public void setSnmpTrapAddress(String snmpTrapAddress) {
        this.m_snmpTrapAddress = snmpTrapAddress;
    }

    public int getSnmpTrapPort() {
        return this.m_snmpTrapPort;
    }

    public void setSnmpTrapPort(int snmpTrapPort) {
        this.m_snmpTrapPort = snmpTrapPort;
    }

    public List<SnmpV3User> getSnmpV3Users() {
        return this.m_snmpV3Users;
    }

    public void setSnmpV3Users(List<SnmpV3User> snmpV3Users) {
        this.m_snmpV3Users = snmpV3Users;
    }
}

