/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

class TrapQueueProcessor
implements Runnable,
PausableFiber,
InitializingBean {
    private FifoQueue<TrapNotification> m_backlogQ;
    private static final String LOCALHOST_ADDRESS = InetAddressUtils.getLocalHostName();
    private int m_status;
    private Thread m_worker;
    private Boolean m_newSuspect;
    private EventIpcManager m_eventMgr;
    private EventConfDao m_eventConfDao;

    private void process(TrapNotification info) {
        try {
            this.processTrapEvent(((EventCreator)info.getTrapProcessor()).getEvent());
        }
        catch (IllegalArgumentException e) {
            this.log().info(e.getMessage());
        }
    }

    public void processTrapEvent(org.opennms.netmgt.xml.event.Event event) {
        String dest;
        Logmsg logmsg;
        InetAddress trapInterface = event.getInterfaceAddress();
        Event econf = this.m_eventConfDao.findByEvent(event);
        if (econf == null || econf.getUei() == null) {
            event.setUei("uei.opennms.org/default/trap");
        } else {
            event.setUei(econf.getUei());
        }
        if (econf != null && (logmsg = econf.getLogmsg()) != null && "discardtraps".equals(dest = logmsg.getDest())) {
            this.log().debug("Trap discarded due to matching event having logmsg dest == discardtraps");
            return;
        }
        this.m_eventMgr.sendNow(event);
        this.log().debug("Trap successfully converted and sent to eventd with UEI " + event.getUei());
        if (!event.hasNodeid() && this.m_newSuspect.booleanValue()) {
            this.sendNewSuspectEvent(InetAddressUtils.str((InetAddress)trapInterface));
            if (this.log().isDebugEnabled()) {
                this.log().debug("Sent newSuspectEvent for interface: " + trapInterface);
            }
        }
    }

    private void sendNewSuspectEvent(String trapInterface) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "trapd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(LOCALHOST_ADDRESS);
        this.m_eventMgr.sendNow(bldr.getEvent());
    }

    private synchronized boolean statusOK() {
        boolean exitThread = false;
        boolean exitCheck = false;
        while (!exitCheck) {
            if (!this.m_worker.isAlive() && this.m_status != 3) {
                this.log().warn(this.getName() + " terminated abnormally");
                this.m_status = 3;
            }
            if (this.m_status == 3) {
                exitCheck = true;
                exitThread = true;
                this.m_status = 4;
                continue;
            }
            if (this.m_status == 5) {
                this.pause();
                continue;
            }
            if (this.m_status == 7) {
                this.resume();
                continue;
            }
            if (this.m_status == 6) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.m_status = 3;
                }
                continue;
            }
            if (this.m_status != 2) continue;
            exitCheck = true;
        }
        return !exitThread;
    }

    public synchronized void start() {
        Assert.state((this.m_worker == null ? 1 : 0) != 0, (String)"The fiber is running or has already run");
        this.m_status = 1;
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug(this.getName() + " started");
        }
    }

    public synchronized void pause() {
        Assert.state((this.m_worker != null && this.m_worker.isAlive() ? 1 : 0) != 0, (String)"The fiber is not running");
        this.m_status = 6;
        this.notifyAll();
    }

    public synchronized void resume() {
        Assert.state((this.m_worker != null && this.m_worker.isAlive() ? 1 : 0) != 0, (String)"The fiber is not running");
        this.m_status = 2;
        this.notifyAll();
    }

    public synchronized void stop() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never run");
        this.m_status = 3;
        this.m_worker.interrupt();
        this.notifyAll();
    }

    public String getName() {
        return "TrapQueueProcessor";
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TrapQueueProcessor trapQueueProcessor = this;
        synchronized (trapQueueProcessor) {
            this.m_status = 2;
        }
        while (this.statusOK()) {
            TrapNotification o = null;
            try {
                o = (TrapNotification)this.m_backlogQ.remove(1000L);
            }
            catch (InterruptedException iE) {
                this.log().debug("Trapd.QueueProcessor: caught interrupted exception");
                o = null;
                this.m_status = 3;
            }
            catch (FifoQueueException qE) {
                this.log().debug("Trapd.QueueProcessor: caught fifo queue exception");
                this.log().debug(qE.getLocalizedMessage(), (Throwable)qE);
                o = null;
                this.m_status = 3;
            }
            if (o == null || !this.statusOK()) continue;
            try {
                this.process(o);
            }
            catch (Throwable t) {
                this.log().error("Unexpected error processing trap: " + t, t);
            }
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public FifoQueue<TrapNotification> getBacklogQ() {
        return this.m_backlogQ;
    }

    public void setBacklogQ(FifoQueue<TrapNotification> backlogQ) {
        this.m_backlogQ = backlogQ;
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }

    public EventIpcManager getEventMgr() {
        return this.m_eventMgr;
    }

    public void setEventMgr(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public Boolean isNewSuspect() {
        return this.m_newSuspect;
    }

    public void setNewSuspect(Boolean newSuspect) {
        this.m_newSuspect = newSuspect;
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_backlogQ != null ? 1 : 0) != 0, (String)"property backlogQ must be set");
        Assert.state((this.m_eventConfDao != null ? 1 : 0) != 0, (String)"property eventConfDao must be set");
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"property eventMgr must be set");
        Assert.state((this.m_newSuspect != null ? 1 : 0) != 0, (String)"property newSuspect must be set");
    }
}

