/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

public class ThresholdingEventProxy
implements EventProxy {
    private List<Event> m_events = new LinkedList<Event>();

    public void send(Event event) throws EventProxyException {
        this.add(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        for (Event e : eventLog.getEvents().getEventCollection()) {
            this.add(e);
        }
    }

    public void add(Event event) {
        this.m_events.add(event);
    }

    public void add(List<Event> events) {
        this.m_events.addAll(events);
    }

    public void removeAllEvents() {
        this.m_events.clear();
    }

    public void sendAllEvents() {
        if (this.m_events.size() > 0) {
            try {
                Log log = new Log();
                Events events = new Events();
                for (Event e : this.m_events) {
                    events.addEvent(e);
                }
                log.setEvents(events);
                EventIpcManagerFactory.getIpcManager().sendNow(log);
            }
            catch (Throwable e) {
                this.log().info("sendAllEvents: Failed sending threshold events: " + e, e);
            }
            this.removeAllEvents();
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

