/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.threshd.SnmpThresholdConfiguration;
import org.opennms.netmgt.threshd.SnmpThresholder;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;

public class SnmpThresholdNetworkInterface {
    private ThresholdNetworkInterface m_networkInterface;
    private SnmpThresholdConfiguration m_thresholdConfiguration;
    private Map<String, Map<String, Set<ThresholdEntity>>> m_allInterfaceMap;

    public SnmpThresholdNetworkInterface(ThresholdsDao thresholdsDao, ThresholdNetworkInterface iface, Map<?, ?> parms) {
        this.setNetworkInterface(iface);
        this.setThresholdConfiguration(new SnmpThresholdConfiguration(thresholdsDao, parms));
        this.setAllInterfaceMap(new HashMap<String, Map<String, Set<ThresholdEntity>>>());
    }

    public SnmpThresholdConfiguration getThresholdConfiguration() {
        return this.m_thresholdConfiguration;
    }

    public void setThresholdConfiguration(SnmpThresholdConfiguration thresholdConfiguration) {
        this.m_thresholdConfiguration = thresholdConfiguration;
    }

    public void setAllInterfaceMap(Map<String, Map<String, Set<ThresholdEntity>>> allInterfaceMap) {
        this.m_allInterfaceMap = allInterfaceMap;
    }

    public Map<String, Map<String, Set<ThresholdEntity>>> getAllInterfaceMap() {
        return this.m_allInterfaceMap;
    }

    public ThresholdNetworkInterface getNetworkInterface() {
        return this.m_networkInterface;
    }

    public void setNetworkInterface(ThresholdNetworkInterface networkInterface) {
        this.m_networkInterface = networkInterface;
    }

    public boolean isIPV4() {
        return this.getNetworkInterface().getType() == 1;
    }

    public InetAddress getInetAddress() {
        return (InetAddress)this.getNetworkInterface().getAddress();
    }

    public String getIpAddress() {
        return InetAddressUtils.str((InetAddress)this.getInetAddress());
    }

    public Integer getNodeId() {
        return this.m_networkInterface.getNodeId();
    }

    public String toString() {
        return this.getNodeId() + "/" + this.getIpAddress() + "/" + this.m_thresholdConfiguration.getGroupName();
    }

    public Map<String, Set<ThresholdEntity>> getNodeThresholdMap() {
        ThresholdResourceType resourceType = this.getThresholdConfiguration().getNodeResourceType();
        return resourceType.getThresholdMap();
    }

    public Map<String, Set<ThresholdEntity>> getInterfaceThresholdMap(String ifLabel) {
        ThresholdResourceType resourceType = this.getThresholdConfiguration().getIfResourceType();
        Map<String, Set<ThresholdEntity>> thresholdMap = this.getAllInterfaceMap().get(ifLabel);
        if (thresholdMap == null) {
            thresholdMap = SnmpThresholder.getAttributeMap(resourceType);
            this.getAllInterfaceMap().put(ifLabel, thresholdMap);
        }
        return thresholdMap;
    }
}

