/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.net.InetAddress;
import java.util.Date;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.xml.event.Event;

public class LatencyInterface {
    private NetworkInterface<InetAddress> m_iface;
    private String m_serviceName;

    public LatencyInterface(NetworkInterface<InetAddress> iface, String serviceName) {
        this.m_iface = iface;
        this.m_serviceName = serviceName;
    }

    public NetworkInterface<InetAddress> getNetworkInterface() {
        return this.m_iface;
    }

    Map<String, ThresholdEntity> getThresholdMap() {
        NetworkInterface<InetAddress> iface = this.getNetworkInterface();
        Map thresholdMap = (Map)iface.getAttribute("org.opennms.netmgt.collectd.LatencyThresholder.ThresholdMap");
        return thresholdMap;
    }

    InetAddress getInetAddress() {
        return (InetAddress)this.getNetworkInterface().getAddress();
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    int getNodeId() throws ThresholdingException {
        NetworkInterface<InetAddress> iface = this.getNetworkInterface();
        int nodeId = -1;
        Integer tmp = (Integer)iface.getAttribute("org.opennms.netmgt.collectd.SnmpThresholder.NodeId");
        if (tmp != null) {
            nodeId = tmp;
        }
        if (nodeId == -1) {
            throw new ThresholdingException("Threshold checking failed for " + this.getServiceName() + "/" + this.getHostAddress() + ", missing nodeId.", 2);
        }
        return nodeId;
    }

    public String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getInetAddress());
    }

    File getLatencyDir() throws ThresholdingException {
        File latencyDir;
        String repository = (String)this.getNetworkInterface().getAttribute("org.opennms.netmgt.collectd.LatencyThresholder.RrdRepository");
        if (this.log().isDebugEnabled()) {
            this.log().debug("check: rrd repository=" + repository);
        }
        if (!(latencyDir = new File(repository + File.separator + this.getHostAddress())).exists()) {
            throw new ThresholdingException("Latency directory for " + this.getServiceName() + "/" + this.getHostAddress() + " does not exist. Threshold checking failed for " + this.getHostAddress(), 2);
        }
        if (!RrdFileConstants.isValidRRDLatencyDir((File)latencyDir)) {
            throw new ThresholdingException("Latency directory for " + this.getServiceName() + "/" + this.getHostAddress() + " is not a valid RRD latency directory. Threshold checking failed for " + this.getHostAddress(), 2);
        }
        return latencyDir;
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(LatencyInterface.class);
    }

    Event createEvent(double dsValue, Threshold threshold, String uei, Date date) throws ThresholdingException {
        int nodeId = this.getNodeId();
        InetAddress ipAddr = this.getInetAddress();
        ThreadCategory log = ThreadCategory.getInstance(LatencyInterface.class);
        if (threshold == null) {
            throw new IllegalArgumentException("threshold cannot be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug("createEvent: ds=" + threshold.getDsName() + " uei=" + uei);
        }
        EventBuilder bldr = new EventBuilder(uei, "OpenNMS.Threshd:" + threshold.getDsName(), date);
        bldr.setNodeid((long)nodeId);
        bldr.setInterface(ipAddr);
        bldr.setService(this.getServiceName());
        bldr.setHost(InetAddressUtils.getLocalHostName());
        bldr.addParam("ds", threshold.getDsName());
        bldr.addParam("value", dsValue);
        bldr.addParam("threshold", threshold.getValue());
        bldr.addParam("trigger", threshold.getTrigger());
        bldr.addParam("rearm", threshold.getRearm());
        return bldr.getEvent();
    }
}

