/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.poller.LatencyCollectionResource;
import org.opennms.netmgt.threshd.JdbcIfInfoGetter;

public class CollectionResourceWrapper {
    private int m_nodeId;
    private String m_hostAddress;
    private String m_serviceName;
    private String m_label;
    private String m_iflabel;
    private String m_ifindex;
    private RrdRepository m_repository;
    private CollectionResource m_resource;
    private Map<String, CollectionAttribute> m_attributes;
    static Map<String, CacheEntry> s_cache = new ConcurrentHashMap<String, CacheEntry>();
    private Map<String, Double> m_localCache = new HashMap<String, Double>();
    private Map<String, String> m_ifInfo;
    private Date m_collectionTimestamp;

    public CollectionResourceWrapper(Date collectionTimestamp, int nodeId, String hostAddress, String serviceName, RrdRepository repository, CollectionResource resource, Map<String, CollectionAttribute> attributes) {
        this.m_collectionTimestamp = collectionTimestamp;
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress;
        this.m_serviceName = serviceName;
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_attributes = attributes;
        if (this.isAnInterfaceResource()) {
            if (resource instanceof AliasedResource) {
                this.m_iflabel = ((AliasedResource)resource).getLabel();
                this.m_ifInfo = ((AliasedResource)resource).getIfInfo().getAttributesMap();
                this.m_ifInfo.put("domain", ((AliasedResource)resource).getDomain());
            }
            if (resource instanceof IfInfo) {
                this.m_iflabel = ((IfInfo)resource).getLabel();
                this.m_ifInfo = ((IfInfo)resource).getAttributesMap();
            }
            if (resource instanceof LatencyCollectionResource) {
                JdbcIfInfoGetter ifInfoGetter = new JdbcIfInfoGetter();
                String ipAddress = ((LatencyCollectionResource)resource).getIpAddress();
                this.m_iflabel = ifInfoGetter.getIfLabel(this.getNodeId(), ipAddress);
                if (this.m_iflabel != null) {
                    this.m_ifInfo = ifInfoGetter.getIfInfoForNodeAndLabel(this.getNodeId(), this.m_iflabel);
                } else {
                    this.log().info("Can't find ifLabel for latency resource " + resource.getInstance() + " on node " + this.getNodeId());
                }
            }
            if (this.m_ifInfo != null) {
                this.m_ifindex = this.m_ifInfo.get("snmpifindex");
            } else {
                this.log().info("Can't find ifInfo for " + resource);
            }
        }
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getHostAddress() {
        return this.m_hostAddress;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getInstance() {
        return this.m_resource != null ? this.m_resource.getInstance() : null;
    }

    public String getResourceTypeName() {
        return this.m_resource != null ? this.m_resource.getResourceTypeName() : null;
    }

    public String getIfLabel() {
        return this.m_iflabel;
    }

    public String getIfIndex() {
        return this.m_ifindex;
    }

    protected String getIfInfoValue(String attribute) {
        if (this.m_ifInfo != null) {
            return this.m_ifInfo.get(attribute);
        }
        return null;
    }

    public boolean isAnInterfaceResource() {
        return this.getResourceTypeName() != null && this.getResourceTypeName().equals("if");
    }

    public boolean isValidInterfaceResource() {
        if (this.m_ifInfo == null) {
            return false;
        }
        try {
            if (null == this.m_ifindex) {
                return false;
            }
            if (Integer.parseInt(this.m_ifindex) < 0) {
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public Double getAttributeValue(String ds) {
        if (this.m_attributes == null || this.m_attributes.get(ds) == null) {
            this.log().warn("getAttributeValue: can't find attribute called " + ds + " on " + this.m_resource);
            return null;
        }
        String numValue = this.m_attributes.get(ds).getNumericValue();
        if (numValue == null) {
            this.log().warn("getAttributeValue: can't find numeric value for " + ds + " on " + this.m_resource);
            return null;
        }
        String id = "node[" + this.m_nodeId + "].resourceType[" + this.m_resource.getResourceTypeName() + "].instance[" + this.m_resource.getLabel() + "].metric[" + ds + "]";
        Double current = null;
        try {
            current = Double.parseDouble(numValue);
        }
        catch (NumberFormatException e) {
            this.log().error(id + " does not have a numeric value: " + numValue);
            return null;
        }
        if (!this.m_attributes.get(ds).getType().toLowerCase().startsWith("counter")) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("getAttributeValue: id=" + id + ", value= " + current);
            }
            return current;
        }
        return this.getCounterValue(id, current);
    }

    private Double getCounterValue(String id, Double current) {
        if (!this.m_localCache.containsKey(id)) {
            CacheEntry last = s_cache.get(id);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getCounterValue: id=" + id + ", last=" + (last == null ? last : last.value + "@" + last.timestamp) + ", current=" + current);
            }
            s_cache.put(id, new CacheEntry(this.m_collectionTimestamp, current));
            if (last == null) {
                this.m_localCache.put(id, Double.NaN);
                this.log().info("getCounterValue: unknown last value, ignoring current");
            } else {
                long interval;
                if (this.m_collectionTimestamp == null) {
                    this.log().error("getCounterValue: Haven't got a collection timestamp while calculating a counter for key " + id + " on " + this.m_resource + ".  This is a programmer error and should be reported");
                    return null;
                }
                Double delta = current - last.value;
                if (delta < 0.0) {
                    double newDelta = delta;
                    if ((newDelta += Math.pow(2.0, 32.0)) < 0.0) {
                        newDelta += Math.pow(2.0, 64.0) - Math.pow(2.0, 32.0);
                    }
                    this.log().info("getCounterValue: " + id + "(counter) wrapped counter adjusted last=" + last.value + "@" + last.timestamp + ", current=" + current + ", olddelta=" + delta + ", newdelta=" + newDelta);
                    delta = newDelta;
                }
                if ((interval = (this.m_collectionTimestamp.getTime() - last.timestamp.getTime()) / 1000L) > 0L) {
                    this.m_localCache.put(id, delta / (double)interval);
                } else {
                    this.log().error("getCounterValue: invalid interval rate for " + id + ". The last valid value for the metric was " + last.value + " at " + last.timestamp + ". This value will be used instead.");
                }
            }
        }
        return this.m_localCache.get(id);
    }

    public String getLabelValue(String ds) {
        if (ds == null || ds.equals("")) {
            return null;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("getLabelValue: Getting Value for " + this.m_resource.getResourceTypeName() + "::" + ds);
        }
        if ("nodeid".equals(ds)) {
            return Integer.toString(this.m_nodeId);
        }
        if ("ipaddress".equals(ds)) {
            return this.m_hostAddress;
        }
        if ("iflabel".equals(ds)) {
            return this.getIfLabel();
        }
        String value = null;
        File resourceDirectory = this.m_resource.getResourceDir(this.m_repository);
        if ("ID".equals(ds)) {
            return resourceDirectory.getName();
        }
        try {
            if (this.isAnInterfaceResource()) {
                value = this.getIfInfoValue(ds);
            }
            if (value == null) {
                value = ResourceTypeUtils.getStringProperty((File)resourceDirectory, (String)ds);
            }
        }
        catch (Throwable e) {
            this.log().info("getLabelValue: Can't get value for attribute " + ds + " for resource " + this.m_resource + ". " + e, e);
        }
        if (value == null) {
            this.log().debug("getLabelValue: The field " + ds + " is not a string property. Trying to parse it as numeric metric.");
            Double d = this.getAttributeValue(ds);
            if (d != null) {
                value = d.toString();
            }
        }
        return value;
    }

    public String toString() {
        return this.m_resource.toString();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    static class CacheEntry {
        Date timestamp;
        Double value;

        public CacheEntry(Date timestamp, Double value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

