/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogSeverity;

public class SyslogMessage {
    private static final ThreadLocal<DateFormat> m_dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private static final ThreadLocal<DateFormat> m_rfc3339Format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private SyslogFacility m_facility = SyslogFacility.UNKNOWN;
    private SyslogSeverity m_severity = SyslogSeverity.UNKNOWN;
    private Integer m_version;
    private Date m_date;
    private String m_hostname;
    private String m_processName;
    private Integer m_processId;
    private String m_messageId;
    private String m_message;
    private String m_matchedMessage;
    private String m_fullText;

    public SyslogMessage() {
    }

    public SyslogMessage(int facility, int severity, Date date, String hostname, String processName, Integer processId, String message) {
        this();
        this.m_facility = SyslogFacility.getFacility(facility);
        this.m_severity = SyslogSeverity.getSeverity(severity);
        this.m_date = date;
        this.m_processName = processName;
        this.m_processId = processId;
        this.m_message = message;
    }

    public SyslogFacility getFacility() {
        return this.m_facility;
    }

    public void setFacility(SyslogFacility facility) {
        this.m_fullText = null;
        this.m_facility = facility;
    }

    public SyslogSeverity getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(SyslogSeverity severity) {
        this.m_fullText = null;
        this.m_severity = severity;
    }

    public Integer getVersion() {
        return this.m_version;
    }

    public void setVersion(Integer version) {
        this.m_fullText = null;
        this.m_version = version;
    }

    public Date getDate() {
        return this.m_date;
    }

    public void setDate(Date date) {
        this.m_fullText = null;
        this.m_date = date;
    }

    public String getHostName() {
        return this.m_hostname;
    }

    public void setHostName(String hostname) {
        this.m_fullText = null;
        this.m_hostname = hostname;
    }

    public String getHostAddress() {
        if (this.m_hostname != null) {
            try {
                InetAddress address = InetAddressUtils.addr((String)this.m_hostname);
                return InetAddressUtils.str((InetAddress)address).replace("/", "");
            }
            catch (IllegalArgumentException e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to resolve hostname '%s' in syslog message.", (Object[])new Object[]{this.m_hostname});
                return null;
            }
        }
        return null;
    }

    public String getProcessName() {
        return this.m_processName;
    }

    public void setProcessName(String processName) {
        this.m_fullText = null;
        this.m_processName = processName;
    }

    public Integer getProcessId() {
        return this.m_processId;
    }

    public void setProcessId(Integer processId) {
        this.m_fullText = null;
        this.m_processId = processId;
    }

    public String getMessageID() {
        return this.m_messageId;
    }

    public void setMessageID(String messageId) {
        this.m_fullText = null;
        this.m_messageId = messageId;
    }

    public String getMessage() {
        return this.m_message;
    }

    public void setMessage(String message) {
        this.m_fullText = null;
        this.m_message = message;
    }

    public String getMatchedMessage() {
        return this.m_matchedMessage == null ? this.m_message : this.m_matchedMessage;
    }

    public void setMatchedMessage(String matchedMessage) {
        this.m_fullText = null;
        this.m_matchedMessage = matchedMessage;
    }

    public int getPriorityField() {
        if (this.m_severity != null && this.m_facility != null) {
            return this.m_severity.getPriority(this.m_facility);
        }
        return 0;
    }

    public String getSyslogFormattedDate() {
        if (this.m_date == null) {
            return null;
        }
        return m_dateFormat.get().format(this.m_date);
    }

    public String getRfc3339FormattedDate() {
        if (this.m_date == null) {
            return null;
        }
        return m_rfc3339Format.get().format(this.m_date);
    }

    public String getFullText() {
        if (this.m_fullText == null) {
            this.m_fullText = this.m_processId != null && this.m_processName != null ? String.format("<%d>%s %s %s[%d]: %s", this.getPriorityField(), this.getSyslogFormattedDate(), this.getHostName(), this.getProcessName(), this.getProcessId(), this.getMessage()) : (this.m_processName != null ? String.format("<%d>%s %s %s: %s", this.getPriorityField(), this.getSyslogFormattedDate(), this.getHostName(), this.getProcessName(), this.getMessage()) : String.format("<%d>%s %s %s", this.getPriorityField(), this.getSyslogFormattedDate(), this.getHostName(), this.getMessage()));
        }
        return this.m_fullText;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("facility", (Object)this.m_facility).append("severity", (Object)this.m_severity).append("version", (Object)this.m_version).append("date", (Object)this.m_date).append("hostname", (Object)this.m_hostname).append("message ID", (Object)this.m_messageId).append("process name", (Object)this.m_processName).append("process ID", (Object)this.m_processId).append("message", (Object)this.m_message).toString();
    }
}

