/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd.helper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.scriptd.helper.AbstractEventForwarder;
import org.opennms.netmgt.scriptd.helper.DbHelper;
import org.opennms.netmgt.scriptd.helper.EventForwarder;
import org.opennms.netmgt.scriptd.helper.SnmpTrapHelper;
import org.opennms.netmgt.scriptd.helper.SnmpTrapHelperException;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3TrapBuilder;
import org.opennms.netmgt.xml.event.Event;

public abstract class SnmpTrapForwarderHelper
extends AbstractEventForwarder
implements EventForwarder {
    String source_ip;
    String ip;
    String community;
    int port;
    int timeout;
    int retries;
    int securityLevel;
    String securityname;
    String authPassPhrase;
    String authProtocol;
    String privPassPhrase;
    String privprotocol;
    SnmpTrapHelper snmpTrapHelper;

    public SnmpTrapHelper getSnmpTrapHelper() {
        return this.snmpTrapHelper;
    }

    public void setSnmpTrapHelper(SnmpTrapHelper snmpTrapHelper) {
        this.snmpTrapHelper = snmpTrapHelper;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public SnmpTrapForwarderHelper(String source_ip, String ip, int port, String community, SnmpTrapHelper snmpTrapHelper) {
        this.source_ip = source_ip;
        this.ip = ip;
        this.port = port;
        this.community = community;
        this.snmpTrapHelper = snmpTrapHelper;
    }

    public SnmpTrapForwarderHelper(String ip, int port, String community, SnmpTrapHelper snmpTrapHelper) {
        this.ip = ip;
        this.port = port;
        this.community = community;
        this.snmpTrapHelper = snmpTrapHelper;
    }

    public SnmpTrapForwarderHelper(String ip, int port, String community, int timeout, int retries, SnmpTrapHelper snmpTrapHelper) {
        this.ip = ip;
        this.port = port;
        this.community = community;
        this.snmpTrapHelper = snmpTrapHelper;
        this.timeout = timeout;
        this.retries = retries;
    }

    public SnmpTrapForwarderHelper(String ip, int port, int securityLevel, String securityname, String authPassPhrase, String authProtocol, String privPassPhrase, String privprotocol, SnmpTrapHelper snmpTrapHelper) {
        this.ip = ip;
        this.port = port;
        this.securityLevel = securityLevel;
        this.securityname = securityname;
        this.authPassPhrase = authPassPhrase;
        this.authProtocol = authProtocol;
        this.privPassPhrase = privPassPhrase;
        this.privprotocol = privprotocol;
        this.snmpTrapHelper = snmpTrapHelper;
    }

    public SnmpTrapForwarderHelper(String ip, int port, int securityLevel, String securityname, String authPassPhrase, String authProtocol, String privPassPhrase, String privprotocol, int timeout, int retries, SnmpTrapHelper snmpTrapHelper) {
        this.ip = ip;
        this.port = port;
        this.securityLevel = securityLevel;
        this.securityname = securityname;
        this.authPassPhrase = authPassPhrase;
        this.authProtocol = authProtocol;
        this.privPassPhrase = privPassPhrase;
        this.privprotocol = privprotocol;
        this.snmpTrapHelper = snmpTrapHelper;
        this.timeout = timeout;
        this.retries = retries;
    }

    public void sendV1StartSyncTrap() {
        try {
            SnmpV1TrapBuilder trap = this.snmpTrapHelper.createV1Trap(".1.3.6.1.4.1.5813.1", this.getSource_ip(), 6, 5, 0L);
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV1EndSyncTrap() {
        try {
            SnmpV1TrapBuilder trap = this.snmpTrapHelper.createV1Trap(".1.3.6.1.4.1.5813.1", this.getSource_ip(), 6, 6, 0L);
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2StartSyncTrap() {
        long trapTimeStamp = 0L;
        try {
            SnmpTrapBuilder trap = this.snmpTrapHelper.createV2Trap(".1.3.6.1.4.1.5813.1.5", Long.toString(trapTimeStamp));
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2EndSyncTrap() {
        long trapTimeStamp = 0L;
        try {
            SnmpTrapBuilder trap = this.snmpTrapHelper.createV2Trap(".1.3.6.1.4.1.5813.1.6", Long.toString(trapTimeStamp));
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2StartSyncInform() {
        long trapTimeStamp = 0L;
        try {
            SnmpV2TrapBuilder inform = this.snmpTrapHelper.createV2Inform(".1.3.6.1.4.1.5813.1.5", Long.toString(trapTimeStamp));
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2EndSyncInform() {
        long trapTimeStamp = 0L;
        try {
            SnmpV2TrapBuilder inform = this.snmpTrapHelper.createV2Inform(".1.3.6.1.4.1.5813.1.6", Long.toString(trapTimeStamp));
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3StartSyncTrap() {
        long trapTimeStamp = 0L;
        try {
            SnmpV3TrapBuilder trap = this.snmpTrapHelper.createV3Trap(".1.3.6.1.4.1.5813.1.5", Long.toString(trapTimeStamp));
            trap.send(this.getIp(), this.getPort(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3EndSyncTrap() {
        long trapTimeStamp = 0L;
        try {
            SnmpV3TrapBuilder trap = this.snmpTrapHelper.createV3Trap(".1.3.6.1.4.1.5813.1.6", Long.toString(trapTimeStamp));
            trap.send(this.getIp(), this.getPort(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3StartSyncInform() {
        long trapTimeStamp = 0L;
        try {
            SnmpV3TrapBuilder inform = this.snmpTrapHelper.createV3Inform(".1.3.6.1.4.1.5813.1.5", Long.toString(trapTimeStamp));
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3EndSyncInform() {
        long trapTimeStamp = 0L;
        try {
            SnmpV3TrapBuilder inform = this.snmpTrapHelper.createV3Inform(".1.3.6.1.4.1.5813.1.6", Long.toString(trapTimeStamp));
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV1AlarmTrap(Event event, boolean sync) throws UnknownHostException {
        SnmpV1TrapBuilder trap = this.snmpTrapHelper.createV1Trap(".1.3.6.1.4.1.5813.1", this.getSource_ip(), 6, 3, 0L);
        trap = this.buildAlarmTrap(event, sync, (SnmpTrapBuilder)trap);
        try {
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2AlarmTrap(Event event, boolean sync) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpTrapBuilder trap = this.snmpTrapHelper.createV2Trap(".1.3.6.1.4.1.5813.1.3", Long.toString(trapTimeStamp));
        trap = this.buildAlarmTrap(event, sync, trap);
        try {
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3AlarmTrap(Event event, boolean sync) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpV3TrapBuilder trap = this.snmpTrapHelper.createV3Trap(".1.3.6.1.4.1.5813.1.3", Long.toString(trapTimeStamp));
        SnmpV3TrapBuilder v3trap = trap = this.buildAlarmTrap(event, sync, (SnmpTrapBuilder)trap);
        try {
            v3trap.send(this.getIp(), this.getPort(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2AlarmInform(Event event, boolean sync) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpV2TrapBuilder trap = this.snmpTrapHelper.createV2Inform(".1.3.6.1.4.1.5813.1.3", Long.toString(trapTimeStamp));
        SnmpV2TrapBuilder inform = trap = this.buildAlarmTrap(event, sync, (SnmpTrapBuilder)trap);
        try {
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3AlarmInform(Event event, boolean sync) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpV3TrapBuilder trap = this.snmpTrapHelper.createV3Inform(".1.3.6.1.4.1.5813.1.3", Long.toString(trapTimeStamp));
        SnmpV3TrapBuilder inform = trap = this.buildAlarmTrap(event, sync, (SnmpTrapBuilder)trap);
        try {
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV1EventTrap(Event event) throws UnknownHostException {
        SnmpV1TrapBuilder trap = this.snmpTrapHelper.createV1Trap(".1.3.6.1.4.1.5813.1", this.getSource_ip(), 6, 1, 0L);
        trap = this.buildEventTrap(event, (SnmpTrapBuilder)trap, null);
        try {
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2EventTrap(Event event) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpTrapBuilder trap = this.snmpTrapHelper.createV2Trap(".1.3.6.1.4.1.5813.1.1", Long.toString(trapTimeStamp));
        trap = this.buildEventTrap(event, trap, null);
        try {
            trap.send(this.getIp(), this.getPort(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3EventTrap(Event event) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpV3TrapBuilder trap = this.snmpTrapHelper.createV3Trap(".1.3.6.1.4.1.5813.1.1", Long.toString(trapTimeStamp));
        SnmpV3TrapBuilder v3trap = trap = this.buildEventTrap(event, (SnmpTrapBuilder)trap, null);
        try {
            v3trap.send(this.getIp(), this.getPort(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV2EventInform(Event event) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpV2TrapBuilder trap = this.snmpTrapHelper.createV2Inform(".1.3.6.1.4.1.5813.1.1", Long.toString(trapTimeStamp));
        SnmpV2TrapBuilder inform = trap = this.buildEventTrap(event, (SnmpTrapBuilder)trap, null);
        try {
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getCommunity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendV3EventInform(Event event) throws UnknownHostException, SnmpTrapHelperException {
        long trapTimeStamp = 0L;
        SnmpV3TrapBuilder trap = this.snmpTrapHelper.createV3Inform(".1.3.6.1.4.1.5813.1.1", Long.toString(trapTimeStamp));
        SnmpV3TrapBuilder inform = trap = this.buildEventTrap(event, (SnmpTrapBuilder)trap, null);
        try {
            inform.sendInform(this.getIp(), this.getPort(), this.getTimeout(), this.getRetries(), this.getSecurityLevel(), this.getSecurityname(), this.getAuthPassPhrase(), this.getAuthProtocol(), this.getPrivPassPhrase(), this.getPrivprotocol());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SnmpTrapBuilder buildAlarmTrap(Event event, boolean sync, SnmpTrapBuilder trap) {
        try {
            if (event.getAlarmData() != null) {
                if (event.getAlarmData().getAlarmType() == 2) {
                    trap = this.buildEventTrap(event, trap, "Cleared");
                    this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.3.1.0", "OctetString", "text", event.getAlarmData().getClearKey());
                } else {
                    trap = this.buildEventTrap(event, trap, null);
                    this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.3.1.0", "OctetString", "text", event.getAlarmData().getReductionKey());
                }
            } else {
                trap = this.buildEventTrap(event, trap, null);
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.3.1.0", "OctetString", "text", "null");
            }
            if (sync) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.3.2.0", "OctetString", "text", "SYNC");
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.3.2.0", "OctetString", "text", "null");
            }
        }
        catch (SnmpTrapHelperException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trap;
    }

    private SnmpTrapBuilder buildEventTrap(Event event, SnmpTrapBuilder trap, String severity) {
        try {
            Integer t_dbid = new Integer(event.getDbid());
            if (t_dbid > 0) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.1.0", "OctetString", "text", t_dbid.toString());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.1.0", "OctetString", "text", "null");
            }
            if (event.getDistPoller() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.2.0", "OctetString", "text", event.getDistPoller());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.2.0", "OctetString", "text", "null");
            }
            if (event.getCreationTime() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.3.0", "OctetString", "text", event.getCreationTime());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.3.0", "OctetString", "text", "null");
            }
            if (event.getMasterStation() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.4.0", "OctetString", "text", event.getMasterStation());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.4.0", "OctetString", "text", "null");
            }
            if (event.getUei() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.6.0", "OctetString", "text", event.getUei());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.6.0", "OctetString", "text", "null");
            }
            if (event.getSource() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.7.0", "OctetString", "text", event.getSource());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.7.0", "OctetString", "text", "null");
            }
            String label = null;
            if (event.hasNodeid()) {
                label = DbHelper.getNodeLabel(new Integer(new Long(event.getNodeid()).toString()));
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.8.0", "OctetString", "text", new Long(event.getNodeid()).toString());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.8.0", "OctetString", "text", "null");
            }
            if (event.getTime() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.9.0", "OctetString", "text", event.getTime());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.9.0", "OctetString", "text", "null");
            }
            if (event.getHost() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.10.0", "OctetString", "text", event.getHost());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.10.0", "OctetString", "text", "null");
            }
            if (event.getInterface() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.11.0", "OctetString", "text", event.getInterface());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.11.0", "OctetString", "text", "null");
            }
            if (event.getSnmphost() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.12.0", "OctetString", "text", event.getSnmphost());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.12.0", "OctetString", "text", "null");
            }
            if (event.getService() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.13.0", "OctetString", "text", event.getService());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.13.0", "OctetString", "text", "null");
            }
            if (event.getDescr() != null) {
                String descrString = event.getDescr().replaceAll("&lt;.*&gt;", " ").replaceAll("\\s+", " ");
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.16.0", "OctetString", "text", descrString);
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.16.0", "OctetString", "text", "null");
            }
            if (event.getLogmsg() != null && event.getLogmsg().getContent() != null) {
                String logString = event.getLogmsg().getContent().replaceAll("&lt;.*&gt;", " ").replaceAll("\\s+", " ");
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.17.0", "OctetString", "text", logString);
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.17.0", "OctetString", "text", "null");
            }
            if (severity == null && event.getSeverity() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.18.0", "OctetString", "text", event.getSeverity());
            } else if (severity != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.18.0", "OctetString", "text", severity);
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.18.0", "OctetString", "text", "null");
            }
            if (event.getPathoutage() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.19.0", "OctetString", "text", event.getPathoutage());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.19.0", "OctetString", "text", "null");
            }
            if (event.getOperinstruct() != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.20.0", "OctetString", "text", event.getOperinstruct());
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.20.0", "OctetString", "text", "null");
            }
            String retParmVal = null;
            if (event.getInterface() != null) {
                retParmVal = event.getInterface();
                InetAddress inet = InetAddressUtils.addr((String)retParmVal);
                retParmVal = inet.getHostName();
            }
            if (retParmVal != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.21.0", "OctetString", "text", retParmVal);
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.21.0", "OctetString", "text", "null");
            }
            if (label != null) {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.22.0", "OctetString", "text", label);
            } else {
                this.snmpTrapHelper.addVarBinding(trap, ".1.3.6.1.4.1.5813.20.1.22.0", "OctetString", "text", "null");
            }
        }
        catch (IllegalArgumentException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Failed to look up host.", (Object[])new Object[0]);
        }
        catch (SnmpTrapHelperException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An SNMP trap helpre error occurred while parsing traps.", (Object[])new Object[0]);
        }
        catch (Throwable t) {
            LogUtils.warnf((Object)this, (Throwable)t, (String)"An unknown error occurred while parsing traps.", (Object[])new Object[0]);
        }
        return trap;
    }

    public String getSource_ip() {
        return this.source_ip;
    }

    public void setSource_ip(String source_ip) {
        this.source_ip = source_ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public String getSecurityname() {
        return this.securityname;
    }

    public void setSecurityname(String securityname) {
        this.securityname = securityname;
    }

    public String getAuthPassPhrase() {
        return this.authPassPhrase;
    }

    public void setAuthPassPhrase(String authPassPhrase) {
        this.authPassPhrase = authPassPhrase;
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.authProtocol = authProtocol;
    }

    public String getPrivPassPhrase() {
        return this.privPassPhrase;
    }

    public void setPrivPassPhrase(String privPassPhrase) {
        this.privPassPhrase = privPassPhrase;
    }

    public String getPrivprotocol() {
        return this.privprotocol;
    }

    public void setPrivprotocol(String privprotocol) {
        this.privprotocol = privprotocol;
    }
}

