/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.util.LinkedList;
import java.util.ListIterator;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.rtc.datablock.RTCNodeSvcTime;

public class RTCNodeSvcTimesList
extends LinkedList<RTCNodeSvcTime> {
    private static final long serialVersionUID = 2606739258065019820L;
    private long m_outTimeSince = -1L;
    private long m_outTime = 0L;

    private void removeExpiredOutages() {
        long curTime = System.currentTimeMillis();
        long rollingWindow = RTCConfigFactory.getInstance().getRollingWindow();
        this.removeExpiredOutages(curTime, rollingWindow);
    }

    private void removeExpiredOutages(long curTime, long rollingWindow) {
        RTCNodeSvcTime svcTime;
        long startTime = curTime - rollingWindow;
        ListIterator iter = this.listIterator();
        while (iter.hasNext() && (svcTime = (RTCNodeSvcTime)iter.next()).getLostTime() < startTime) {
            if (!svcTime.hasExpired(startTime)) continue;
            iter.remove();
        }
    }

    public void addSvcTime(long losttime, long regainedtime) {
        this.removeExpiredOutages();
        if (regainedtime > 0L && regainedtime < losttime) {
            ThreadCategory log = ThreadCategory.getInstance(this.getClass());
            log.warn("RTCNodeSvcTimesList: Rejecting service time pair since regained time less than lost time -> losttime in milliseconds: " + losttime + "\tregainedtime in milliseconds: " + regainedtime);
            return;
        }
        this.addLast(new RTCNodeSvcTime(losttime, regainedtime));
    }

    public void addSvcTime(long losttime) {
        this.removeExpiredOutages();
        this.addLast(new RTCNodeSvcTime(losttime));
    }

    public long getDownTime(long curTime, long rollingWindow) {
        long startTime = curTime - rollingWindow;
        if (this.m_outTimeSince == startTime) {
            return this.m_outTime;
        }
        this.m_outTimeSince = startTime;
        this.m_outTime = 0L;
        this.removeExpiredOutages(curTime, rollingWindow);
        for (RTCNodeSvcTime svcTime : this) {
            this.m_outTime += svcTime.getDownTime(curTime, rollingWindow);
        }
        return this.m_outTime;
    }
}

