/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;

public class XMPPNotificationManager {
    private final Properties props = new Properties();
    private static final String LOG4J_CATEGORY = "OpenNMS.Notifd";
    private static final String XMPP_RESOURCE = "notifd";
    private static final String TRUST_STORE_PASSWORD = "changeit";
    private static final String XMPP_PORT = "5222";
    private final XMPPConnection xmpp;
    private final ConnectionConfiguration xmppConfig;
    private final String xmppServer;
    private final String xmppServiceName;
    private final String xmppUser;
    private final String xmppPassword;
    private final int xmppPort;
    private final HashMap<String, MultiUserChat> rooms = new HashMap();
    private static XMPPNotificationManager instance = null;
    private ConnectionListener conlistener = new ConnectionListener(){

        public void connectionClosed() {
            XMPPNotificationManager.this.log().debug("XMPP connection closed");
        }

        public void connectionClosedOnError(Exception e) {
            XMPPNotificationManager.this.log().warn("XMPP connection closed", (Throwable)e);
        }

        public void reconnectingIn(int seconds) {
            if (XMPPNotificationManager.this.log().isDebugEnabled()) {
                XMPPNotificationManager.this.log().debug("XMPP reconnecting in " + seconds + " seconds");
            }
        }

        public void reconnectionFailed(Exception e) {
            XMPPNotificationManager.this.log().warn("XMPP reconnection failed", (Throwable)e);
            XMPPNotificationManager.this.xmpp.disconnect();
            instance = null;
        }

        public void reconnectionSuccessful() {
            XMPPNotificationManager.this.log().debug("XMPP reconnection succeeded");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected XMPPNotificationManager() {
        String oldPrefix = ThreadCategory.getPrefix();
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        try {
            block20: {
                FileInputStream fis;
                File config = null;
                try {
                    config = ConfigFileConstants.getFile((int)ConfigFileConstants.XMPP_CONFIG_FILE_NAME);
                }
                catch (IOException e) {
                    this.log().warn(ConfigFileConstants.XMPP_CONFIG_FILE_NAME + " not readable", (Throwable)e);
                }
                if (Boolean.getBoolean("useSystemXMPPConfig") || !config.canRead()) {
                    this.props.putAll((Map<?, ?>)System.getProperties());
                } else {
                    fis = null;
                    fis = new FileInputStream(config);
                    this.props.load(fis);
                    IOUtils.closeQuietly((InputStream)fis);
                }
                break block20;
                catch (FileNotFoundException e) {
                    this.log().warn("unable to load " + config, (Throwable)e);
                    IOUtils.closeQuietly((InputStream)fis);
                }
                catch (IOException e2) {
                    this.log().warn("unable to load " + config, (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fis);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
            }
            this.xmppServer = this.props.getProperty("xmpp.server");
            this.xmppServiceName = this.props.getProperty("xmpp.servicename", this.xmppServer);
            this.xmppUser = this.props.getProperty("xmpp.user");
            this.xmppPassword = this.props.getProperty("xmpp.pass");
            this.xmppPort = Integer.valueOf(this.props.getProperty("xmpp.port", XMPP_PORT));
            this.xmppConfig = new ConnectionConfiguration(this.xmppServer, this.xmppPort, this.xmppServiceName);
            boolean debuggerEnabled = Boolean.parseBoolean(this.props.getProperty("xmpp.debuggerEnabled"));
            this.xmppConfig.setDebuggerEnabled(debuggerEnabled);
            if (debuggerEnabled) {
                this.log().setLevel(ThreadCategory.Level.DEBUG);
            }
            this.xmppConfig.setSASLAuthenticationEnabled(Boolean.parseBoolean(this.props.getProperty("xmpp.SASLEnabled", "true")));
            this.xmppConfig.setSelfSignedCertificateEnabled(Boolean.parseBoolean(this.props.getProperty("xmpp.selfSignedCertificateEnabled")));
            if (Boolean.parseBoolean(this.props.getProperty("xmpp.TLSEnabled"))) {
                this.xmppConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
            } else {
                this.xmppConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
            }
            if (this.props.containsKey("xmpp.truststorePassword")) {
                this.xmppConfig.setTruststorePassword(this.props.getProperty("xmpp.truststorePassword"));
            } else {
                this.xmppConfig.setTruststorePassword(TRUST_STORE_PASSWORD);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("XMPP Manager connection config: " + this.xmppConfig.toString());
            }
            this.xmpp = new XMPPConnection(this.xmppConfig);
            this.connectToServer();
        }
        finally {
            ThreadCategory.setPrefix((String)oldPrefix);
        }
    }

    private void connectToServer() {
        try {
            this.log().debug("Attempting vanilla XMPP Connection to " + this.xmppServer + ":" + this.xmppPort);
            this.xmpp.connect();
            if (this.xmpp.isConnected()) {
                this.log().debug("XMPP Manager successfully connected");
                if (this.xmpp.isSecureConnection()) {
                    this.log().debug("XMPP Manager successfully nogotiated a secure connection");
                }
                if (this.xmpp.isUsingTLS()) {
                    this.log().debug("XMPP Manager successfully nogotiated a TLS connection");
                }
                this.log().debug("XMPP Manager Connected");
                this.login();
                this.xmpp.addConnectionListener(this.conlistener);
            } else {
                this.log().debug("XMPP Manager Not Connected");
            }
        }
        catch (Throwable e) {
            this.log().fatal("XMPP Manager unable to connect", e);
        }
    }

    private void login() {
        try {
            if (this.xmpp.isConnected()) {
                this.log().debug("XMPP Manager logging in");
                this.xmpp.login(this.xmppUser, this.xmppPassword, XMPP_RESOURCE);
                this.rooms.clear();
            } else {
                this.log().debug("XMPP Manager unable to login: Not connected to XMPP server");
            }
        }
        catch (Throwable e) {
            this.log().fatal("XMPP Manager unable to login: ", e);
        }
    }

    public static synchronized XMPPNotificationManager getInstance() {
        if (instance == null) {
            instance = new XMPPNotificationManager();
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.xmpp.isAuthenticated();
    }

    public boolean sendMessage(String xmppTo, String xmppMessage) {
        if (!this.isLoggedIn()) {
            this.connectToServer();
        }
        try {
            ChatManager cm = this.xmpp.getChatManager();
            cm.createChat(xmppTo, (MessageListener)new NullMessageListener()).sendMessage(xmppMessage);
            this.log().debug("XMPP Manager sent message to: " + xmppTo);
        }
        catch (XMPPException e) {
            this.log().fatal("XMPP Exception Sending message ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean sendGroupChat(String xmppChatRoom, String xmppMessage) {
        MultiUserChat groupChat;
        if (this.rooms.containsKey(xmppChatRoom)) {
            groupChat = this.rooms.get(xmppChatRoom);
        } else {
            this.log().debug("Adding room: " + xmppChatRoom);
            groupChat = new MultiUserChat(this.xmpp, xmppChatRoom);
            this.rooms.put(xmppChatRoom, groupChat);
        }
        if (!groupChat.isJoined()) {
            this.log().debug("Joining room: " + xmppChatRoom);
            try {
                groupChat.join(this.xmppUser);
            }
            catch (XMPPException e) {
                this.log().fatal("XMPP Exception joining chat room ", (Throwable)e);
                return false;
            }
        }
        try {
            groupChat.sendMessage(xmppMessage);
            this.log().debug("XMPP Manager sent message to: " + xmppChatRoom);
        }
        catch (XMPPException e) {
            this.log().fatal("XMPP Exception sending message to Chat room", (Throwable)e);
            return false;
        }
        return true;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private static class NullMessageListener
    implements MessageListener {
        private NullMessageListener() {
        }

        public void processMessage(Chat chat, Message message) {
        }
    }
}

