/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.netmgt.notifd.MicroblogNotificationStrategy;
import org.springframework.core.io.Resource;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class MicroblogReplyNotificationStrategy
extends MicroblogNotificationStrategy {
    public MicroblogReplyNotificationStrategy() throws IOException {
    }

    public MicroblogReplyNotificationStrategy(Resource configResource) {
        super(configResource);
    }

    @Override
    public int send(List<Argument> arguments) {
        Status response;
        Twitter svc = this.buildUblogService(arguments);
        String destUser = this.findDestName(arguments);
        if (destUser == null || "".equals(destUser)) {
            this.log().error("Cannot send a microblog reply notice to a user with no microblog username set. Either set a microblog username for this OpenNMS user or use the MicroblogUpdateNotificationStrategy instead.");
            return 1;
        }
        if (destUser.startsWith("@")) {
            destUser = destUser.substring(1);
        }
        String fullMessage = String.format("@%s %s", destUser, this.buildMessageBody(arguments));
        if (this.log().isDebugEnabled()) {
            this.log().debug("Dispatching microblog reply notification for user '" + svc.getUserId() + "' at base URL '" + svc.getBaseURL() + "' with message '" + fullMessage + "'");
        }
        try {
            response = svc.updateStatus(fullMessage);
        }
        catch (TwitterException e) {
            this.log().error("Microblog notification failed");
            this.log().info("Failed to update status for user '" + svc.getUserId() + "' at service URL '" + svc.getBaseURL() + "', caught exception: " + e.getMessage());
            return 1;
        }
        this.log().info("Microblog reply notification succeeded: reply update posted with ID " + response.getId());
        return 0;
    }
}

