/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AtInterfaceDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.linkd.AbstractQueryManager;
import org.opennms.netmgt.linkd.DbDataLinkInterfaceEntry;
import org.opennms.netmgt.linkd.DbIpRouteInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpNodeEntry;
import org.opennms.netmgt.linkd.DbVlanEntry;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.OnmsVlan;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbEventWriter
extends AbstractQueryManager {
    private JdbcTemplate jdbcTemplate;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private AtInterfaceDao m_atInterfaceDao;
    private static final String SQL_SELECT_SNMP_NODE = "SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_GET_NODEID = "SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID__IFINDEX_MASK = "SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid LEFT JOIN snmpinterface ON ipinterface.snmpinterfaceid = snmpinterface.id WHERE node.nodetype = 'A' AND ipinterface.ipaddr = ?";
    private static final String SQL_UPDATE_DATALINKINTERFACE = "UPDATE datalinkinterface set status = 'N'  WHERE lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE = "UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE = "UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPNODE = "UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPINTERFACE = "UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_VLAN = "UPDATE vlan set status = 'N'  WHERE nodeid =? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS = "UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_STATUS = "UPDATE iprouteinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPNODE_STATUS = "UPDATE stpnode set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPINTERFACE_STATUS = "UPDATE stpinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_VLAN_STATUS = "UPDATE vlan set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_DATALINKINTERFACE_STATUS = "UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? ";
    private static final String SQL_GET_NODEID_IFINDEX = "SELECT atinterface.nodeid, atinterface.ipaddr, ipinterface.ifindex from atinterface left JOIN ipinterface ON atinterface.nodeid = ipinterface.nodeid AND atinterface.ipaddr = ipinterface.ipaddr WHERE atphysaddr = ? AND atinterface.status <> 'D'";
    private static final String SQL_GET_SNMPIFTYPE = "SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ?";
    private static final String SQL_GET_IFINDEX_SNMPINTERFACE_NAME = "SELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) ";
    private static final String SQL_SELECT_SNMP_NODES = "SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_UPDATE_VLAN_D = "UPDATE vlan set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_ATINTERFACE_D = "UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_STPNODE_D = "UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_STPINTERFACE_D = "UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_D = "UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_DATALINKINTERFACE_D = "UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'";

    private Connection getConnection() throws SQLException {
        return this.jdbcTemplate.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDiscoveryLink(DiscoveryLink discovery) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            int i;
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            PreparedStatement stmt = null;
            ResultSet rs = null;
            NodeToNodeLink[] links = discovery.getLinks();
            LogUtils.debugf((Object)this, (String)"storelink: Storing %d NodeToNodeLink information into database", (Object[])new Object[]{links.length});
            for (NodeToNodeLink lk : discovery.getLinks()) {
                int nodeid = lk.getNodeId();
                int ifindex = lk.getIfindex();
                int nodeparentid = lk.getNodeparentid();
                int parentifindex = lk.getParentifindex();
                DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
                if (dbentry == null) {
                    dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
                }
                dbentry.updateNodeParentId(nodeparentid);
                dbentry.updateParentIfIndex(parentifindex);
                dbentry.updateStatus('A');
                dbentry.set_lastpolltime(now);
                dbentry.store(dbConn);
                dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeparentid, parentifindex);
                if (dbentry == null || dbentry.get_nodeparentid() != nodeid || dbentry.get_parentifindex() != ifindex || dbentry.get_status() == 'D') continue;
                dbentry.updateStatus('D');
                dbentry.store(dbConn);
            }
            MacToNodeLink[] linkmacs = discovery.getMacLinks();
            LogUtils.debugf((Object)this, (String)("storelink: Storing " + linkmacs.length + " MacToNodeLink information into database"), (Object[])new Object[0]);
            for (i = 0; i < linkmacs.length; ++i) {
                MacToNodeLink lkm = linkmacs[i];
                String macaddr = lkm.getMacAddress();
                LogUtils.debugf((Object)this, (String)("storelink: finding nodeid,ifindex on DB using MAC address: " + macaddr), (Object[])new Object[0]);
                stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX);
                d.watch((Object)stmt);
                stmt.setString(1, macaddr);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                LogUtils.debugf((Object)this, (String)("storelink: finding nodeid,ifindex on DB, SQL statement: SELECT atinterface.nodeid, atinterface.ipaddr, ipinterface.ifindex from atinterface left JOIN ipinterface ON atinterface.nodeid = ipinterface.nodeid AND atinterface.ipaddr = ipinterface.ipaddr WHERE atphysaddr = ? AND atinterface.status <> 'D' with MAC address " + macaddr), (Object[])new Object[0]);
                if (!rs.next()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no nodeid found on DB for MAC address " + macaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                int ndx = 1;
                int nodeid = rs.getInt(ndx++);
                if (rs.wasNull()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no nodeid found on DB for MAC address " + macaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                String ipaddrString = rs.getString(ndx++);
                if (rs.wasNull()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no ipaddr found on DB for MAC address " + macaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                InetAddress ipaddr = InetAddressUtils.addr((String)ipaddrString);
                if (!this.m_linkd.isInterfaceInPackage(ipaddr, discovery.getPackageName())) {
                    LogUtils.debugf((Object)this, (String)("storelink: not in package ipaddr found: " + ipaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                int ifindex = rs.getInt(ndx++);
                if (rs.wasNull()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no ifindex found on DB for MAC address " + macaddr + " on link."), (Object[])new Object[0]);
                    ifindex = -1;
                }
                int nodeparentid = lkm.getNodeparentid();
                int parentifindex = lkm.getParentifindex();
                DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
                if (dbentry == null) {
                    dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
                }
                dbentry.updateNodeParentId(nodeparentid);
                dbentry.updateParentIfIndex(parentifindex);
                dbentry.updateStatus('A');
                dbentry.set_lastpolltime(now);
                dbentry.store(dbConn);
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE);
            d.watch((Object)stmt);
            stmt.setTimestamp(1, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("storelink: datalinkinterface - updated to NOT ACTIVE status " + i + " rows "), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkableNode storeSnmpCollection(LinkableNode node, SnmpCollection snmpcoll) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            Timestamp scanTime = new Timestamp(System.currentTimeMillis());
            if (snmpcoll.hasIpNetToMediaTable()) {
                this.processIpNetToMediaTable(node, snmpcoll, dbConn, scanTime);
            }
            if (snmpcoll.hasCdpCacheTable()) {
                this.processCdpCacheTable(node, snmpcoll, dbConn, scanTime);
            }
            if (snmpcoll.hasRouteTable()) {
                this.processRouteTable(node, snmpcoll, dbConn, scanTime);
            }
            if (snmpcoll.hasVlanTable()) {
                this.processVlanTable(node, snmpcoll, dbConn, scanTime);
            }
            LogUtils.debugf((Object)this, (String)"store: saving SnmpVlanCollection's in DB", (Object[])new Object[0]);
            for (OnmsVlan vlan : snmpcoll.getSnmpVlanCollections().keySet()) {
                LogUtils.debugf((Object)this, (String)"store: parsing VLAN %s/%s", (Object[])new Object[]{vlan.getVlanId(), vlan.getVlanName()});
                SnmpVlanCollection snmpVlanColl = snmpcoll.getSnmpVlanCollections().get(vlan);
                if (!snmpVlanColl.hasDot1dBase()) continue;
                this.processDot1DBase(node, snmpcoll, d, dbConn, scanTime, vlan, snmpVlanColl);
            }
            this.markOldDataInactive(dbConn, scanTime, node.getNodeId());
            LinkableNode linkableNode = node;
            return linkableNode;
        }
        catch (Throwable e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception while storing SNMP collections: %s", (Object[])new Object[]{e.getMessage()});
            LinkableNode linkableNode = null;
            return linkableNode;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void markOldDataInactive(Connection dbConn, Timestamp now, int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            int i = 0;
            stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_VLAN);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE vlan set status = 'N'  WHERE nodeid =? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int nodeid, char status) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            PreparedStatement stmt = null;
            int i = 0;
            stmt = dbConn.prepareStatement(SQL_UPDATE_VLAN_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE vlan set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            stmt.setInt(3, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE iprouteinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE stpnode set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE stpinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            stmt.setInt(3, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getNodeidFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        int nodeid = -1;
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            d.watch((Object)stmt);
            stmt.setString(1, hostAddress);
            LogUtils.debugf((Object)this, (String)("getNodeidFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with IP address=" + hostAddress), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getNodeidFromIp: no entries found in ipinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ndx = 1;
            nodeid = rs.getInt(ndx++);
            if (rs.wasNull()) {
                nodeid = -1;
            }
            LogUtils.debugf((Object)this, (String)("getNodeidFromIp: found nodeid " + nodeid), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
        return nodeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RouterInterface getNodeidMaskFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        if (ipaddr.isLoopbackAddress() || hostAddress.equals("0.0.0.0")) {
            return null;
        }
        int nodeid = -1;
        int ifindex = -1;
        String netmask = null;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID__IFINDEX_MASK);
            d.watch((Object)stmt);
            stmt.setString(1, hostAddress);
            LogUtils.debugf((Object)this, (String)("getNodeidMaskFromIp: executing query SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid LEFT JOIN snmpinterface ON ipinterface.snmpinterfaceid = snmpinterface.id WHERE node.nodetype = 'A' AND ipinterface.ipaddr = ? with IP address=" + hostAddress), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no entries found in snmpinterface", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            nodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no nodeid found", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            ifindex = rs.getInt("snmpifindex");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no snmpifindex found", (Object[])new Object[0]);
                ifindex = -1;
            }
            netmask = rs.getString("snmpipadentnetmask");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no snmpipadentnetmask found", (Object[])new Object[0]);
                netmask = "255.255.255.255";
            }
        }
        finally {
            d.cleanUp();
        }
        RouterInterface ri = new RouterInterface(nodeid, ifindex, InetAddressUtils.addr((String)netmask));
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RouterInterface getNodeFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        if (ipaddr.isLoopbackAddress() || hostAddress.equals("0.0.0.0")) {
            return null;
        }
        int nodeid = -1;
        int ifindex = -1;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            d.watch((Object)stmt);
            stmt.setString(1, hostAddress);
            LogUtils.debugf((Object)this, (String)("getNodeFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with IP address=" + hostAddress), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getNodeFromIp: no entries found in snmpinterface", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            nodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeFromIp: no nodeid found", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
        }
        finally {
            d.cleanUp();
        }
        RouterInterface ri = new RouterInterface(nodeid, ifindex);
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getSnmpIfType(Connection dbConn, int nodeid, Integer ifindex) throws SQLException {
        int snmpiftype = -1;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_SNMPIFTYPE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setInt(2, ifindex == null ? 0 : ifindex);
            LogUtils.debugf((Object)this, (String)("getSnmpIfType: executing query SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ? with nodeid=" + nodeid + " and ifindex=" + ifindex), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getSnmpIfType: no entries found in snmpinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ndx = 1;
            snmpiftype = rs.getInt(ndx++);
            if (rs.wasNull()) {
                snmpiftype = -1;
            }
            LogUtils.debugf((Object)this, (String)("getSnmpIfType: found in snmpinterface snmpiftype=" + snmpiftype), (Object[])new Object[0]);
            int n = snmpiftype;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getIfIndexByName(Connection dbConn, int nodeid, String ifName) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            stmt = dbConn.prepareStatement(SQL_GET_IFINDEX_SNMPINTERFACE_NAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setString(2, ifName);
            stmt.setString(3, ifName);
            LogUtils.debugf((Object)this, (String)("getIfIndexByName: executing querySELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) nodeid =" + nodeid + "and ifName=" + ifName), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getIfIndexByName: no entries found in snmpinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ndx = 1;
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getIfIndexByName: no entries found in snmpinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ifindex = rs.getInt(ndx++);
            LogUtils.debugf((Object)this, (String)("getIfIndexByName: found ifindex=" + ifindex), (Object[])new Object[0]);
            int n = ifindex;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkableNode getSnmpNode(int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            LinkableNode node = null;
            PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_NODE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            LogUtils.debugf((Object)this, (String)("getSnmpCollection: execute 'SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'' with nodeid = " + nodeid), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                String sysoid = rs.getString("nodesysoid");
                if (sysoid == null) {
                    sysoid = "-1";
                }
                String ipaddr = rs.getString("ipaddr");
                LogUtils.debugf((Object)this, (String)("getSnmpCollection: found nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid), (Object[])new Object[0]);
                node = new LinkableNode(nodeid, InetAddressUtils.addr((String)ipaddr), sysoid);
            }
            LinkableNode linkableNode = node;
            return linkableNode;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LinkableNode> getSnmpNodeList() throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            ArrayList<LinkableNode> linknodes = new ArrayList<LinkableNode>();
            PreparedStatement ps = dbConn.prepareStatement(SQL_SELECT_SNMP_NODES);
            d.watch((Object)ps);
            ResultSet rs = ps.executeQuery();
            d.watch((Object)rs);
            LogUtils.debugf((Object)this, (String)"getNodesInfo: execute query: \" SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'\"", (Object[])new Object[0]);
            while (rs.next()) {
                int nodeid = rs.getInt("nodeid");
                String ipaddr = rs.getString("ipaddr");
                String sysoid = rs.getString("nodesysoid");
                if (sysoid == null) {
                    sysoid = "-1";
                }
                LogUtils.debugf((Object)this, (String)("getNodesInfo: found node element: nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid), (Object[])new Object[0]);
                LinkableNode node = new LinkableNode(nodeid, InetAddressUtils.addr((String)ipaddr), sysoid);
                linknodes.add(node);
            }
            LogUtils.debugf((Object)this, (String)("getNodesInfo: found " + linknodes.size() + " SNMP primary IP nodes"), (Object[])new Object[0]);
            ArrayList<LinkableNode> arrayList = linknodes;
            return arrayList;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeletedNodes() throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            int i = 0;
            PreparedStatement ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_VLAN_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE vlan set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_STPNODE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D''updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'' updated rows: " + i), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForInterface(int nodeId, String ipAddr, int ifIndex, char status) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            PreparedStatement ps = null;
            int i = 0;
            if (!EventUtils.isNonIpInterface(ipAddr)) {
                ps = dbConn.prepareStatement("UPDATE atinterface set status = ?  WHERE nodeid = ? AND ipaddr = ?");
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setString(3, ipAddr);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: atinterface: node = " + nodeId + ", IP Address = " + ipAddr + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
            }
            if (ifIndex > -1) {
                ps = dbConn.prepareStatement("UPDATE atinterface set status = ?  WHERE sourcenodeid = ? AND ifindex = ?");
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: atinterface: source node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
                ps = dbConn.prepareStatement("UPDATE stpinterface set status = ? WHERE nodeid = ? AND ifindex = ?");
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: stpinterface: node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
                ps = dbConn.prepareStatement("UPDATE iprouteinterface set status = ? WHERE nodeid = ? AND routeifindex = ?");
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: iprouteinterface: node = " + nodeId + ", rpouteIfIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
                ps = dbConn.prepareStatement("UPDATE datalinkinterface set status = ? WHERE (nodeid = ? and ifindex = ?) OR (nodeparentid = ? AND parentifindex = ?)");
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                ps.setInt(4, nodeId);
                ps.setInt(5, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: datalinkinterface: node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    @Override
    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    @Override
    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao dao) {
        this.m_ipInterfaceDao = dao;
    }

    @Override
    public AtInterfaceDao getAtInterfaceDao() {
        return this.m_atInterfaceDao;
    }

    public void setAtInterfaceDao(AtInterfaceDao dao) {
        this.m_atInterfaceDao = dao;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    protected void saveIpRouteInterface(Connection dbConn, OnmsIpRouteInterface ipRouteInterface) throws SQLException {
        DbIpRouteInterfaceEntry iprouteInterfaceEntry = DbIpRouteInterfaceEntry.get(dbConn, ipRouteInterface.getNode().getId(), ipRouteInterface.getRouteDest());
        if (iprouteInterfaceEntry == null) {
            iprouteInterfaceEntry = DbIpRouteInterfaceEntry.create(ipRouteInterface.getNode().getId(), ipRouteInterface.getRouteDest());
        }
        iprouteInterfaceEntry.updateRouteMask(ipRouteInterface.getRouteMask());
        iprouteInterfaceEntry.updateRouteNextHop(ipRouteInterface.getRouteNextHop());
        iprouteInterfaceEntry.updateIfIndex(ipRouteInterface.getRouteIfIndex());
        if (ipRouteInterface.getRouteMetric1() != null) {
            iprouteInterfaceEntry.updateRouteMetric1(ipRouteInterface.getRouteMetric1());
        }
        if (ipRouteInterface.getRouteMetric2() != null) {
            iprouteInterfaceEntry.updateRouteMetric2(ipRouteInterface.getRouteMetric2());
        }
        if (ipRouteInterface.getRouteMetric3() != null) {
            iprouteInterfaceEntry.updateRouteMetric3(ipRouteInterface.getRouteMetric3());
        }
        if (ipRouteInterface.getRouteMetric4() != null) {
            iprouteInterfaceEntry.updateRouteMetric4(ipRouteInterface.getRouteMetric4());
        }
        if (ipRouteInterface.getRouteMetric5() != null) {
            iprouteInterfaceEntry.updateRouteMetric5(ipRouteInterface.getRouteMetric5());
        }
        if (ipRouteInterface.getRouteType() != null) {
            iprouteInterfaceEntry.updateRouteType(ipRouteInterface.getRouteType());
        }
        if (ipRouteInterface.getRouteProto() != null) {
            iprouteInterfaceEntry.updateRouteProto(ipRouteInterface.getRouteProto());
        }
        iprouteInterfaceEntry.updateStatus('A');
        iprouteInterfaceEntry.set_lastpolltime(ipRouteInterface.getLastPollTime());
        iprouteInterfaceEntry.store(dbConn);
    }

    @Override
    protected void saveVlan(Connection dbConn, OnmsVlan vlan) throws SQLException {
        DbVlanEntry vlanEntry = DbVlanEntry.get(dbConn, vlan.getNode().getId(), vlan.getVlanId());
        if (vlanEntry == null) {
            vlanEntry = DbVlanEntry.create(vlan.getNode().getId(), vlan.getVlanId());
        }
        if (vlan.getVlanType() != null) {
            vlanEntry.updateVlanType(vlan.getVlanType());
        }
        if (vlan.getVlanStatus() != null) {
            vlanEntry.updateVlanStatus(vlan.getVlanStatus());
        }
        vlanEntry.updateVlanName(vlan.getVlanName());
        vlanEntry.updateStatus(vlan.getStatus().charValue());
        vlanEntry.set_lastpolltime(vlan.getLastPollTime());
        vlanEntry.store(dbConn);
    }

    @Override
    protected void saveStpNode(Connection dbConn, OnmsStpNode stpNode) throws SQLException {
        DbStpNodeEntry dbStpNodeEntry = DbStpNodeEntry.get(dbConn, stpNode.getNode().getId(), stpNode.getBaseVlan());
        if (dbStpNodeEntry == null) {
            dbStpNodeEntry = DbStpNodeEntry.create(stpNode.getNode().getId(), stpNode.getBaseVlan());
        }
        dbStpNodeEntry.updateBaseBridgeAddress(stpNode.getBaseBridgeAddress());
        dbStpNodeEntry.updateBaseNumPorts(stpNode.getBaseNumPorts());
        dbStpNodeEntry.updateBaseType(stpNode.getBaseType());
        dbStpNodeEntry.updateBaseVlanName(stpNode.getBaseVlanName());
        dbStpNodeEntry.updateStpProtocolSpecification(stpNode.getStpProtocolSpecification());
        dbStpNodeEntry.updateStpPriority(stpNode.getStpPriority());
        dbStpNodeEntry.updateStpRootCost(stpNode.getStpRootCost());
        dbStpNodeEntry.updateStpRootPort(stpNode.getStpRootPort());
        dbStpNodeEntry.updateStpDesignatedRoot(stpNode.getStpDesignatedRoot());
        dbStpNodeEntry.updateStatus(stpNode.getStatus().charValue());
        dbStpNodeEntry.set_lastpolltime(stpNode.getLastPollTime());
        dbStpNodeEntry.store(dbConn);
    }

    @Override
    protected void saveStpInterface(Connection dbConn, OnmsStpInterface stpInterface) throws SQLException {
        DbStpInterfaceEntry dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, stpInterface.getNode().getId(), stpInterface.getBridgePort(), stpInterface.getVlan());
        if (dbStpIntEntry == null) {
            dbStpIntEntry = DbStpInterfaceEntry.create(stpInterface.getNode().getId(), stpInterface.getBridgePort(), stpInterface.getVlan());
        }
        if (stpInterface.getIfIndex() != null) {
            dbStpIntEntry.updateIfIndex(stpInterface.getIfIndex());
        }
        dbStpIntEntry.updateStpportDesignatedBridge(stpInterface.getStpPortDesignatedBridge());
        dbStpIntEntry.updateStpPortDesignatedCost(stpInterface.getStpPortDesignatedCost());
        dbStpIntEntry.updateStpportDesignatedPort(stpInterface.getStpPortDesignatedPort());
        dbStpIntEntry.updateStpportDesignatedRoot(stpInterface.getStpPortDesignatedRoot());
        dbStpIntEntry.updateStpPortPathCost(stpInterface.getStpPortPathCost());
        dbStpIntEntry.updateStpPortState(stpInterface.getStpPortState());
        dbStpIntEntry.updateStatus(stpInterface.getStatus().charValue());
        dbStpIntEntry.set_lastpolltime(stpInterface.getLastPollTime());
        dbStpIntEntry.store(dbConn);
    }

    @Override
    protected List<String> getPhysAddrs(int nodeId, DBUtils d, Connection dbConn) throws SQLException {
        ArrayList<String> physaddrs = new ArrayList<String>();
        PreparedStatement stmt = dbConn.prepareStatement("SELECT snmpphysaddr FROM snmpinterface WHERE nodeid = ? AND  snmpphysaddr <> ''");
        d.watch((Object)stmt);
        stmt.setInt(1, nodeId);
        ResultSet rs = stmt.executeQuery();
        d.watch((Object)rs);
        while (rs.next()) {
            String macaddr = rs.getString("snmpphysaddr");
            if (macaddr == null) continue;
            physaddrs.add(macaddr);
            LogUtils.debugf((Object)this, (String)("setBridgeIdentifierFromSnmpInterface: found bridge identifier " + macaddr + " from snmpinterface db table"), (Object[])new Object[0]);
        }
        return physaddrs;
    }
}

