/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.springframework.dao.DataAccessException;

final class UdpUuidSender
implements Runnable {
    private List<UdpReceivedEvent> m_eventUuidsOut;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context = null;
    private List<EventHandler> m_handlers;
    private String m_logPrefix;

    UdpUuidSender(DatagramSocket sock, List<UdpReceivedEvent> uuidsOut, List<EventHandler> handlers) {
        this.m_dgSock = sock;
        this.m_stop = false;
        this.m_eventUuidsOut = uuidsOut;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Stopping and joining thread context " + this.m_context.getName());
            }
            this.m_context.interrupt();
            this.m_context.join();
            this.log().debug("Thread context stopped and joined");
        }
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        boolean isTracing = this.log().isDebugEnabled();
        if (this.m_stop) {
            this.log().debug("Stop flag set before thread started, exiting");
            return;
        }
        this.log().debug("Thread context started");
        ArrayList<UdpReceivedEvent> eventHold = new ArrayList<UdpReceivedEvent>(30);
        HashMap<UdpReceivedEvent, EventReceipt> receipts = new HashMap<UdpReceivedEvent, EventReceipt>();
        block15: while (!this.m_stop) {
            this.log().debug("Waiting on event receipts to be generated");
            List<UdpReceivedEvent> list = this.m_eventUuidsOut;
            synchronized (list) {
                while (this.m_eventUuidsOut.isEmpty()) {
                    try {
                        this.m_eventUuidsOut.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.log().debug("Thread context interrupted");
                        break block15;
                    }
                }
                eventHold.addAll(this.m_eventUuidsOut);
                this.m_eventUuidsOut.clear();
            }
            if (isTracing) {
                this.log().debug("Received " + eventHold.size() + " event receipts to process");
                this.log().debug("Processing receipts");
            }
            for (UdpReceivedEvent udpReceivedEvent : eventHold) {
                for (Event e : udpReceivedEvent.getAckedEvents()) {
                    if (e.getUuid() == null) continue;
                    EventReceipt receipt = (EventReceipt)receipts.get(udpReceivedEvent);
                    if (receipt == null) {
                        receipt = new EventReceipt();
                        receipts.put(udpReceivedEvent, receipt);
                    }
                    receipt.addUuid(e.getUuid());
                }
            }
            eventHold.clear();
            this.log().debug("Event receipts sorted, transmitting receipts");
            for (Map.Entry entry : receipts.entrySet()) {
                UdpReceivedEvent re = (UdpReceivedEvent)entry.getKey();
                EventReceipt receipt = (EventReceipt)entry.getValue();
                StringWriter writer = new StringWriter();
                try {
                    JaxbUtils.marshal((Object)receipt, (Writer)writer);
                }
                catch (DataAccessException e) {
                    this.log().warn("Failed to build event receipt for agent " + InetAddressUtils.str((InetAddress)re.getSender()) + ":" + re.getPort() + ": " + (Object)((Object)e), (Throwable)e);
                }
                String xml = writer.getBuffer().toString();
                try {
                    byte[] xml_bytes = xml.getBytes("US-ASCII");
                    DatagramPacket pkt = new DatagramPacket(xml_bytes, xml_bytes.length, re.getSender(), re.getPort());
                    if (isTracing) {
                        this.log().debug("Transmitting receipt to destination " + InetAddressUtils.str((InetAddress)re.getSender()) + ":" + re.getPort());
                    }
                    this.m_dgSock.send(pkt);
                    List<EventHandler> list2 = this.m_handlers;
                    synchronized (list2) {
                        for (EventHandler handler : this.m_handlers) {
                            try {
                                handler.receiptSent(receipt);
                            }
                            catch (Throwable t) {
                                this.log().warn("Error processing event receipt: " + t, t);
                            }
                        }
                    }
                    if (!isTracing) continue;
                    this.log().debug("Receipt transmitted OK {");
                    this.log().debug(xml);
                    this.log().debug("}");
                }
                catch (UnsupportedEncodingException e) {
                    this.log().warn("Failed to convert XML to byte array: " + e, (Throwable)e);
                }
                catch (IOException e) {
                    this.log().warn("Failed to send packet to host" + InetAddressUtils.str((InetAddress)re.getSender()) + ":" + re.getPort() + ": " + e, (Throwable)e);
                }
            }
            receipts.clear();
        }
        this.log().debug("Context finished, returning");
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

