/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.net.InetAddress;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.xml.event.Event;

final class UdpProcessor
implements Runnable {
    private Thread m_context = null;
    private List<UdpReceivedEvent> m_eventsIn;
    private List<UdpReceivedEvent> m_eventUuidsOut;
    private List<EventHandler> m_handlers;
    private volatile boolean m_stop = false;
    private String m_logPrefix;

    UdpProcessor(List<EventHandler> handlers, List<UdpReceivedEvent> in, List<UdpReceivedEvent> out) {
        this.m_eventsIn = in;
        this.m_eventUuidsOut = out;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            ThreadCategory log = this.log();
            if (log.isDebugEnabled()) {
                log.debug("Stopping and joining thread context " + this.m_context.getName());
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug("Thread context stopped and joined");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            this.log().debug("Stop flag set before thread started, exiting");
            return;
        }
        this.log().debug("Thread context started");
        block16: while (!this.m_stop) {
            this.log().debug("Waiting on a new datagram to arrive");
            UdpReceivedEvent re = null;
            List<UdpReceivedEvent> list = this.m_eventsIn;
            synchronized (list) {
                while (this.m_eventsIn.isEmpty()) {
                    try {
                        this.m_eventsIn.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        this.log().debug("Thread interrupted");
                        break block16;
                    }
                    if (!this.m_stop) continue;
                    this.log().debug("Stop flag is set");
                    break block16;
                }
                re = this.m_eventsIn.remove(0);
            }
            this.log().debug("A new request has arrived");
            Event[] events = null;
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Event from " + InetAddressUtils.str((InetAddress)re.getSender()) + ":" + re.getPort());
                    this.log().debug("Unmarshalling Event text {" + System.getProperty("line.separator") + re.getXmlData() + System.getProperty("line.separator") + "}");
                }
                events = re.unmarshal().getEvents().getEvent();
            }
            catch (MarshalException e) {
                this.log().warn("Failed to unmarshal the event from " + InetAddressUtils.str((InetAddress)re.getSender()) + ":" + re.getPort() + ": " + (Object)((Object)e), (Throwable)e);
                continue;
            }
            catch (ValidationException e) {
                this.log().warn("Failed to validate the event from " + InetAddressUtils.str((InetAddress)re.getSender()) + ":" + re.getPort() + ": " + (Object)((Object)e), (Throwable)e);
                continue;
            }
            if (events == null || events.length == 0) {
                this.log().debug("The event log record contained no events");
                continue;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("Processing " + events.length + " events");
            }
            List<Object> list2 = this.m_handlers;
            synchronized (list2) {
                for (EventHandler handler : this.m_handlers) {
                    for (int ndx = 0; ndx < events.length; ++ndx) {
                        try {
                            if (!handler.processEvent(events[ndx])) continue;
                            re.ackEvent(events[ndx]);
                            continue;
                        }
                        catch (Throwable t) {
                            this.log().warn("Failed to process received UDP event, exception follows", t);
                        }
                    }
                }
            }
            this.log().debug("event processing complete, forwarding to receipt generator");
            list2 = this.m_eventUuidsOut;
            synchronized (list2) {
                this.m_eventUuidsOut.add(re);
            }
        }
        this.log().debug("Context finished, returning");
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

