/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.NotifdConfiguration;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;

public abstract class NotifdConfigManager {
    protected NotifdConfiguration configuration;

    public synchronized void parseXml(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.configuration = (NotifdConfiguration)CastorUtils.unmarshal(NotifdConfiguration.class, (InputStream)stream);
    }

    public NotifdConfiguration getConfiguration() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.configuration;
    }

    protected abstract void update() throws IOException, MarshalException, ValidationException;

    public String getNotificationStatus() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.configuration.getStatus();
    }

    public void turnNotifdOn() throws MarshalException, ValidationException, IOException {
        this.sendEvent("uei.opennms.org/internal/notificationsTurnedOn");
        this.configuration.setStatus("on");
        this.saveCurrent();
    }

    public void turnNotifdOff() throws MarshalException, ValidationException, IOException {
        this.sendEvent("uei.opennms.org/internal/notificationsTurnedOff");
        this.configuration.setStatus("off");
        this.saveCurrent();
    }

    public boolean getNotificationMatch() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.configuration.getMatchAll();
    }

    public synchronized void saveCurrent() throws MarshalException, ValidationException, IOException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.configuration, (Writer)stringWriter);
        String xml = stringWriter.toString();
        this.saveXml(xml);
        this.update();
    }

    protected abstract void saveXml(String var1) throws IOException;

    protected void sendEvent(String uei) {
        EventBuilder bldr = new EventBuilder(uei, "NotifdConfigFactory");
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getNextNotifIdSql() throws IOException, MarshalException, ValidationException {
        return this.getConfiguration().getNextNotifId();
    }

    public boolean matchNotificationParameters(Event event, Notification notification) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean parmmatch = false;
        if (notification.getVarbind() != null && notification.getVarbind().getVbname() != null) {
            String notfValue = null;
            String notfName = notification.getVarbind().getVbname();
            if (notification.getVarbind().getVbvalue() != null) {
                notfValue = notification.getVarbind().getVbvalue();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("BroadcastEventProcessor:matchNotificationParameters:  Null value for varbind, assuming true.");
                }
                parmmatch = true;
            }
            for (Parm parm : event.getParmCollection()) {
                String parmName = parm.getParmName();
                Value parmValue = parm.getValue();
                if (parmValue == null) continue;
                String parmContent = parmValue.getContent();
                if (!parmName.equals(notfName)) continue;
                if (notfValue.charAt(0) == '~') {
                    if (!parmContent.matches(notfValue.substring(1))) continue;
                    parmmatch = true;
                    continue;
                }
                if (!parmContent.startsWith(notfValue)) continue;
                parmmatch = true;
            }
        } else if (notification.getVarbind() == null || notification.getVarbind().getVbname() == null) {
            parmmatch = true;
        }
        return parmmatch;
    }

    public String getNextUserNotifIdSql() throws IOException, MarshalException, ValidationException {
        return this.getConfiguration().getNextUserNotifId();
    }

    public Collection<AutoAcknowledge> getAutoAcknowledges() throws MarshalException, ValidationException, IOException {
        return this.getConfiguration().getAutoAcknowledgeCollection();
    }

    public Collection<String> getOutageCalendarNames() throws MarshalException, ValidationException, IOException {
        return this.getConfiguration().getOutageCalendarCollection();
    }
}

